/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.RequestType;

public final class CloneWorkspaceRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    public static final CloneConflictBehavior DEFAULT_CLONE_CONFLICT_BEHAVIOR = CloneConflictBehavior.DO_NOT_CLONE;
    public static final CreateWorkspaceRequest.CreateConflictBehavior DEFAULT_CREATE_CONFLICT_BEHAVIOR = CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE;
    private final String nameOfWorkspaceToBeCloned;
    private final String desiredNameOfTargetWorkspace;
    private final CreateWorkspaceRequest.CreateConflictBehavior createConflictBehavior;
    private final CloneConflictBehavior cloneConflictBehavior;
    private String actualWorkspaceName;
    private Location actualLocationOfRoot;

    public CloneWorkspaceRequest(String nameOfWorkspaceToBeCloned, String desiredNameOfTargetWorkspace, CreateWorkspaceRequest.CreateConflictBehavior createConflictBehavior, CloneConflictBehavior cloneConflictBehavior) {
        CheckArg.isNotNull((Object)nameOfWorkspaceToBeCloned, (String)"nameOfWorkspaceToBeCloned");
        CheckArg.isNotNull((Object)desiredNameOfTargetWorkspace, (String)"desiredNameOfTargetWorkspace");
        this.nameOfWorkspaceToBeCloned = nameOfWorkspaceToBeCloned;
        this.desiredNameOfTargetWorkspace = desiredNameOfTargetWorkspace;
        this.createConflictBehavior = createConflictBehavior != null ? createConflictBehavior : DEFAULT_CREATE_CONFLICT_BEHAVIOR;
        this.cloneConflictBehavior = cloneConflictBehavior != null ? cloneConflictBehavior : DEFAULT_CLONE_CONFLICT_BEHAVIOR;
    }

    public String nameOfWorkspaceToBeCloned() {
        return this.nameOfWorkspaceToBeCloned;
    }

    public String desiredNameOfTargetWorkspace() {
        return this.desiredNameOfTargetWorkspace;
    }

    public CreateWorkspaceRequest.CreateConflictBehavior targetConflictBehavior() {
        return this.createConflictBehavior;
    }

    public CloneConflictBehavior cloneConflictBehavior() {
        return this.cloneConflictBehavior;
    }

    public String getActualWorkspaceName() {
        return this.actualWorkspaceName;
    }

    public void setActualWorkspaceName(String actualWorkspaceName) {
        this.checkNotFrozen();
        this.actualWorkspaceName = actualWorkspaceName;
    }

    public Location getActualLocationOfRoot() {
        return this.actualLocationOfRoot;
    }

    public void setActualRootLocation(Location actualLocationOfRoot) {
        this.checkNotFrozen();
        this.actualLocationOfRoot = actualLocationOfRoot;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocationOfRoot = null;
        this.actualWorkspaceName = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.nameOfWorkspaceToBeCloned, this.desiredNameOfTargetWorkspace});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            CloneWorkspaceRequest that = (CloneWorkspaceRequest)obj;
            if (!this.nameOfWorkspaceToBeCloned.equals(that.nameOfWorkspaceToBeCloned())) {
                return false;
            }
            return this.desiredNameOfTargetWorkspace.equals(that.desiredNameOfTargetWorkspace());
        }
        return false;
    }

    public String toString() {
        return "clone workspace '" + this.nameOfWorkspaceToBeCloned() + "' as workspace '" + this.desiredNameOfTargetWorkspace() + "'";
    }

    @Override
    public Location changedLocation() {
        return this.actualLocationOfRoot;
    }

    @Override
    public String changedWorkspace() {
        return this.actualWorkspaceName;
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.actualWorkspaceName != null && this.actualWorkspaceName.equals(workspace);
    }

    @Override
    public CloneWorkspaceRequest clone() {
        CloneWorkspaceRequest request = new CloneWorkspaceRequest(this.nameOfWorkspaceToBeCloned, this.actualWorkspaceName != null ? this.actualWorkspaceName : this.desiredNameOfTargetWorkspace, this.createConflictBehavior, this.cloneConflictBehavior);
        request.setActualRootLocation(this.actualLocationOfRoot);
        request.setActualWorkspaceName(this.actualWorkspaceName);
        return request;
    }

    @Override
    public RequestType getType() {
        return RequestType.CLONE_WORKSPACE;
    }

    public static enum CloneConflictBehavior {
        DO_NOT_CLONE,
        SKIP_CLONE;

    }
}

