/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.engine.SessionFactoryImplementor;
import org.modeshape.common.annotation.AllowedValues;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.store.jpa.EntityManagers;
import org.modeshape.connector.store.jpa.JpaConnectorI18n;
import org.modeshape.connector.store.jpa.Model;
import org.modeshape.connector.store.jpa.model.simple.SimpleModel;
import org.modeshape.connector.store.jpa.util.StoreOptionEntity;
import org.modeshape.connector.store.jpa.util.StoreOptions;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;

@ThreadSafe
public class JpaSource
implements RepositorySource,
ObjectFactory {
    private final Logger LOGGER = Logger.getLogger(JpaSource.class);
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String ROOT_NODE_UUID = "rootNodeUuid";
    protected static final String DATA_SOURCE_JNDI_NAME = "dataSourceJndiName";
    protected static final String DIALECT = "dialect";
    protected static final String USERNAME = "username";
    protected static final String PASSWORD = "password";
    protected static final String SCHEMA_NAME = "schemaName";
    protected static final String URL = "url";
    protected static final String DRIVER_CLASS_NAME = "driverClassName";
    protected static final String DRIVER_CLASSLOADER_NAME = "driverClassloaderName";
    protected static final String ISOLATION_LEVEL = "isolationLevel";
    protected static final String MAXIMUM_CONNECTIONS_IN_POOL = "maximumConnectionsInPool";
    protected static final String MINIMUM_CONNECTIONS_IN_POOL = "minimumConnectionsInPool";
    protected static final String MAXIMUM_CONNECTION_IDLE_TIME_IN_SECONDS = "maximumConnectionIdleTimeInSeconds";
    protected static final String MAXIMUM_SIZE_OF_STATEMENT_CACHE = "maximumSizeOfStatementCache";
    protected static final String NUMBER_OF_CONNECTIONS_TO_BE_ACQUIRED_AS_NEEDED = "numberOfConnectionsToBeAcquiredAsNeeded";
    protected static final String IDLE_TIME_IN_SECONDS_BEFORE_TESTING_CONNECTIONS = "idleTimeInSecondsBeforeTestingConnections";
    protected static final String CACHE_TIME_TO_LIVE_IN_MILLISECONDS = "cacheTimeToLiveInMilliseconds";
    protected static final String RETRY_LIMIT = "retryLimit";
    protected static final String MODEL_NAME = "modelName";
    protected static final String LARGE_VALUE_SIZE_IN_BYTES = "largeValueSizeInBytes";
    protected static final String COMPRESS_DATA = "compressData";
    protected static final String ENFORCE_REFERENTIAL_INTEGRITY = "enforceReferentialIntegrity";
    protected static final String DEFAULT_WORKSPACE = "defaultWorkspace";
    protected static final String PREDEFINED_WORKSPACE_NAMES = "predefinedWorkspaceNames";
    protected static final String ALLOW_CREATING_WORKSPACES = "allowCreatingWorkspaces";
    protected static final String AUTO_GENERATE_SCHEMA = "autoGenerateSchema";
    protected static final boolean SUPPORTS_EVENTS = true;
    protected static final boolean SUPPORTS_AUTOMATIC_GARBAGE_COLLECTION = false;
    protected static final boolean SUPPORTS_SAME_NAME_SIBLINGS = true;
    protected static final boolean SUPPORTS_REFERENCES = true;
    public static final boolean DEFAULT_ALLOWS_UPDATES = true;
    public static final boolean DEFAULT_SHOW_SQL = false;
    public static final boolean DEFAULT_SUPPORTS_CREATING_WORKSPACES = true;
    public static final String DEFAULT_ROOT_NODE_UUID = "1497b6fe-8c7e-4bbb-aaa2-24f3d4942668";
    public static final String DEFAULT_NAME_OF_DEFAULT_WORKSPACE = "default";
    public static final String DEFAULT_SCHEMA_NAME = null;
    private static final Integer DEFAULT_ISOLATION_LEVEL = null;
    private static final int DEFAULT_RETRY_LIMIT = 0;
    private static final int DEFAULT_CACHE_TIME_TO_LIVE_IN_SECONDS = 300;
    private static final int DEFAULT_MAXIMUM_FETCH_DEPTH = 3;
    private static final int DEFAULT_MAXIMUM_CONNECTIONS_IN_POOL = 5;
    private static final int DEFAULT_MINIMUM_CONNECTIONS_IN_POOL = 0;
    private static final int DEFAULT_MAXIMUM_CONNECTION_IDLE_TIME_IN_SECONDS = 600;
    private static final int DEFAULT_MAXIMUM_NUMBER_OF_STATEMENTS_TO_CACHE = 100;
    private static final int DEFAULT_NUMBER_OF_CONNECTIONS_TO_ACQUIRE_AS_NEEDED = 1;
    private static final int DEFAULT_IDLE_TIME_IN_SECONDS_BEFORE_TESTING_CONNECTIONS = 180;
    private static final int DEFAULT_LARGE_VALUE_SIZE_IN_BYTES = 1024;
    private static final boolean DEFAULT_COMPRESS_DATA = true;
    private static final boolean DEFAULT_ENFORCE_REFERENTIAL_INTEGRITY = true;
    public static final String AUTO_GENERATE_SCHEMA_DISABLE = "disable";
    public static final String DEFAULT_AUTO_GENERATE_SCHEMA = "validate";
    private static final long serialVersionUID = 1L;
    @Description(i18n=JpaConnectorI18n.class, value="namePropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="namePropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="namePropertyCategory")
    private volatile String name;
    @Description(i18n=JpaConnectorI18n.class, value="dataSourceJndiNamePropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="dataSourceJndiNamePropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="dataSourceJndiNamePropertyCategory")
    private volatile String dataSourceJndiName;
    @Description(i18n=JpaConnectorI18n.class, value="dialectPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="dialectPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="dialectPropertyCategory")
    private volatile String dialect;
    @Description(i18n=JpaConnectorI18n.class, value="usernamePropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="usernamePropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="usernamePropertyCategory")
    private volatile String username;
    @Description(i18n=JpaConnectorI18n.class, value="passwordPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="passwordPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="passwordPropertyCategory")
    private volatile String password;
    @Description(i18n=JpaConnectorI18n.class, value="schemaNamePropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="schemaNamePropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="schemaNamePropertyCategory")
    private volatile String schemaName = DEFAULT_SCHEMA_NAME;
    @Description(i18n=JpaConnectorI18n.class, value="urlPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="urlPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="urlPropertyCategory")
    private volatile String url;
    @Description(i18n=JpaConnectorI18n.class, value="driverClassNamePropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="driverClassNamePropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="driverClassNamePropertyCategory")
    private volatile String driverClassName;
    private volatile String driverClassloaderName;
    @Description(i18n=JpaConnectorI18n.class, value="rootNodeUuidPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="rootNodeUuidPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="rootNodeUuidPropertyCategory")
    private volatile String rootNodeUuid = "1497b6fe-8c7e-4bbb-aaa2-24f3d4942668";
    @Description(i18n=JpaConnectorI18n.class, value="maximumConnectionsInPoolPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="maximumConnectionsInPoolPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="maximumConnectionsInPoolPropertyCategory")
    private volatile int maximumConnectionsInPool = 5;
    @Description(i18n=JpaConnectorI18n.class, value="minimumConnectionsInPoolPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="minimumConnectionsInPoolPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="minimumConnectionsInPoolPropertyCategory")
    private volatile int minimumConnectionsInPool = 0;
    @Description(i18n=JpaConnectorI18n.class, value="maximumConnectionIdleTimeInSecondsPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="maximumConnectionIdleTimeInSecondsPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="maximumConnectionIdleTimeInSecondsPropertyCategory")
    private volatile int maximumConnectionIdleTimeInSeconds = 600;
    @Description(i18n=JpaConnectorI18n.class, value="maximumSizeOfStatementCachePropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="maximumSizeOfStatementCachePropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="maximumSizeOfStatementCachePropertyCategory")
    private volatile int maximumSizeOfStatementCache = 100;
    @Description(i18n=JpaConnectorI18n.class, value="numberOfConnectionsToAcquireAsNeededPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="numberOfConnectionsToAcquireAsNeededPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="numberOfConnectionsToAcquireAsNeededPropertyCategory")
    private volatile int numberOfConnectionsToAcquireAsNeeded = 1;
    @Description(i18n=JpaConnectorI18n.class, value="idleTimeInSecondsBeforeTestingConnectionsPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="idleTimeInSecondsBeforeTestingConnectionsPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="idleTimeInSecondsBeforeTestingConnectionsPropertyCategory")
    private volatile int idleTimeInSecondsBeforeTestingConnections = 180;
    @Description(i18n=JpaConnectorI18n.class, value="retryLimitPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="retryLimitPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="retryLimitPropertyCategory")
    private volatile int retryLimit = 0;
    @Description(i18n=JpaConnectorI18n.class, value="cacheTimeToLiveInMillisecondsPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="cacheTimeToLiveInMillisecondsPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="cacheTimeToLiveInMillisecondsPropertyCategory")
    private volatile int cacheTimeToLiveInMilliseconds = 300000;
    @Description(i18n=JpaConnectorI18n.class, value="largeValueSizeInBytesPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="largeValueSizeInBytesPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="largeValueSizeInBytesPropertyCategory")
    private volatile long largeValueSizeInBytes = 1024L;
    @Description(i18n=JpaConnectorI18n.class, value="showSqlPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="showSqlPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="showSqlPropertyCategory")
    private volatile boolean showSql = false;
    @Description(i18n=JpaConnectorI18n.class, value="compressDataPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="compressDataPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="compressDataPropertyCategory")
    private volatile boolean compressData = true;
    private volatile boolean referentialIntegrityEnforced = true;
    @Description(i18n=JpaConnectorI18n.class, value="autoGenerateSchemaPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="autoGenerateSchemaPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="autoGenerateSchemaPropertyCategory")
    @AllowedValues(value={"create", "create-drop", "update", "validate"})
    private volatile String autoGenerateSchema = "validate";
    @Description(i18n=JpaConnectorI18n.class, value="defaultWorkspaceNamePropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="defaultWorkspaceNamePropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="defaultWorkspaceNamePropertyCategory")
    private volatile String defaultWorkspace = "default";
    @Description(i18n=JpaConnectorI18n.class, value="isolationLevelPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="isolationLevelPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="isolationLevelPropertyCategory")
    private volatile Integer isolationLevel = DEFAULT_ISOLATION_LEVEL;
    @Description(i18n=JpaConnectorI18n.class, value="predefinedWorkspaceNamesPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="predefinedWorkspaceNamesPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="predefinedWorkspaceNamesPropertyCategory")
    private volatile String[] predefinedWorkspaces = new String[0];
    private volatile RepositorySourceCapabilities capabilities = new RepositorySourceCapabilities(true, true, true, true, true).withAutomaticGarbageCollection(false);
    @Description(i18n=JpaConnectorI18n.class, value="modelNamePropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="modelNamePropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="modelNamePropertyCategory")
    private volatile String modelName;
    private transient Model model;
    private transient DataSource dataSource;
    private transient EntityManagers entityManagers;
    private transient CachePolicy cachePolicy;
    private transient RepositoryContext repositoryContext;
    private transient UUID rootUuid = UUID.fromString(this.rootNodeUuid);

    public String getName() {
        return this.name;
    }

    protected Logger getLogger() {
        return this.LOGGER;
    }

    public void setName(String name) {
        if (name != null && (name = name.trim()).length() == 0) {
            name = null;
        }
        this.name = name;
    }

    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Description(i18n=JpaConnectorI18n.class, value="updatesAllowedPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="updatesAllowedPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="updatesAllowedPropertyCategory")
    public boolean areUpdatesAllowed() {
        return this.capabilities.supportsUpdates();
    }

    public synchronized void setAllowsUpdates(boolean allowsUpdates) {
        this.capabilities = new RepositorySourceCapabilities(this.capabilities.supportsSameNameSiblings(), allowsUpdates, this.capabilities.supportsEvents(), this.capabilities.supportsCreatingWorkspaces(), this.capabilities.supportsReferences());
    }

    public boolean getShowSql() {
        return this.showSql;
    }

    public synchronized void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public String getAutoGenerateSchema() {
        return this.autoGenerateSchema;
    }

    public synchronized void setAutoGenerateSchema(String autoGenerateSchema) {
        if (autoGenerateSchema == null || autoGenerateSchema.length() == 0) {
            autoGenerateSchema = DEFAULT_AUTO_GENERATE_SCHEMA;
        }
        if (AUTO_GENERATE_SCHEMA_DISABLE.equalsIgnoreCase(autoGenerateSchema = autoGenerateSchema.trim())) {
            autoGenerateSchema = AUTO_GENERATE_SCHEMA_DISABLE;
        }
        this.autoGenerateSchema = autoGenerateSchema;
        assert (this.autoGenerateSchema != null);
        assert (this.autoGenerateSchema.length() != 0);
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public synchronized void setRetryLimit(int limit) {
        if (limit < 0) {
            limit = 0;
        }
        this.retryLimit = limit;
    }

    public int getCacheTimeToLiveInMilliseconds() {
        return this.cacheTimeToLiveInMilliseconds;
    }

    public synchronized void setCacheTimeToLiveInMilliseconds(int cacheTimeToLive) {
        if (cacheTimeToLive < 0) {
            cacheTimeToLive = 300;
        }
        this.cacheTimeToLiveInMilliseconds = cacheTimeToLive;
        this.cachePolicy = this.cacheTimeToLiveInMilliseconds > 0 ? new JpaCachePolicy(this.cacheTimeToLiveInMilliseconds) : null;
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public EntityManagers getEntityManagers() {
        return this.entityManagers;
    }

    public String getRootNodeUuid() {
        return this.rootNodeUuid;
    }

    public UUID getRootUuid() {
        return this.rootUuid;
    }

    public void setRootNodeUuid(String rootNodeUuid) {
        if (rootNodeUuid != null && rootNodeUuid.trim().length() == 0) {
            rootNodeUuid = DEFAULT_ROOT_NODE_UUID;
        }
        this.rootUuid = UUID.fromString(rootNodeUuid);
        this.rootNodeUuid = rootNodeUuid;
    }

    public String getDefaultWorkspaceName() {
        return this.defaultWorkspace;
    }

    public synchronized void setDefaultWorkspaceName(String nameOfDefaultWorkspace) {
        this.defaultWorkspace = nameOfDefaultWorkspace != null ? nameOfDefaultWorkspace : DEFAULT_NAME_OF_DEFAULT_WORKSPACE;
    }

    public synchronized String[] getPredefinedWorkspaceNames() {
        String[] copy = new String[this.predefinedWorkspaces.length];
        System.arraycopy(this.predefinedWorkspaces, 0, copy, 0, this.predefinedWorkspaces.length);
        return copy;
    }

    public synchronized void setPredefinedWorkspaceNames(String[] predefinedWorkspaceNames) {
        if (predefinedWorkspaceNames != null && predefinedWorkspaceNames.length == 1) {
            predefinedWorkspaceNames = predefinedWorkspaceNames[0].split("\\s*,\\s*");
        }
        this.predefinedWorkspaces = predefinedWorkspaceNames != null ? predefinedWorkspaceNames : new String[]{};
    }

    @Description(i18n=JpaConnectorI18n.class, value="creatingWorkspacesAllowedPropertyDescription")
    @Label(i18n=JpaConnectorI18n.class, value="creatingWorkspacesAllowedPropertyLabel")
    @Category(i18n=JpaConnectorI18n.class, value="creatingWorkspacesAllowedPropertyCategory")
    public boolean isCreatingWorkspacesAllowed() {
        return this.capabilities.supportsCreatingWorkspaces();
    }

    public synchronized void setCreatingWorkspacesAllowed(boolean allowWorkspaceCreation) {
        this.capabilities = new RepositorySourceCapabilities(this.capabilities.supportsSameNameSiblings(), this.capabilities.supportsUpdates(), this.capabilities.supportsEvents(), allowWorkspaceCreation, this.capabilities.supportsReferences());
    }

    public String getDialect() {
        return this.dialect;
    }

    public synchronized void setDialect(String dialect) {
        if (dialect != null && dialect.trim().length() == 0) {
            dialect = null;
        }
        this.dialect = dialect;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        if (dataSourceJndiName != null && dataSourceJndiName.trim().length() == 0) {
            dataSourceJndiName = null;
        }
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public synchronized void setDriverClassName(String driverClassName) {
        if (driverClassName != null && driverClassName.trim().length() == 0) {
            driverClassName = null;
        }
        this.driverClassName = driverClassName;
    }

    public String getDriverClassloaderName() {
        return this.driverClassloaderName;
    }

    public void setDriverClassloaderName(String driverClassloaderName) {
        if (driverClassloaderName != null && driverClassloaderName.trim().length() == 0) {
            driverClassloaderName = null;
        }
        this.driverClassloaderName = driverClassloaderName;
    }

    public String getUsername() {
        return this.username;
    }

    public synchronized void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public synchronized void setPassword(String password) {
        this.password = password;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public synchronized void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getUrl() {
        return this.url;
    }

    public synchronized void setUrl(String url) {
        if (url != null && url.trim().length() == 0) {
            url = null;
        }
        this.url = url;
    }

    public int getMaximumConnectionsInPool() {
        return this.maximumConnectionsInPool;
    }

    public synchronized void setMaximumConnectionsInPool(int maximumConnectionsInPool) {
        if (maximumConnectionsInPool < 0) {
            maximumConnectionsInPool = 5;
        }
        this.maximumConnectionsInPool = maximumConnectionsInPool;
    }

    public int getMinimumConnectionsInPool() {
        return this.minimumConnectionsInPool;
    }

    public synchronized void setMinimumConnectionsInPool(int minimumConnectionsInPool) {
        if (minimumConnectionsInPool < 0) {
            minimumConnectionsInPool = 0;
        }
        this.minimumConnectionsInPool = minimumConnectionsInPool;
    }

    public int getMaximumConnectionIdleTimeInSeconds() {
        return this.maximumConnectionIdleTimeInSeconds;
    }

    public synchronized void setMaximumConnectionIdleTimeInSeconds(int maximumConnectionIdleTimeInSeconds) {
        if (maximumConnectionIdleTimeInSeconds < 0) {
            maximumConnectionIdleTimeInSeconds = 600;
        }
        this.maximumConnectionIdleTimeInSeconds = maximumConnectionIdleTimeInSeconds;
    }

    public int getMaximumSizeOfStatementCache() {
        return this.maximumSizeOfStatementCache;
    }

    public synchronized void setMaximumSizeOfStatementCache(int maximumSizeOfStatementCache) {
        if (maximumSizeOfStatementCache < 0) {
            maximumSizeOfStatementCache = 100;
        }
        this.maximumSizeOfStatementCache = maximumSizeOfStatementCache;
    }

    public int getNumberOfConnectionsToAcquireAsNeeded() {
        return this.numberOfConnectionsToAcquireAsNeeded;
    }

    public synchronized void setNumberOfConnectionsToAcquireAsNeeded(int numberOfConnectionsToAcquireAsNeeded) {
        if (numberOfConnectionsToAcquireAsNeeded < 0) {
            numberOfConnectionsToAcquireAsNeeded = 1;
        }
        this.numberOfConnectionsToAcquireAsNeeded = numberOfConnectionsToAcquireAsNeeded;
    }

    public int getIdleTimeInSecondsBeforeTestingConnections() {
        return this.idleTimeInSecondsBeforeTestingConnections;
    }

    public synchronized void setIdleTimeInSecondsBeforeTestingConnections(int idleTimeInSecondsBeforeTestingConnections) {
        if (idleTimeInSecondsBeforeTestingConnections < 0) {
            idleTimeInSecondsBeforeTestingConnections = 180;
        }
        this.idleTimeInSecondsBeforeTestingConnections = idleTimeInSecondsBeforeTestingConnections;
    }

    DataSource getDataSource() {
        return this.dataSource;
    }

    synchronized void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getModel() {
        return this.modelName;
    }

    public synchronized void setModel(String modelName) {
        if (modelName != null && (modelName = modelName.trim()).length() == 0) {
            modelName = null;
        }
        if (modelName == null) {
            this.model = null;
            return;
        }
        Model model = Models.getModel(modelName);
        if (model == null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Model existing : Models.ALL) {
                if (!first) {
                    first = false;
                    sb.append(", ");
                }
                sb.append('\"').append(existing.getName()).append('\"');
            }
            String modelNames = sb.toString();
            throw new IllegalArgumentException(JpaConnectorI18n.unknownModelName.text(new Object[]{model, modelNames}));
        }
        this.model = model;
        this.modelName = modelName;
    }

    public long getLargeValueSizeInBytes() {
        return this.largeValueSizeInBytes;
    }

    public void setLargeValueSizeInBytes(long largeValueSizeInBytes) {
        if (largeValueSizeInBytes < 0L) {
            largeValueSizeInBytes = 1024L;
        }
        this.largeValueSizeInBytes = largeValueSizeInBytes;
    }

    public boolean isCompressData() {
        return this.compressData;
    }

    public void setCompressData(boolean compressData) {
        this.compressData = compressData;
    }

    public boolean isReferentialIntegrityEnforced() {
        return this.referentialIntegrityEnforced;
    }

    public void setReferentialIntegrityEnforced(boolean referentialIntegrityEnforced) {
        this.referentialIntegrityEnforced = referentialIntegrityEnforced;
    }

    public Integer getIsolationLevel() {
        return this.isolationLevel;
    }

    public synchronized void setIsolationLevel(Integer isolationLevel) {
        if (isolationLevel == null) {
            isolationLevel = DEFAULT_ISOLATION_LEVEL;
        }
        if (isolationLevel != DEFAULT_ISOLATION_LEVEL && isolationLevel != 0 && isolationLevel != 2 && isolationLevel != 1 && isolationLevel != 4 && isolationLevel != 8) {
            throw new RepositorySourceException(this.name, JpaConnectorI18n.invalidIsolationLevel.text(new Object[]{isolationLevel}));
        }
        if (this.isolationLevel == isolationLevel) {
            return;
        }
        EntityManagers oldEntityManagers = this.entityManagers;
        this.entityManagers = null;
        oldEntityManagers.close();
        this.isolationLevel = isolationLevel;
    }

    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context;
    }

    public Reference getReference() {
        String className = this.getClass().getName();
        String factoryClassName = this.getClass().getName();
        Reference ref = new Reference(className, factoryClassName, null);
        ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        ref.add(new StringRefAddr(ROOT_NODE_UUID, this.getRootNodeUuid()));
        ref.add(new StringRefAddr(DATA_SOURCE_JNDI_NAME, this.getDataSourceJndiName()));
        ref.add(new StringRefAddr(DIALECT, this.getDialect()));
        ref.add(new StringRefAddr(USERNAME, this.getUsername()));
        ref.add(new StringRefAddr(PASSWORD, this.getPassword()));
        if (this.getSchemaName() != null) {
            ref.add(new StringRefAddr(SCHEMA_NAME, this.getSchemaName()));
        }
        ref.add(new StringRefAddr(URL, this.getUrl()));
        ref.add(new StringRefAddr(DRIVER_CLASS_NAME, this.getDriverClassName()));
        ref.add(new StringRefAddr(DRIVER_CLASSLOADER_NAME, this.getDriverClassloaderName()));
        ref.add(new StringRefAddr(ISOLATION_LEVEL, Integer.toString(this.getIsolationLevel())));
        ref.add(new StringRefAddr(MAXIMUM_CONNECTIONS_IN_POOL, Integer.toString(this.getMaximumConnectionsInPool())));
        ref.add(new StringRefAddr(MINIMUM_CONNECTIONS_IN_POOL, Integer.toString(this.getMinimumConnectionsInPool())));
        ref.add(new StringRefAddr(MAXIMUM_CONNECTION_IDLE_TIME_IN_SECONDS, Integer.toString(this.getMaximumConnectionIdleTimeInSeconds())));
        ref.add(new StringRefAddr(MAXIMUM_SIZE_OF_STATEMENT_CACHE, Integer.toString(this.getMaximumSizeOfStatementCache())));
        ref.add(new StringRefAddr(NUMBER_OF_CONNECTIONS_TO_BE_ACQUIRED_AS_NEEDED, Integer.toString(this.getNumberOfConnectionsToAcquireAsNeeded())));
        ref.add(new StringRefAddr(IDLE_TIME_IN_SECONDS_BEFORE_TESTING_CONNECTIONS, Integer.toString(this.getIdleTimeInSecondsBeforeTestingConnections())));
        ref.add(new StringRefAddr(CACHE_TIME_TO_LIVE_IN_MILLISECONDS, Integer.toString(this.getCacheTimeToLiveInMilliseconds())));
        ref.add(new StringRefAddr(LARGE_VALUE_SIZE_IN_BYTES, Long.toString(this.getLargeValueSizeInBytes())));
        ref.add(new StringRefAddr(COMPRESS_DATA, Boolean.toString(this.isCompressData())));
        ref.add(new StringRefAddr(ENFORCE_REFERENTIAL_INTEGRITY, Boolean.toString(this.isReferentialIntegrityEnforced())));
        ref.add(new StringRefAddr(DEFAULT_WORKSPACE, this.getDefaultWorkspaceName()));
        ref.add(new StringRefAddr(ALLOW_CREATING_WORKSPACES, Boolean.toString(this.isCreatingWorkspacesAllowed())));
        ref.add(new StringRefAddr(AUTO_GENERATE_SCHEMA, this.getAutoGenerateSchema()));
        String[] workspaceNames = this.getPredefinedWorkspaceNames();
        if (workspaceNames != null && workspaceNames.length != 0) {
            ref.add(new StringRefAddr(PREDEFINED_WORKSPACE_NAMES, StringUtil.combineLines((String[])workspaceNames)));
        }
        if (this.getModel() != null) {
            ref.add(new StringRefAddr(MODEL_NAME, this.getModel()));
        }
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        return ref;
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, String> values = new HashMap<String, String>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                RefAddr subref = en.nextElement();
                if (!(subref instanceof StringRefAddr)) continue;
                String key = subref.getType();
                Object value = subref.getContent();
                if (value == null) continue;
                values.put(key, value.toString());
            }
            String sourceName = (String)values.get(SOURCE_NAME);
            String rootNodeUuid = (String)values.get(ROOT_NODE_UUID);
            String dataSourceJndiName = (String)values.get(DATA_SOURCE_JNDI_NAME);
            String dialect = (String)values.get(DIALECT);
            String username = (String)values.get(USERNAME);
            String password = (String)values.get(PASSWORD);
            String schemaName = (String)values.get(SCHEMA_NAME);
            String url = (String)values.get(URL);
            String driverClassName = (String)values.get(DRIVER_CLASS_NAME);
            String driverClassloaderName = (String)values.get(DRIVER_CLASSLOADER_NAME);
            String isolationLevel = (String)values.get(ISOLATION_LEVEL);
            String maxConnectionsInPool = (String)values.get(MAXIMUM_CONNECTIONS_IN_POOL);
            String minConnectionsInPool = (String)values.get(MINIMUM_CONNECTIONS_IN_POOL);
            String maxConnectionIdleTimeInSec = (String)values.get(MAXIMUM_CONNECTION_IDLE_TIME_IN_SECONDS);
            String maxSizeOfStatementCache = (String)values.get(MAXIMUM_SIZE_OF_STATEMENT_CACHE);
            String acquisitionIncrement = (String)values.get(NUMBER_OF_CONNECTIONS_TO_BE_ACQUIRED_AS_NEEDED);
            String idleTimeInSeconds = (String)values.get(IDLE_TIME_IN_SECONDS_BEFORE_TESTING_CONNECTIONS);
            String cacheTtlInMillis = (String)values.get(CACHE_TIME_TO_LIVE_IN_MILLISECONDS);
            String modelName = (String)values.get(MODEL_NAME);
            String retryLimit = (String)values.get(RETRY_LIMIT);
            String largeModelSize = (String)values.get(LARGE_VALUE_SIZE_IN_BYTES);
            String compressData = (String)values.get(COMPRESS_DATA);
            String refIntegrity = (String)values.get(ENFORCE_REFERENTIAL_INTEGRITY);
            String defaultWorkspace = (String)values.get(DEFAULT_WORKSPACE);
            String createWorkspaces = (String)values.get(ALLOW_CREATING_WORKSPACES);
            String autoGenerateSchema = (String)values.get(AUTO_GENERATE_SCHEMA);
            String combinedWorkspaceNames = (String)values.get(PREDEFINED_WORKSPACE_NAMES);
            String[] workspaceNames = null;
            if (combinedWorkspaceNames != null) {
                List paths = StringUtil.splitLines((String)combinedWorkspaceNames);
                workspaceNames = paths.toArray(new String[paths.size()]);
            }
            JpaSource source = new JpaSource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (rootNodeUuid != null) {
                source.setRootNodeUuid(rootNodeUuid);
            }
            if (dataSourceJndiName != null) {
                source.setDataSourceJndiName(dataSourceJndiName);
            }
            if (dialect != null) {
                source.setDialect(dialect);
            }
            if (username != null) {
                source.setUsername(username);
            }
            if (password != null) {
                source.setPassword(password);
            }
            if (schemaName != null) {
                source.setSchemaName(schemaName);
            }
            if (url != null) {
                source.setUrl(url);
            }
            if (driverClassName != null) {
                source.setDriverClassName(driverClassName);
            }
            if (driverClassloaderName != null) {
                source.setDriverClassloaderName(driverClassloaderName);
            }
            if (isolationLevel != null) {
                source.setIsolationLevel(Integer.parseInt(isolationLevel));
            }
            if (maxConnectionsInPool != null) {
                source.setMaximumConnectionsInPool(Integer.parseInt(maxConnectionsInPool));
            }
            if (minConnectionsInPool != null) {
                source.setMinimumConnectionsInPool(Integer.parseInt(minConnectionsInPool));
            }
            if (maxConnectionIdleTimeInSec != null) {
                source.setMaximumConnectionIdleTimeInSeconds(Integer.parseInt(maxConnectionIdleTimeInSec));
            }
            if (maxSizeOfStatementCache != null) {
                source.setMaximumSizeOfStatementCache(Integer.parseInt(maxSizeOfStatementCache));
            }
            if (acquisitionIncrement != null) {
                source.setNumberOfConnectionsToAcquireAsNeeded(Integer.parseInt(acquisitionIncrement));
            }
            if (idleTimeInSeconds != null) {
                source.setIdleTimeInSecondsBeforeTestingConnections(Integer.parseInt(idleTimeInSeconds));
            }
            if (cacheTtlInMillis != null) {
                source.setCacheTimeToLiveInMilliseconds(Integer.parseInt(cacheTtlInMillis));
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            if (modelName != null) {
                source.setModel(modelName);
            }
            if (largeModelSize != null) {
                source.setLargeValueSizeInBytes(Long.parseLong(largeModelSize));
            }
            if (compressData != null) {
                source.setCompressData(Boolean.parseBoolean(compressData));
            }
            if (refIntegrity != null) {
                source.setReferentialIntegrityEnforced(Boolean.parseBoolean(refIntegrity));
            }
            if (defaultWorkspace != null) {
                source.setDefaultWorkspaceName(defaultWorkspace);
            }
            if (createWorkspaces != null) {
                source.setCreatingWorkspacesAllowed(Boolean.parseBoolean(createWorkspaces));
            }
            if (workspaceNames != null && workspaceNames.length != 0) {
                source.setPredefinedWorkspaceNames(workspaceNames);
            }
            if (autoGenerateSchema != null) {
                source.setAutoGenerateSchema(autoGenerateSchema);
            }
            return source;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.name == null || this.name.trim().length() == 0) {
            throw new RepositorySourceException(JpaConnectorI18n.repositorySourceMustHaveName.text(new Object[0]));
        }
        assert (this.rootNodeUuid != null);
        assert (this.rootUuid != null);
        if (this.entityManagers == null) {
            InitialContext context;
            Ejb3Configuration configurator = new Ejb3Configuration();
            configurator.addAnnotatedClass(StoreOptionEntity.class);
            if (this.dialect != null) {
                this.setProperty(configurator, "hibernate.dialect", this.dialect);
            }
            if (this.isolationLevel != null) {
                this.setProperty(configurator, "hibernate.connection.isolation", this.isolationLevel);
            }
            if (this.schemaName != null) {
                this.setProperty(configurator, "hibernate.default_schema", this.schemaName);
            }
            this.configure(configurator);
            if (this.dataSource == null && this.dataSourceJndiName != null) {
                try {
                    context = new InitialContext();
                    this.dataSource = (DataSource)context.lookup(this.dataSourceJndiName);
                }
                catch (Throwable t) {
                    Logger.getLogger(this.getClass()).error(t, JpaConnectorI18n.errorFindingDataSourceInJndi, new Object[]{this.name, this.dataSourceJndiName});
                }
            }
            if (this.dataSource != null) {
                configurator.setDataSource(this.dataSource);
            } else {
                if (this.repositoryContext != null && this.driverClassloaderName != null) {
                    try {
                        context = this.repositoryContext.getExecutionContext();
                        ClassLoader loader = context.getClassLoader(new String[]{this.driverClassloaderName});
                        if (loader != null) {
                            Thread.currentThread().setContextClassLoader(loader);
                        }
                    }
                    catch (Throwable t) {
                        I18n msg = JpaConnectorI18n.errorSettingContextClassLoader;
                        Logger.getLogger(this.getClass()).error(t, msg, new Object[]{this.name, this.driverClassloaderName});
                    }
                }
                this.setProperty(configurator, "hibernate.connection.driver_class", this.driverClassName);
                this.setProperty(configurator, "hibernate.connection.username", this.username);
                this.setProperty(configurator, "hibernate.connection.password", this.password);
                this.setProperty(configurator, "hibernate.connection.url", this.url);
                this.setProperty(configurator, "hibernate.max_fetch_depth", 3);
                this.setProperty(configurator, "hibernate.connection.pool_size", 0);
                if (this.maximumConnectionsInPool > 0) {
                    this.setProperty(configurator, "hibernate.connection.provider_class", "org.hibernate.connection.C3P0ConnectionProvider");
                    this.setProperty(configurator, "hibernate.c3p0.max_size", this.maximumConnectionsInPool);
                    this.setProperty(configurator, "hibernate.c3p0.min_size", this.minimumConnectionsInPool);
                    this.setProperty(configurator, "hibernate.c3p0.timeout", this.maximumConnectionIdleTimeInSeconds);
                    this.setProperty(configurator, "hibernate.c3p0.max_statements", this.maximumSizeOfStatementCache);
                    this.setProperty(configurator, "hibernate.c3p0.idle_test_period", this.idleTimeInSecondsBeforeTestingConnections);
                    this.setProperty(configurator, "hibernate.c3p0.acquire_increment", this.numberOfConnectionsToAcquireAsNeeded);
                    this.setProperty(configurator, "hibernate.c3p0.validate", "false");
                }
            }
            Logger logger = this.getLogger();
            if (logger.isDebugEnabled()) {
                logger.debug("Properties for Hibernate configuration used for ModeShape JPA Source {0}:", new Object[]{this.getName()});
                Properties props = configurator.getProperties();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String propName = entry.getKey().toString();
                    if (!propName.startsWith("hibernate")) continue;
                    logger.debug("  {0} = {1}", new Object[]{propName, entry.getValue()});
                }
            }
            EntityManagerFactory entityManagerFactory = configurator.buildEntityManagerFactory();
            try {
                EntityManager entityManager = entityManagerFactory.createEntityManager();
                try {
                    StoreOptions options = new StoreOptions(entityManager);
                    UUID actualUuid = options.getRootNodeUuid();
                    if (actualUuid != null) {
                        this.setRootNodeUuid(actualUuid.toString());
                    } else {
                        options.setRootNodeUuid(this.rootUuid);
                    }
                    String actualModelName = options.getModelName();
                    if (actualModelName == null) {
                        if (this.model == null) {
                            this.setModel(Models.DEFAULT.getName());
                        }
                        assert (this.model != null);
                        options.setModelName(this.model);
                    } else {
                        try {
                            this.setModel(actualModelName);
                        }
                        catch (Throwable e) {
                            String msg = JpaConnectorI18n.existingStoreSpecifiesUnknownModel.text(new Object[]{this.name, actualModelName});
                            throw new RepositorySourceException(msg);
                        }
                    }
                    if (this.dialect == null || this.dialect.trim().length() == 0) {
                        this.dialect = this.determineDialect(entityManager);
                    }
                    if (this.dialect == null || this.dialect.trim().length() == 0) {
                        String msg = JpaConnectorI18n.dialectCouldNotBeDeterminedAndMustBeSpecified.text(new Object[]{this.name});
                        throw new RepositorySourceException(msg);
                    }
                }
                finally {
                    entityManager.close();
                }
            }
            finally {
                entityManagerFactory.close();
            }
            this.model.configure(configurator);
            this.entityManagers = new EntityManagers(configurator);
        }
        return this.model.createConnection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.entityManagers != null) {
            try {
                this.entityManagers.close();
            }
            finally {
                this.entityManagers = null;
            }
        }
    }

    protected String determineDialect(EntityManager entityManager) {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)((Session)entityManager.unwrap(Session.class)).getSessionFactory();
        return sessionFactory.getDialect().toString();
    }

    protected void configure(Ejb3Configuration configuration) {
        this.setProperty(configuration, "hibernate.cache.provider_class", "org.hibernate.cache.NoCacheProvider");
        this.setProperty(configuration, "hibernate.show_sql", String.valueOf(this.showSql));
        this.setProperty(configuration, "hibernate.format_sql", "true");
        this.setProperty(configuration, "hibernate.use_sql_comments", "true");
        if (!AUTO_GENERATE_SCHEMA_DISABLE.equalsIgnoreCase(this.autoGenerateSchema)) {
            this.setProperty(configuration, "hibernate.hbm2ddl.auto", this.autoGenerateSchema);
        }
    }

    protected void setProperty(Ejb3Configuration configurator, String propertyName, String propertyValue) {
        assert (configurator != null);
        assert (propertyName != null);
        assert (propertyName.trim().length() != 0);
        if (propertyValue != null) {
            configurator.setProperty(propertyName, propertyValue.trim());
        }
    }

    protected void setProperty(Ejb3Configuration configurator, String propertyName, int propertyValue) {
        assert (configurator != null);
        assert (propertyName != null);
        assert (propertyName.trim().length() != 0);
        configurator.setProperty(propertyName, Integer.toString(propertyValue));
    }

    @Immutable
    class JpaCachePolicy
    implements CachePolicy {
        private static final long serialVersionUID = 1L;
        private final int ttl;

        JpaCachePolicy(int ttl) {
            this.ttl = ttl;
        }

        public long getTimeToLive() {
            return this.ttl;
        }
    }

    public static class Models {
        public static final Model SIMPLE = new SimpleModel();
        private static final Model[] ALL_ARRAY = new Model[]{SIMPLE};
        private static final List<Model> MODIFIABLE_MODELS = new ArrayList<Model>(Arrays.asList(ALL_ARRAY));
        public static final Collection<Model> ALL = Collections.unmodifiableCollection(MODIFIABLE_MODELS);
        public static final Model DEFAULT = SIMPLE;

        public static boolean addModel(Model model) {
            CheckArg.isNotNull((Object)model, (String)JpaSource.MODEL_NAME);
            for (Model existing : MODIFIABLE_MODELS) {
                if (!existing.getName().equals(model.getName())) continue;
                return false;
            }
            return MODIFIABLE_MODELS.add(model);
        }

        public static Model getModel(String name) {
            CheckArg.isNotEmpty((String)name, (String)"name");
            name = name.trim();
            for (Model existing : ALL) {
                if (!existing.getName().equals(name)) continue;
                return existing;
            }
            return null;
        }
    }
}

