/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.search;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CompositeRequestChannel;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DeleteChildrenRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.search.SearchEngine;
import org.modeshape.graph.search.SearchEngineException;
import org.modeshape.graph.search.SearchEngineProcessor;

@NotThreadSafe
public class SearchEngineIndexer {
    private final ExecutionContext context;
    private final RepositoryConnectionFactory connectionFactory;
    private final String sourceName;
    private final SearchEngine searchEngine;
    private final int maxDepthPerRead;
    private final ExecutorService service;
    private final CompositeRequestChannel channel;
    private final SearchEngineProcessor processor;
    private boolean closed = false;

    public SearchEngineIndexer(ExecutionContext context, SearchEngine searchEngine, RepositoryConnectionFactory connectionFactory, int maxDepthPerRead) {
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull((Object)searchEngine, (String)"searchEngine");
        CheckArg.isNotNull((Object)connectionFactory, (String)"connectionFactory");
        CheckArg.isPositive((int)maxDepthPerRead, (String)"maxDepthPerRead");
        this.context = context;
        this.searchEngine = searchEngine;
        this.sourceName = searchEngine.getSourceName();
        this.connectionFactory = connectionFactory;
        this.channel = new CompositeRequestChannel(this.sourceName);
        this.service = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("search-" + this.sourceName));
        this.channel.start(this.service, this.context, this.connectionFactory);
        this.processor = this.searchEngine.createProcessor(this.context, null, false);
        this.maxDepthPerRead = maxDepthPerRead;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public SearchEngineIndexer reindex(String workspaceName, boolean forceIndexRebuild) throws RepositorySourceException, SearchEngineException {
        if (forceIndexRebuild || !this.searchEngine.indexExists(workspaceName)) {
            Path rootPath = this.context.getValueFactories().getPathFactory().createRootPath();
            this.index(workspaceName, Location.create(rootPath));
        }
        return this;
    }

    public SearchEngineIndexer index(String workspaceName) throws RepositorySourceException, SearchEngineException {
        Path rootPath = this.context.getValueFactories().getPathFactory().createRootPath();
        this.index(workspaceName, Location.create(rootPath));
        return this;
    }

    public SearchEngineIndexer indexAllWorkspaces() throws RepositorySourceException, SearchEngineException {
        GetWorkspacesRequest getWorkspaces = new GetWorkspacesRequest();
        try {
            this.channel.addAndAwait(getWorkspaces);
            this.checkRequestForErrors(getWorkspaces);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return this;
        }
        Path rootPath = this.context.getValueFactories().getPathFactory().createRootPath();
        Location rootLocation = Location.create(rootPath);
        for (String workspaceName : getWorkspaces.getAvailableWorkspaceNames()) {
            this.index(workspaceName, rootLocation);
        }
        return this;
    }

    public SearchEngineIndexer index(String workspaceName, Path path) {
        this.checkNotClosed();
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)path, (String)"path");
        this.indexSubgraph(workspaceName, Location.create(path), Integer.MAX_VALUE);
        return this;
    }

    public SearchEngineIndexer index(String workspaceName, Path path, int depth) {
        this.checkNotClosed();
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isPositive((int)depth, (String)"depth");
        if (depth == 1) {
            this.indexProperties(workspaceName, Location.create(path));
        } else {
            this.indexSubgraph(workspaceName, Location.create(path), depth);
        }
        return this;
    }

    public SearchEngineIndexer index(String workspaceName, Location location) {
        this.checkNotClosed();
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)location, (String)"location");
        this.indexSubgraph(workspaceName, location, Integer.MAX_VALUE);
        return this;
    }

    public SearchEngineIndexer index(String workspaceName, Location location, int depth) {
        this.checkNotClosed();
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)location, (String)"location");
        CheckArg.isPositive((int)depth, (String)"depth");
        if (depth == 1) {
            this.indexProperties(workspaceName, location);
        } else {
            this.indexSubgraph(workspaceName, location, depth);
        }
        return this;
    }

    protected void indexSubgraph(String workspaceName, Location startingLocation, int depth) {
        int depthPerRead = Math.min(this.maxDepthPerRead, depth);
        ReadBranchRequest readSubgraph = new ReadBranchRequest(startingLocation, workspaceName, depthPerRead);
        try {
            this.channel.addAndAwait(readSubgraph);
            this.checkRequestForErrors(readSubgraph);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return;
        }
        catch (InvalidPathException e) {
            this.process(new DeleteBranchRequest(startingLocation, workspaceName));
            return;
        }
        Iterator<Location> locationIter = readSubgraph.iterator();
        assert (locationIter.hasNext());
        if (startingLocation.getPath().isRoot()) {
            this.process(new DeleteBranchRequest(startingLocation, workspaceName));
        } else {
            this.process(new DeleteChildrenRequest(startingLocation, workspaceName));
        }
        Location topNode = locationIter.next();
        assert (topNode.equals(startingLocation));
        Map<Name, Property> properties = readSubgraph.getPropertiesFor(topNode);
        if (properties == null) {
            return;
        }
        if (startingLocation.getPath().isRoot()) {
            Property rootPrimaryType = this.context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.ROOT);
            properties.put(JcrLexicon.PRIMARY_TYPE, rootPrimaryType);
        }
        UpdatePropertiesRequest request = new UpdatePropertiesRequest(topNode, workspaceName, properties, true);
        request.setActualLocationOfNode(topNode);
        this.process(request);
        this.checkRequestForErrors(request);
        HashMap<Path, Location> locationsByPath = new HashMap<Path, Location>();
        locationsByPath.put(startingLocation.getPath(), startingLocation);
        LinkedList<Location> locationsToRead = new LinkedList<Location>();
        block5: while (true) {
            Location location;
            if (locationIter.hasNext()) {
                location = locationIter.next();
                Path path = location.getPath();
                Path parentPath = path.getParent();
                Location parent = readSubgraph.getLocationFor(parentPath);
                if (parent == null) {
                    parent = (Location)locationsByPath.get(parentPath);
                }
                Name childName = path.getLastSegment().getName();
                Collection<Property> nodePoperties = readSubgraph.getPropertiesFor(location).values();
                CreateNodeRequest create = new CreateNodeRequest(parent, workspaceName, childName, nodePoperties);
                create.setActualLocationOfNode(location);
                this.process(create);
                if (create.isCancelled() || create.hasError()) {
                    return;
                }
                boolean recordedParentLocation = false;
                Iterator<Location> i$ = readSubgraph.getChildren(location).iterator();
                while (true) {
                    if (!i$.hasNext()) continue block5;
                    Location child = i$.next();
                    if (readSubgraph.includes(child)) continue;
                    if (!recordedParentLocation) {
                        locationsByPath.put(location.getPath(), location);
                        recordedParentLocation = true;
                    }
                    locationsToRead.add(child);
                }
            }
            if (locationsToRead.isEmpty()) break;
            location = (Location)locationsToRead.poll();
            assert (location != null);
            depthPerRead = Math.min(this.maxDepthPerRead, depth - location.getPath().size());
            if (depthPerRead < 1) continue;
            readSubgraph = new ReadBranchRequest(location, workspaceName, depthPerRead);
            try {
                this.channel.addAndAwait(readSubgraph);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return;
            }
            this.checkRequestForErrors(readSubgraph);
            locationIter = readSubgraph.iterator();
        }
    }

    protected void indexProperties(String workspaceName, Location location) {
        ReadAllPropertiesRequest readProps = new ReadAllPropertiesRequest(location, workspaceName);
        try {
            this.channel.addAndAwait(readProps);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        this.checkRequestForErrors(readProps);
        location = readProps.getActualLocationOfNode();
        Map<Name, Property> properties = readProps.getPropertiesByName();
        UpdatePropertiesRequest request = new UpdatePropertiesRequest(location, workspaceName, properties, true);
        request.setActualLocationOfNode(location);
        this.process(request);
        this.checkRequestForErrors(readProps);
    }

    public final void process(ChangeRequest searchEngineRequest) {
        this.processor.process(searchEngineRequest);
    }

    protected final void checkRequestForErrors(Request request) throws RepositorySourceException, RuntimeException {
        if (request.hasError()) {
            Throwable t = request.getError();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RepositorySourceException(this.sourceName, t);
        }
    }

    protected final void checkNotClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException(GraphI18n.searchEngineIndexerForSourceHasAlreadyBeenClosed.text(new Object[]{this.sourceName}));
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.channel.close();
            Object var2_1 = null;
            this.service.shutdown();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.service.shutdown();
            try {
                try {
                    this.service.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    I18n msg = GraphI18n.errorShuttingDownExecutorServiceInSearchEngineIndexer;
                    Logger.getLogger(this.getClass()).error(msg, new Object[]{this.sourceName});
                    Thread.interrupted();
                    Object var6_7 = null;
                    this.processor.close();
                }
                Object var6_6 = null;
                this.processor.close();
            }
            catch (Throwable throwable2) {
                Object var6_8 = null;
                this.processor.close();
                throw throwable2;
            }
            throw throwable;
        }
        try {
            try {
                this.service.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                I18n msg = GraphI18n.errorShuttingDownExecutorServiceInSearchEngineIndexer;
                Logger.getLogger(this.getClass()).error(msg, new Object[]{this.sourceName});
                Thread.interrupted();
                Object var6_4 = null;
                this.processor.close();
            }
            Object var6_3 = null;
            this.processor.close();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.processor.close();
            throw throwable;
        }
    }
}

