/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import java.lang.reflect.Constructor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.tool.ant.ConfigurationTask;
import org.hibernate.util.ReflectHelper;

public class JDBCConfigurationTask
extends ConfigurationTask {
    private boolean preferBasicCompositeIds = true;
    private String reverseEngineeringStrategyClass;
    private String packageName;
    private Path revengFiles;
    private boolean detectOneToOne = true;
    private boolean detectManyToMany = true;
    private boolean detectOptimisticLock = true;

    public JDBCConfigurationTask() {
        this.setDescription("JDBC Configuration (for reverse engineering)");
    }

    protected Configuration createConfiguration() {
        return new JDBCMetaDataConfiguration();
    }

    protected void doConfiguration(Configuration configuration) {
        JDBCMetaDataConfiguration jmdc = (JDBCMetaDataConfiguration)configuration;
        super.doConfiguration(jmdc);
        jmdc.setPreferBasicCompositeIds(this.preferBasicCompositeIds);
        DefaultReverseEngineeringStrategy defaultStrategy = new DefaultReverseEngineeringStrategy();
        ReverseEngineeringStrategy strategy = defaultStrategy;
        if (this.revengFiles != null) {
            OverrideRepository or = new OverrideRepository();
            String[] fileNames = this.revengFiles.list();
            for (int i = 0; i < fileNames.length; ++i) {
                or.addFile(new File(fileNames[i]));
            }
            strategy = or.getReverseEngineeringStrategy(defaultStrategy);
        }
        if (this.reverseEngineeringStrategyClass != null) {
            strategy = this.loadreverseEngineeringStrategy(this.reverseEngineeringStrategyClass, strategy);
        }
        ReverseEngineeringSettings qqsettings = new ReverseEngineeringSettings(strategy).setDefaultPackageName(this.packageName).setDetectManyToMany(this.detectManyToMany).setDetectOneToOne(this.detectOneToOne).setDetectOptimisticLock(this.detectOptimisticLock);
        defaultStrategy.setSettings(qqsettings);
        strategy.setSettings(qqsettings);
        jmdc.setReverseEngineeringStrategy(strategy);
        jmdc.readFromJDBC();
    }

    public void setPackageName(String pkgName) {
        this.packageName = pkgName;
    }

    public void setReverseStrategy(String fqn) {
        this.reverseEngineeringStrategyClass = fqn;
    }

    public void setRevEngFile(Path p) {
        this.revengFiles = p;
    }

    public void setPreferBasicCompositeIds(boolean b) {
        this.preferBasicCompositeIds = b;
    }

    public void setDetectOneToOne(boolean b) {
        this.detectOneToOne = b;
    }

    public void setDetectManyToMany(boolean b) {
        this.detectManyToMany = b;
    }

    public void setDetectOptimisticLock(boolean b) {
        this.detectOptimisticLock = b;
    }

    private ReverseEngineeringStrategy loadreverseEngineeringStrategy(String className, ReverseEngineeringStrategy delegate) throws BuildException {
        try {
            Class clazz = ReflectHelper.classForName((String)className);
            Constructor constructor = clazz.getConstructor(ReverseEngineeringStrategy.class);
            return (ReverseEngineeringStrategy)constructor.newInstance(delegate);
        }
        catch (NoSuchMethodException e) {
            try {
                this.getProject().log("Could not find public " + className + "(ReverseEngineeringStrategy delegate) constructor on ReverseEngineeringStrategy. Trying no-arg version.", 3);
                Class clazz = ReflectHelper.classForName((String)className);
                ReverseEngineeringStrategy rev = (ReverseEngineeringStrategy)clazz.newInstance();
                this.getProject().log("Using non-delegating strategy, thus packagename and revengfile will be ignored.", 2);
                return rev;
            }
            catch (Exception eq) {
                throw new BuildException("Could not create or find " + className + " with default no-arg constructor", (Throwable)eq);
            }
        }
        catch (Exception e) {
            throw new BuildException("Could not create or find " + className + " with one argument delegate constructor", (Throwable)e);
        }
    }
}

