/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.marshall.Marshallable;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.notifications.cachelistener.CacheNotifier;

@Marshallable(externalizer=ReplicableCommandExternalizer.class, id=35)
public class InvalidateL1Command
extends InvalidateCommand {
    public static final int COMMAND_ID = 7;
    private DistributionManager dm;
    private DataContainer dataContainer;
    private Configuration config;
    private boolean forRehash;

    public InvalidateL1Command() {
    }

    public InvalidateL1Command(boolean forRehash, DataContainer dc, Configuration config, DistributionManager dm, CacheNotifier notifier, Object ... keys) {
        super(notifier, keys);
        this.dm = dm;
        this.forRehash = forRehash;
        this.dataContainer = dc;
        this.config = config;
    }

    @Override
    public byte getCommandId() {
        return 7;
    }

    public void init(Configuration config, DistributionManager dm, CacheNotifier n, DataContainer dc) {
        super.init(n);
        this.dm = dm;
        this.config = config;
        this.dataContainer = dc;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.forRehash && this.config.isL1OnRehash()) {
            for (Object k : this.getKeys()) {
                InternalCacheEntry ice = this.dataContainer.get(k);
                if (ice == null) continue;
                this.dataContainer.put(k, ice.getValue(), this.config.getL1Lifespan(), this.config.getExpirationMaxIdle());
            }
        } else {
            for (Object k : this.getKeys()) {
                if (this.dm.isLocal(k)) continue;
                this.invalidate(ctx, k);
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvalidateL1Command that = (InvalidateL1Command)o;
        return this.forRehash == that.forRehash;
    }

    @Override
    public Object[] getParameters() {
        if (this.keys == null || this.keys.length == 0) {
            return new Object[]{this.forRehash};
        }
        if (this.keys.length == 1) {
            return new Object[]{this.forRehash, 1, this.keys[0]};
        }
        Object[] retval = new Object[this.keys.length + 2];
        retval[0] = this.forRehash;
        retval[1] = this.keys.length;
        System.arraycopy(this.keys, 0, retval, 2, this.keys.length);
        return retval;
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.forRehash = (Boolean)args[0];
        int size = (Integer)args[1];
        this.keys = new Object[size];
        if (size == 1) {
            this.keys[0] = args[2];
        } else if (size > 0) {
            System.arraycopy(args, 2, this.keys, 0, size);
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.forRehash ? 1 : 0);
        return result;
    }
}

