/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import net.jcip.annotations.ThreadSafe;
import org.infinispan.container.FIFODataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;

@ThreadSafe
public class LRUDataContainer
extends FIFODataContainer {
    public LRUDataContainer(int concurrencyLevel) {
        super(concurrencyLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry get(Object k) {
        int h = this.hash(k.hashCode());
        FIFODataContainer.Segment s = this.segmentFor(h);
        FIFODataContainer.LinkedEntry le = s.get(k, h);
        InternalCacheEntry ice = null;
        if (le != null) {
            ice = le.e;
        }
        if (ice != null) {
            if (ice.isExpired()) {
                this.remove(k);
                ice = null;
            } else {
                ice.touch();
                boolean needToUnlockSegment = false;
                try {
                    s.lock();
                    needToUnlockSegment = true;
                    this.updateLinks(le);
                }
                finally {
                    if (needToUnlockSegment) {
                        s.unlock();
                    }
                }
            }
        }
        return ice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object k, Object v, long lifespan, long maxIdle) {
        int h = this.hash(k.hashCode());
        FIFODataContainer.Segment s = this.segmentFor(h);
        s.lock();
        boolean newEntry = false;
        try {
            InternalCacheEntry ice;
            FIFODataContainer.LinkedEntry le = s.get(k, h);
            InternalCacheEntry internalCacheEntry = ice = le == null ? null : le.e;
            if (ice == null) {
                newEntry = true;
                ice = InternalEntryFactory.create(k, v, lifespan, maxIdle);
                le = new FIFODataContainer.LinkedEntry(ice);
            } else {
                ice.setValue(v);
                le.e = ice = this.entryFactory.update(ice, lifespan, maxIdle);
            }
            s.locklessPut(k, h, le);
            if (newEntry) {
                this.linkAtEnd(le);
            } else {
                this.updateLinks(le);
            }
        }
        finally {
            s.unlock();
        }
    }

    protected final void updateLinks(FIFODataContainer.LinkedEntry le) {
        this.unlink(le);
        this.linkAtEnd(le);
    }
}

