/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.config.ConfigurationException;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.NamedComponentFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.util.Util;

@DefaultFactoryFor(classes={ExecutorService.class, Executor.class, ScheduledExecutorService.class})
public class NamedExecutorsFactory
extends NamedComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType, String componentName) {
        try {
            if (componentName.equals("org.infinispan.executors.notification")) {
                return (T)this.buildAndConfigureExecutorService(this.globalConfiguration.getAsyncListenerExecutorFactoryClass(), this.globalConfiguration.getAsyncListenerExecutorProperties(), componentName);
            }
            if (componentName.equals("org.infinispan.executors.transport")) {
                return (T)this.buildAndConfigureExecutorService(this.globalConfiguration.getAsyncTransportExecutorFactoryClass(), this.globalConfiguration.getAsyncTransportExecutorProperties(), componentName);
            }
            if (componentName.equals("org.infinispan.executors.eviction")) {
                return (T)this.buildAndConfigureScheduledExecutorService(this.globalConfiguration.getEvictionScheduledExecutorFactoryClass(), this.globalConfiguration.getEvictionScheduledExecutorProperties(), componentName);
            }
            if (componentName.equals("org.infinispan.executors.replicationQueue")) {
                return (T)this.buildAndConfigureScheduledExecutorService(this.globalConfiguration.getReplicationQueueScheduledExecutorFactoryClass(), this.globalConfiguration.getReplicationQueueScheduledExecutorProperties(), componentName);
            }
            throw new ConfigurationException("Unknown named executor " + componentName);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to instantiate ExecutorFactory for named component " + componentName, e);
        }
    }

    private ExecutorService buildAndConfigureExecutorService(String factoryName, Properties p, String componentName) throws Exception {
        Properties props = new Properties(p);
        ExecutorFactory f = (ExecutorFactory)Util.getInstance(factoryName);
        this.setComponentName(componentName, props);
        this.setDefaultThreads(KnownComponentNames.getDefaultThreads(componentName), props);
        this.setDefaultThreadPrio(KnownComponentNames.getDefaultThreadPrio(componentName), props);
        return f.getExecutor(props);
    }

    private ScheduledExecutorService buildAndConfigureScheduledExecutorService(String factoryName, Properties p, String componentName) throws Exception {
        Properties props = new Properties();
        if (p != null && !p.isEmpty()) {
            props.putAll((Map<?, ?>)p);
        }
        ScheduledExecutorFactory f = (ScheduledExecutorFactory)Util.getInstance(factoryName);
        this.setComponentName(componentName, props);
        this.setDefaultThreadPrio(KnownComponentNames.getDefaultThreadPrio(componentName), props);
        return f.getScheduledExecutor(props);
    }

    private void setDefaultThreadPrio(int prio, Properties props) {
        if (!props.containsKey("threadPriority")) {
            props.setProperty("threadPriority", String.valueOf(prio));
        }
    }

    private void setDefaultThreads(int numThreads, Properties props) {
        if (!props.containsKey("maxThreads")) {
            props.setProperty("maxThreads", String.valueOf(numThreads));
        }
    }

    private void setComponentName(String cn, Properties p) {
        if (cn != null) {
            p.setProperty("componentName", this.format(cn));
        }
    }

    private String format(String cn) {
        int dotIndex = cn.lastIndexOf(".");
        int dotIndexPlusOne = dotIndex + 1;
        String cname = cn;
        if (dotIndexPlusOne == cn.length()) {
            cname = this.format(cn.substring(0, cn.length() - 1));
        } else {
            if (dotIndex > -1 && cn.length() > dotIndexPlusOne) {
                cname = cn.substring(dotIndexPlusOne);
            }
            cname = cname + "-thread";
        }
        return cname;
    }
}

