/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.UUID;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.graph.connector.base.MapNode;
import org.modeshape.graph.connector.base.Workspace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class MapWorkspace<NodeType extends MapNode>
implements Workspace {
    protected final String name;
    protected final UUID rootNodeUuid;

    public MapWorkspace(String name, NodeType rootNode) {
        this.name = name;
        this.rootNodeUuid = ((MapNode)rootNode).getUuid();
        assert (this.name != null);
        assert (this.rootNodeUuid != null);
    }

    public MapWorkspace(String name, MapWorkspace<NodeType> originalToClone) {
        this.name = name;
        this.rootNodeUuid = ((MapNode)originalToClone.getRootNode()).getUuid();
        assert (this.name != null);
        assert (this.rootNodeUuid != null);
    }

    public UUID getRootNodeUuid() {
        return this.rootNodeUuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public NodeType getRootNode() {
        return this.getNode(this.rootNodeUuid);
    }

    public abstract NodeType getNode(UUID var1);

    public abstract NodeType putNode(NodeType var1);

    public abstract NodeType removeNode(UUID var1);

    public abstract void removeAll();

    public String toString() {
        return this.name;
    }

    @Override
    public boolean hasNodeCache() {
        return false;
    }
}

