/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.basic.AbstractBinary;

@NotThreadSafe
public class FileInputStreamBinary
extends AbstractBinary {
    private static final long serialVersionUID = 2L;
    private final FileChannel channel;
    private byte[] sha1hash;
    private int hc;

    public FileInputStreamBinary(FileInputStream stream) {
        CheckArg.isNotNull((Object)stream, (String)"stream");
        this.channel = stream.getChannel();
    }

    public int hashCode() {
        if (this.sha1hash == null) {
            this.sha1hash = this.computeHash(this.getBytes());
            this.hc = this.sha1hash.hashCode();
        }
        return this.hc;
    }

    public long getSize() {
        try {
            return this.channel.size();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public byte[] getHash() {
        if (this.sha1hash == null) {
            this.sha1hash = this.computeHash(this.getBytes());
            this.hc = this.sha1hash.hashCode();
        }
        return this.sha1hash;
    }

    public byte[] getBytes() {
        try {
            if (this.channel.size() > Integer.MAX_VALUE) {
                throw new IllegalStateException(GraphI18n.streamTooLarge.text(new Object[]{this.channel.size()}));
            }
            MappedByteBuffer bytes = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
            byte[] buff = new byte[(int)this.channel.size()];
            bytes.get(buff);
            return buff;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public InputStream getStream() {
        try {
            this.channel.position(0L);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        return Channels.newInputStream(this.channel);
    }

    public void acquire() {
    }

    public void release() {
    }
}

