/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.session;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.LinkedListMultimap;
import org.modeshape.common.collection.ListMultimap;
import org.modeshape.common.collection.ReadOnlyIterator;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.Results;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.UuidAlreadyExistsException;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.BatchRequestBuilder;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.RequestException;
import org.modeshape.graph.session.InvalidStateException;
import org.modeshape.graph.session.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class GraphSession<Payload, PropertyPayload> {
    protected final ListMultimap<Name, Node<Payload, PropertyPayload>> NO_CHILDREN = LinkedListMultimap.create();
    protected final Map<Name, PropertyInfo<PropertyPayload>> NO_PROPERTIES = Collections.emptyMap();
    protected final Authorizer authorizer;
    protected final ExecutionContext context;
    protected final Graph store;
    protected final Node<Payload, PropertyPayload> root;
    protected final Operations<Payload, PropertyPayload> nodeOperations;
    protected final PathFactory pathFactory;
    protected final NodeIdFactory idFactory;
    protected final String workspaceName;
    protected int loadDepth = 1;
    protected final Map<NodeId, Node<Payload, PropertyPayload>> nodes = new HashMap<NodeId, Node<Payload, PropertyPayload>>();
    protected final Map<UUID, Node<Payload, PropertyPayload>> nodesByUuid = new HashMap<UUID, Node<Payload, PropertyPayload>>();
    protected final Map<NodeId, Dependencies> changeDependencies = new HashMap<NodeId, Dependencies>();
    protected final Set<UUID> deletedNodes = new HashSet<UUID>();
    private LinkedList<Request> requests;
    private BatchRequestBuilder requestBuilder;
    protected Graph.Batch operations;

    public GraphSession(Graph graph, String workspaceName, Operations<Payload, PropertyPayload> nodeOperations) {
        this(graph, workspaceName, nodeOperations, null);
    }

    public GraphSession(Graph graph, String workspaceName, Operations<Payload, PropertyPayload> nodeOperations, Authorizer authorizer) {
        assert (graph != null);
        this.store = graph;
        this.context = this.store.getContext();
        this.workspaceName = workspaceName != null ? this.store.useWorkspace(workspaceName).getName() : this.store.getCurrentWorkspaceName();
        this.nodeOperations = nodeOperations != null ? nodeOperations : new NodeOperations();
        this.pathFactory = this.context.getValueFactories().getPathFactory();
        this.authorizer = authorizer != null ? authorizer : new NoOpAuthorizer();
        this.idFactory = new NodeIdFactory(){
            private long nextId = 0L;

            public NodeId create() {
                return new NodeId(++this.nextId);
            }
        };
        Location rootLocation = Location.create(this.pathFactory.createRootPath());
        NodeId rootId = this.idFactory.create();
        this.root = this.createNode(null, rootId, rootLocation);
        this.nodes.put(rootId, this.root);
        this.requests = new LinkedList();
        this.requestBuilder = new BatchRequestBuilder(this.requests);
        this.operations = this.store.batch(this.requestBuilder);
    }

    protected void put(Node<Payload, PropertyPayload> node) {
        this.nodes.put(node.getNodeId(), node);
        UUID uuid = node.getLocation().getUuid();
        if (uuid != null) {
            this.nodesByUuid.put(uuid, node);
        }
    }

    protected Node<Payload, PropertyPayload> node(NodeId id) {
        return this.nodes.get(id);
    }

    protected Node<Payload, PropertyPayload> node(UUID uuid) {
        return this.nodesByUuid.get(uuid);
    }

    protected void removeNode(NodeId id) {
        UUID uuid;
        Node<Payload, PropertyPayload> removed = this.nodes.remove(id);
        if (removed != null && (uuid = removed.getLocation().getUuid()) != null) {
            this.nodesByUuid.remove(uuid);
        }
        this.changeDependencies.remove(id);
    }

    protected void clearNodes() {
        this.nodes.clear();
        this.nodes.put(this.root.getNodeId(), this.root);
    }

    ExecutionContext context() {
        return this.context;
    }

    protected Graph.Batch operations() {
        return this.operations;
    }

    final String readable(Name name) {
        return name.getString(this.context.getNamespaceRegistry());
    }

    final String readable(Path.Segment segment) {
        return segment.getString(this.context.getNamespaceRegistry());
    }

    final String readable(Path path) {
        return path.getString(this.context.getNamespaceRegistry());
    }

    final String readable(Location location) {
        return location.getString(this.context.getNamespaceRegistry());
    }

    public int getDepthForLoadingNodes() {
        return this.loadDepth;
    }

    public void setDepthForLoadingNodes(int depth) {
        CheckArg.isPositive((int)depth, (String)"depth");
        this.loadDepth = depth;
    }

    public Node<Payload, PropertyPayload> getRoot() {
        return this.root;
    }

    public PathFactory getPathFactory() {
        return this.pathFactory;
    }

    public Node<Payload, PropertyPayload> findNodeWith(Location location) throws PathNotFoundException, AccessControlException {
        UUID uuid = location.getUuid();
        if (uuid != null) {
            Node<Payload, PropertyPayload> node = this.node(uuid);
            if (node != null) {
                return node;
            }
            if (this.deletedNodes.contains(uuid)) {
                String msg = GraphI18n.nodeDoesNotExistWithUuid.text(new Object[]{uuid, this.workspaceName});
                throw new PathNotFoundException(location, this.root.getPath(), msg);
            }
            org.modeshape.graph.Node persistentNode = this.store.getNodeAt(location);
            Path path = (location = persistentNode.getLocation()).getPath();
            if (path.isRoot()) {
                return this.root;
            }
            this.authorizer.checkPermissions(path, Authorizer.Action.READ);
            Path relativePathFromRootToParent = path.getParent().relativeToRoot();
            Node<Payload, PropertyPayload> parent = this.findNodeRelativeTo(this.root, relativePathFromRootToParent, true);
            if (!parent.isLoaded()) {
                parent.load();
            }
            node = parent.getChild(path.getLastSegment());
            this.nodeOperations.materialize(persistentNode, node);
            return node;
        }
        assert (location.hasPath());
        return this.findNodeWith(null, location.getPath());
    }

    private UUID uuidFor(Location location) {
        UUID uuid = location.getUuid();
        if (uuid != null) {
            return uuid;
        }
        Property idProp = location.getIdProperty(JcrLexicon.UUID);
        if (idProp == null) {
            return null;
        }
        return (UUID)idProp.getFirstValue();
    }

    public Node<Payload, PropertyPayload> findNodeWith(NodeId id) {
        CheckArg.isNotNull((Object)id, (String)"id");
        return this.node(id);
    }

    public Node<Payload, PropertyPayload> findNodeWith(NodeId id, Path path) throws PathNotFoundException, AccessControlException {
        Node<Payload, PropertyPayload> result;
        if (id == null && path == null) {
            CheckArg.isNotNull((Object)id, (String)"id");
            CheckArg.isNotNull((Object)path, (String)"path");
        }
        Node<Payload, PropertyPayload> node = result = id != null ? this.node(id) : null;
        if (result == null || result.isStale()) {
            assert (path != null);
            result = this.findNodeWith(path);
        }
        return result;
    }

    public Node<Payload, PropertyPayload> findNodeWith(Path path) throws PathNotFoundException, AccessControlException {
        if (path.isRoot()) {
            return this.getRoot();
        }
        if (path.isIdentifier()) {
            return this.findNodeWith(Location.create(path));
        }
        return this.findNodeRelativeTo(this.root, path.relativeTo(this.root.getPath()), true);
    }

    protected Node<Payload, PropertyPayload> findNodeWith(Path path, boolean loadIfRequired) throws PathNotFoundException, AccessControlException {
        if (path.isRoot()) {
            return this.getRoot();
        }
        if (path.isIdentifier()) {
            return this.findNodeWith(Location.create(path));
        }
        return this.findNodeRelativeTo(this.root, path.relativeTo(this.root.getPath()), loadIfRequired);
    }

    public Node<Payload, PropertyPayload> findNodeRelativeTo(Node<Payload, PropertyPayload> startingPoint, Path relativePath) throws PathNotFoundException, AccessControlException {
        return this.findNodeRelativeTo(startingPoint, relativePath, true);
    }

    protected Node<Payload, PropertyPayload> findNodeRelativeTo(Node<Payload, PropertyPayload> startingPoint, Path relativePath, boolean loadIfRequired) throws PathNotFoundException, AccessControlException {
        Node<Payload, PropertyPayload> node = startingPoint;
        if (!relativePath.isRoot()) {
            Path absolutePath = relativePath.resolveAgainst(startingPoint.getPath());
            this.authorizer.checkPermissions(absolutePath, Authorizer.Action.READ);
            Iterator<Path.Segment> iter = relativePath.iterator();
            while (iter.hasNext()) {
                Path.Segment segment = iter.next();
                try {
                    if (segment.isSelfReference()) continue;
                    if (segment.isParentReference()) {
                        node = node.getParent();
                        assert (node != null);
                        continue;
                    }
                    if (node.isLoaded()) {
                        node = node.getChild(segment);
                        continue;
                    }
                    if (!loadIfRequired) {
                        return null;
                    }
                    Graph.Batch batch = this.store.batch();
                    Path firstPath = node.getPath();
                    batch.read(firstPath);
                    Path nextPath = this.pathFactory.create(firstPath, segment);
                    if (!iter.hasNext() && this.loadDepth > 1) {
                        batch.readSubgraphOfDepth(this.loadDepth).at(nextPath);
                    } else {
                        batch.read(nextPath);
                    }
                    while (iter.hasNext()) {
                        nextPath = this.pathFactory.create(nextPath, iter.next());
                        if (!iter.hasNext() && this.loadDepth > 1) {
                            batch.readSubgraphOfDepth(this.loadDepth).at(nextPath);
                            continue;
                        }
                        batch.read(nextPath);
                    }
                    Results batchResults = batch.execute();
                    Path previousPath = null;
                    Node<Payload, PropertyPayload> topNode = node;
                    Node<Payload, PropertyPayload> previousNode = node;
                    for (org.modeshape.graph.Node persistentNode : batchResults) {
                        Location location = persistentNode.getLocation();
                        Path path = location.getPath();
                        if (path.isRoot()) {
                            previousNode = this.root;
                            ((Node)this.root).location = location;
                        } else {
                            if (path.getParent().equals(previousPath)) {
                                previousNode = previousNode.getChild(path.getLastSegment());
                            } else {
                                Path subgraphPath = path.relativeTo(topNode.getPath());
                                previousNode = this.findNodeRelativeTo(topNode, subgraphPath);
                            }
                            if (path.getLastSegment().equals(relativePath.getLastSegment()) && path.equals(absolutePath)) {
                                node = previousNode;
                            }
                        }
                        this.nodeOperations.materialize(persistentNode, previousNode);
                        previousPath = path;
                    }
                }
                catch (RequestException re) {
                    try {
                        Iterator<Path.Segment> redoIter = relativePath.iterator();
                        Node<Payload, PropertyPayload> redoNode = startingPoint;
                        while (redoIter.hasNext()) {
                            Path.Segment redoSegment = redoIter.next();
                            if (redoSegment.isSelfReference()) continue;
                            if (redoSegment.isParentReference()) {
                                redoNode = redoNode.getParent();
                                assert (redoNode != null);
                                continue;
                            }
                            Path firstPath = redoNode.getPath();
                            if (redoNode.isLoaded()) {
                                redoNode = redoNode.getChild(redoSegment);
                                continue;
                            }
                            Path nextPath = firstPath;
                            while (redoIter.hasNext()) {
                                nextPath = this.pathFactory.create(nextPath, redoSegment);
                                this.store.getNodeAt(nextPath);
                            }
                        }
                    }
                    catch (PathNotFoundException e) {
                        throw new PathNotFoundException(Location.create(relativePath), e.getLowestAncestorThatDoesExist());
                    }
                }
                catch (PathNotFoundException e) {
                    throw new PathNotFoundException(Location.create(relativePath), e.getLowestAncestorThatDoesExist());
                }
            }
        }
        return node;
    }

    public boolean hasPendingChanges() {
        return this.root.isChanged(true);
    }

    public void clearAllChangedNodes() {
        this.root.clearChanges();
        this.changeDependencies.clear();
        this.requests.clear();
    }

    public void immediateMove(Path nodeToMove, Path destination) throws AccessControlException, RepositorySourceException {
        CheckArg.isNotNull((Object)nodeToMove, (String)"nodeToMove");
        CheckArg.isNotNull((Object)destination, (String)"destination");
        Path newParentPath = destination.getParent();
        Name newName = destination.getLastSegment().getName();
        this.authorizer.checkPermissions(newParentPath, Authorizer.Action.ADD_NODE);
        this.authorizer.checkPermissions(nodeToMove.getParent(), Authorizer.Action.REMOVE);
        Results results = ((Graph.BatchConjunction)((Graph.Into)this.store.batch().move(nodeToMove).as(newName)).into(newParentPath)).execute();
        MoveBranchRequest moveRequest = (MoveBranchRequest)results.getRequests().get(0);
        Location locationAfter = moveRequest.getActualLocationAfter();
        Node<Payload, PropertyPayload> parent = this.findNodeWith(locationAfter.getPath().getParent(), false);
        if (parent != null && parent.isLoaded()) {
            parent.synchronizeWithNewlyPersistedNode(locationAfter);
        }
    }

    public void immediateCopy(Path source, Path destination) throws AccessControlException, RepositorySourceException {
        this.immediateCopy(source, this.workspaceName, destination);
    }

    public Location immediateCopy(Path source, String sourceWorkspace, Path destination) throws InvalidWorkspaceException, AccessControlException, PathNotFoundException, RepositorySourceException {
        CheckArg.isNotNull((Object)source, (String)"source");
        CheckArg.isNotNull((Object)destination, (String)"destination");
        if (sourceWorkspace == null) {
            sourceWorkspace = this.workspaceName;
        }
        this.authorizer.checkPermissions(destination, Authorizer.Action.ADD_NODE);
        this.authorizer.checkPermissions(source, Authorizer.Action.READ);
        Results results = ((Graph.BatchConjunction)((Graph.CopyTarget)this.store.batch().copy(source).fromWorkspace(sourceWorkspace)).to(destination)).execute();
        CopyBranchRequest request = (CopyBranchRequest)results.getRequests().get(0);
        Location locationOfCopy = request.getActualLocationAfter();
        Node<Payload, PropertyPayload> parent = this.findNodeWith(locationOfCopy.getPath().getParent(), false);
        if (parent != null && parent.isLoaded()) {
            parent.synchronizeWithNewlyPersistedNode(locationOfCopy);
        }
        return locationOfCopy;
    }

    public Location immediateCreateOrReplace(Path path, Collection<Property> properties) throws AccessControlException, RepositorySourceException {
        CheckArg.isNotNull((Object)path, (String)"path");
        Path newParentPath = path.getParent();
        this.authorizer.checkPermissions(newParentPath, Authorizer.Action.ADD_NODE);
        Results results = null;
        results = properties == null || properties.isEmpty() ? ((Graph.Batch)this.store.batch().create(path).byAppending().and()).execute() : ((Graph.Batch)this.store.batch().create(path).byAppending().with(properties).and()).execute();
        CreateNodeRequest createRequest = (CreateNodeRequest)results.getRequests().get(0);
        Location locationAfter = createRequest.getActualLocationOfNode();
        Node<Payload, PropertyPayload> parent = this.findNodeWith(locationAfter.getPath().getParent(), false);
        if (parent != null && parent.isLoaded()) {
            parent.synchronizeWithNewlyPersistedNode(locationAfter);
        }
        return locationAfter;
    }

    public void immediateClone(Path source, String sourceWorkspace, Path destination, boolean removeExisting, boolean destPathIncludesSegment) throws InvalidWorkspaceException, AccessControlException, UuidAlreadyExistsException, PathNotFoundException, RepositorySourceException {
        Name newNodeName;
        CheckArg.isNotNull((Object)source, (String)"source");
        CheckArg.isNotNull((Object)destination, (String)"destination");
        if (sourceWorkspace == null) {
            sourceWorkspace = this.workspaceName;
        }
        this.authorizer.checkPermissions(destination.getParent(), Authorizer.Action.ADD_NODE);
        this.authorizer.checkPermissions(source, Authorizer.Action.READ);
        Graph.Batch batch = this.store.batch();
        if (removeExisting) {
            if (destPathIncludesSegment) {
                ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)batch.clone(source).fromWorkspace(sourceWorkspace)).as(destination.getLastSegment())).into(destination.getParent())).replacingExistingNodesWithSameUuids();
            } else {
                newNodeName = destination.getLastSegment().getName();
                ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)batch.clone(source).fromWorkspace(sourceWorkspace)).as(newNodeName)).into(destination.getParent())).replacingExistingNodesWithSameUuids();
            }
        } else if (destPathIncludesSegment) {
            ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)batch.clone(source).fromWorkspace(sourceWorkspace)).as(destination.getLastSegment())).into(destination.getParent())).failingIfAnyUuidsMatch();
        } else {
            newNodeName = destination.getLastSegment().getName();
            ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)batch.clone(source).fromWorkspace(sourceWorkspace)).as(newNodeName)).into(destination.getParent())).failingIfAnyUuidsMatch();
        }
        Results results = batch.execute();
        CloneBranchRequest request = (CloneBranchRequest)results.getRequests().get(0);
        Location locationOfCopy = request.getActualLocationAfter();
        HashSet<Path> removedAlready = new HashSet<Path>();
        for (Location removed : request.getRemovedNodes()) {
            Path path = removed.getPath();
            if (GraphSession.isBelow(path, removedAlready)) continue;
            Node<Payload, PropertyPayload> removedNode = this.findNodeWith(path, false);
            removedNode.remove(false);
            removedAlready.add(path);
        }
        Node<Payload, PropertyPayload> parent = this.findNodeWith(locationOfCopy.getPath().getParent(), false);
        if (parent != null && parent.isLoaded()) {
            parent.synchronizeWithNewlyPersistedNode(locationOfCopy);
        }
    }

    private static final boolean isBelow(Path path, Collection<Path> paths) {
        for (Path aPath : paths) {
            if (!aPath.isAncestorOf(path)) continue;
            return true;
        }
        return false;
    }

    public void refresh(boolean keepChanges) throws InvalidStateException, RepositorySourceException {
        if (keepChanges) {
            this.refresh(this.root, keepChanges);
        } else {
            this.clearNodes();
            this.requests.clear();
            this.changeDependencies.clear();
            ((Node)this.root).status = Status.UNCHANGED;
            ((Node)this.root).childrenByName = null;
            ((Node)this.root).expirationTime = Long.MAX_VALUE;
            ((Node)this.root).changedBelow = false;
            ((Node)this.root).payload = null;
        }
    }

    public void refresh(Path path, boolean keepChanges) throws InvalidStateException, RepositorySourceException {
        try {
            Node<Payload, PropertyPayload> node = this.findNodeWith(path, false);
            if (node != null) {
                this.refresh(node, keepChanges);
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void refresh(Node<Payload, PropertyPayload> node, boolean keepChanges) throws InvalidStateException, RepositorySourceException {
        if (!node.isRoot() && node.isChanged(true) && node.containsChangesWithExternalDependencies()) {
            I18n msg = GraphI18n.unableToRefreshBranchBecauseChangesDependOnChangesToNodesOutsideOfBranch;
            String path = this.readable(node.getPath());
            throw new InvalidStateException(msg.text(new Object[]{path, this.workspaceName}));
        }
        if (keepChanges && node.isChanged(true)) {
            RefreshState refreshState = new RefreshState();
            node.refreshPhase1(refreshState);
            Results readResults = null;
            if (!refreshState.getNodesToBeRefreshed().isEmpty()) {
                Graph.Batch batch = this.store.batch();
                for (Node nodeToBeRefreshed : refreshState.getNodesToBeRefreshed()) {
                    batch.read(nodeToBeRefreshed.getLocation());
                }
                try {
                    readResults = batch.execute();
                }
                catch (PathNotFoundException e) {
                    throw new InvalidStateException(e.getLocalizedMessage(), e);
                }
            }
            node.refreshPhase2(refreshState, readResults);
        } else {
            node.clearChanges();
            node.unload();
            if (this.operations.isExecuteRequired()) {
                this.requestBuilder.finishPendingRequest();
                Iterator iter = this.requests.iterator();
                while (iter.hasNext()) {
                    Request request = (Request)iter.next();
                    assert (request instanceof ChangeRequest);
                    ChangeRequest change = (ChangeRequest)request;
                    if (!change.changes(this.workspaceName, node.getPath())) continue;
                    iter.remove();
                }
            }
        }
    }

    public void refreshProperties(Node<Payload, PropertyPayload> node) throws InvalidStateException, RepositorySourceException {
        assert (node != null);
        if (node.isNew()) {
            I18n msg = GraphI18n.unableToRefreshPropertiesBecauseNodeIsModified;
            String path = this.readable(node.getPath());
            throw new InvalidStateException(msg.text(new Object[]{path, this.workspaceName}));
        }
        org.modeshape.graph.Node persistentNode = this.store.getNodeAt(node.getLocation());
        this.nodeOperations.materializeProperties(persistentNode, node);
    }

    public void save() throws PathNotFoundException, ValidationException, InvalidStateException {
        if (!this.operations.isExecuteRequired()) {
            this.root.clearChanges();
            this.root.unload();
            return;
        }
        if (!this.root.isChanged(true)) {
            this.root.recomputeChangedBelow();
            if (!this.root.isChanged(true)) {
                this.root.clearChanges();
                this.root.unload();
                return;
            }
        }
        final DateTime saveTime = this.context.getValueFactories().getDateFactory().create();
        this.root.onChangedNodes(new LoadAllChildrenVisitor(){

            @Override
            protected void finishParentAfterLoading(Node<Payload, PropertyPayload> node) {
                GraphSession.this.nodeOperations.preSave(node, saveTime);
            }
        });
        this.root.onChangedNodes(new LoadAllChildrenVisitor(){

            @Override
            protected void finishParentAfterLoading(Node<Payload, PropertyPayload> node) {
                GraphSession.this.nodeOperations.compute(GraphSession.this.operations, node);
            }
        });
        try {
            this.operations.execute();
        }
        catch (PathNotFoundException e) {
            throw new InvalidStateException(e.getLocalizedMessage(), e);
        }
        catch (RuntimeException e) {
            throw new RepositorySourceException(e.getLocalizedMessage(), e);
        }
        this.deletedNodes.clear();
        this.requests = new LinkedList();
        this.requestBuilder = new BatchRequestBuilder(this.requests);
        this.operations = this.store.batch(this.requestBuilder);
        this.root.clearChanges();
        this.root.unload();
    }

    public void save(Node<Payload, PropertyPayload> node) throws PathNotFoundException, ValidationException, InvalidStateException {
        assert (node != null);
        if (node.isRoot()) {
            this.save();
            return;
        }
        if (node.isStale()) {
            String readableLocation = this.readable(node.getLocation());
            I18n msg = GraphI18n.nodeHasAlreadyBeenRemovedFromThisSession;
            throw new InvalidStateException(msg.text(new Object[]{readableLocation, this.workspaceName}));
        }
        if (node.isNew()) {
            String path = this.readable(node.getPath());
            throw new RepositorySourceException(GraphI18n.unableToSaveNodeThatWasCreatedSincePreviousSave.text(new Object[]{path, this.workspaceName}));
        }
        if (!node.isChanged(true)) {
            return;
        }
        if (node.containsChangesWithExternalDependencies()) {
            I18n msg = GraphI18n.unableToSaveBranchBecauseChangesDependOnChangesToNodesOutsideOfBranch;
            String path = this.readable(node.getPath());
            throw new ValidationException(msg.text(new Object[]{path, this.workspaceName}));
        }
        final DateTime saveTime = this.context.getValueFactories().getDateFactory().create();
        this.root.onChangedNodes(new LoadAllChildrenVisitor(){

            @Override
            protected void finishParentAfterLoading(Node<Payload, PropertyPayload> node) {
                GraphSession.this.nodeOperations.preSave(node, saveTime);
            }
        });
        this.requestBuilder.finishPendingRequest();
        Path path = node.getPath();
        LinkedList<Request> branchRequests = new LinkedList<Request>();
        LinkedList<Request> nonBranchRequests = new LinkedList<Request>();
        for (Request request : this.requests) {
            assert (request instanceof ChangeRequest);
            ChangeRequest change = (ChangeRequest)request;
            if (change.changes(this.workspaceName, path)) {
                branchRequests.add(request);
                continue;
            }
            nonBranchRequests.add(request);
        }
        if (branchRequests.isEmpty()) {
            return;
        }
        final Graph.Batch branchBatch = this.store.batch(new BatchRequestBuilder(branchRequests));
        node.onChangedNodes(new LoadAllChildrenVisitor(){

            @Override
            protected void finishParentAfterLoading(Node<Payload, PropertyPayload> node) {
                GraphSession.this.nodeOperations.compute(branchBatch, node);
            }
        });
        try {
            branchBatch.execute();
        }
        catch (PathNotFoundException e) {
            throw new InvalidStateException(e.getLocalizedMessage(), e);
        }
        catch (RuntimeException e) {
            throw new RepositorySourceException(e.getLocalizedMessage(), e);
        }
        this.requests = nonBranchRequests;
        this.requestBuilder = new BatchRequestBuilder(this.requests);
        this.operations = this.store.batch(this.requestBuilder);
        node.clearChanges();
        node.unload();
    }

    protected Node<Payload, PropertyPayload> createNode(Node<Payload, PropertyPayload> parent, NodeId nodeId, Location location) {
        return new Node<Payload, PropertyPayload>(this, parent, nodeId, location);
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    protected void recordMove(Node<Payload, PropertyPayload> nodeBeingMoved, Node<Payload, PropertyPayload> oldParent, Node<Payload, PropertyPayload> newParent) {
        NodeId id = nodeBeingMoved.getNodeId();
        Dependencies dependencies = this.changeDependencies.get(id);
        if (dependencies == null) {
            dependencies = new Dependencies();
            dependencies.setMovedFrom(oldParent.getNodeId());
            this.changeDependencies.put(id, dependencies);
        } else {
            dependencies.setMovedFrom(newParent.getNodeId());
        }
    }

    protected void recordDelete(Node<Payload, PropertyPayload> node) {
        Location location = node.getLocation();
        this.operations.delete(location);
        UUID nodeUuid = this.uuidFor(location);
        if (nodeUuid != null) {
            this.deletedNodes.add(nodeUuid);
        }
        this.removeNode(node.getNodeId());
        this.recordUnloaded(node);
    }

    protected void recordUnloaded(final Node<Payload, PropertyPayload> node) {
        if (node.isLoaded() && node.getChildrenCount() > 0) {
            node.onCachedNodes(new NodeVisitor<Payload, PropertyPayload>(){

                @Override
                public boolean visit(Node<Payload, PropertyPayload> unloaded) {
                    if (unloaded != node) {
                        GraphSession.this.removeNode(unloaded.getNodeId());
                        unloaded.parent = null;
                    }
                    return true;
                }
            });
        }
    }

    @Immutable
    public static final class NodeId {
        private final long nodeId;

        public NodeId(long nodeId) {
            this.nodeId = nodeId;
        }

        public int hashCode() {
            return (int)this.nodeId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof NodeId) {
                NodeId that = (NodeId)obj;
                return this.nodeId == that.nodeId;
            }
            return false;
        }

        public String toString() {
            return Long.toString(this.nodeId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    protected static final class Dependencies {
        private Set<NodeId> requireChangesTo;
        private NodeId movedFrom;

        public NodeId getMovedFrom() {
            return this.movedFrom;
        }

        public void setMovedFrom(NodeId movedFrom) {
            if (this.movedFrom == null) {
                this.movedFrom = movedFrom;
            }
        }

        public Set<NodeId> getRequireChangesTo() {
            return this.requireChangesTo != null ? this.requireChangesTo : Collections.emptySet();
        }

        public void addRequireChangesTo(NodeId other) {
            if (other == null) {
                return;
            }
            if (this.requireChangesTo == null) {
                this.requireChangesTo = new HashSet<NodeId>();
            }
            this.requireChangesTo.add(other);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    protected static final class RefreshState<Payload, PropertyPayload> {
        private final Set<Node<Payload, PropertyPayload>> refresh = new HashSet<Node<Payload, PropertyPayload>>();

        protected RefreshState() {
        }

        public void markAsRequiringRefresh(Node<Payload, PropertyPayload> node) {
            this.refresh.add(node);
        }

        public boolean requiresRefresh(Node<Payload, PropertyPayload> node) {
            return this.refresh.contains(node);
        }

        public Set<Node<Payload, PropertyPayload>> getNodesToBeRefreshed() {
            return this.refresh;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static final class StructureSnapshot<PropertyPayload>
    implements Iterable<Snapshot<PropertyPayload>> {
        private final List<Snapshot<PropertyPayload>> snapshotsInPreOrder;
        private final NamespaceRegistry registry;

        protected StructureSnapshot(NamespaceRegistry registry, List<Snapshot<PropertyPayload>> snapshotsInPreOrder) {
            assert (snapshotsInPreOrder != null);
            this.snapshotsInPreOrder = snapshotsInPreOrder;
            this.registry = registry;
        }

        @Override
        public Iterator<Snapshot<PropertyPayload>> iterator() {
            return this.snapshotsInPreOrder.iterator();
        }

        public List<Snapshot<PropertyPayload>> getSnapshotsInPreOrder() {
            return this.snapshotsInPreOrder;
        }

        public String toString() {
            int maxLength = 0;
            for (Snapshot<PropertyPayload> snapshot : this) {
                String path = snapshot.getLocation().getPath().getString(this.registry);
                maxLength = Math.max(maxLength, path.length());
            }
            StringBuilder sb = new StringBuilder();
            for (Snapshot<PropertyPayload> snapshot : this) {
                boolean first;
                Location location = snapshot.getLocation();
                sb.append(StringUtil.justifyLeft((String)location.getPath().getString(this.registry), (int)maxLength, (char)' '));
                sb.append(StringUtil.justifyRight((String)snapshot.getId().toString(), (int)10, (char)' '));
                if (snapshot.isChanged()) {
                    sb.append(" (*)");
                } else if (!snapshot.isLoaded()) {
                    sb.append(" (-)");
                } else {
                    sb.append("    ");
                }
                if (location.hasIdProperties()) {
                    sb.append("  ");
                    if (location.getIdProperties().size() == 1 && location.getUuid() != null) {
                        sb.append(location.getUuid());
                    } else {
                        first = true;
                        sb.append('[');
                        for (Property property : location) {
                            sb.append(property.getString(this.registry));
                            if (first) {
                                first = false;
                                continue;
                            }
                            sb.append(", ");
                        }
                        sb.append(']');
                    }
                }
                if (snapshot.getProperties() != null) {
                    first = true;
                    sb.append("  {");
                    for (PropertyInfo<PropertyPayload> info : snapshot.getProperties()) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append("} {");
                        }
                        sb.append(info.getProperty().getString(this.registry));
                    }
                    sb.append("}");
                }
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Snapshot<PropertyPayload> {
        private final Location location;
        private final boolean isLoaded;
        private final boolean isChanged;
        private final Collection<PropertyInfo<PropertyPayload>> properties;
        private final NodeId id;

        protected Snapshot(Node<?, PropertyPayload> node, boolean pathsOnly, boolean includeProperties) {
            this.location = pathsOnly && node.getLocation().hasIdProperties() ? Location.create(node.getLocation().getPath()) : node.getLocation();
            this.isLoaded = node.isLoaded();
            this.isChanged = node.isChanged(false);
            this.id = node.getNodeId();
            this.properties = includeProperties ? node.getProperties() : null;
        }

        public Location getLocation() {
            return this.location;
        }

        public boolean isChanged() {
            return this.isChanged;
        }

        public boolean isLoaded() {
            return this.isLoaded;
        }

        public NodeId getId() {
            return this.id;
        }

        public Collection<PropertyInfo<PropertyPayload>> getProperties() {
            return this.properties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    protected class LoadAllChildrenVisitor
    extends LoadNodesVisitor {
        private List<Node<Payload, PropertyPayload>> parentsVisited;

        protected LoadAllChildrenVisitor() {
            this.parentsVisited = new LinkedList();
        }

        @Override
        public boolean visit(Node<Payload, PropertyPayload> node) {
            this.parentsVisited.add(node);
            Iterator iter = node.getChildren().iterator();
            while (iter.hasNext()) {
                this.load(iter.next());
            }
            return true;
        }

        @Override
        public void finish() {
            super.finish();
            for (Node parent : this.parentsVisited) {
                this.finishParentAfterLoading(parent);
            }
        }

        protected void finishParentAfterLoading(Node<Payload, PropertyPayload> parentNode) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    protected abstract class LoadNodesVisitor
    extends NodeVisitor<Payload, PropertyPayload> {
        private Graph.Batch batch;
        private List<Node<Payload, PropertyPayload>> nodesToLoad;

        protected LoadNodesVisitor() {
            this.batch = GraphSession.this.store.batch();
            this.nodesToLoad = new LinkedList();
        }

        protected void load(Node<Payload, PropertyPayload> node) {
            if (node != null && !node.isLoaded() && !node.isNew()) {
                this.nodesToLoad.add(node);
                this.batch.read(node.getOriginalLocation());
            }
        }

        @Override
        public void finish() {
            super.finish();
            if (!this.nodesToLoad.isEmpty()) {
                Results results = this.batch.execute();
                for (Node childToBeRead : this.nodesToLoad) {
                    org.modeshape.graph.Node persistentNode = results.getNode(childToBeRead.getOriginalLocation());
                    GraphSession.this.nodeOperations.materialize(persistentNode, childToBeRead);
                    this.finishNodeAfterLoading(childToBeRead);
                }
            }
        }

        protected void finishNodeAfterLoading(Node<Payload, PropertyPayload> node) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    public static abstract class NodeVisitor<NodePayload, PropertyPayloadType> {
        public abstract boolean visit(Node<NodePayload, PropertyPayloadType> var1);

        public void finish() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PropertyInfo<PropertyPayload> {
        private final Property property;
        private final Status status;
        private final boolean multiValued;
        private final PropertyPayload payload;

        public PropertyInfo(Property property, boolean multiValued, Status status, PropertyPayload payload) {
            assert (property != null);
            assert (status != null);
            this.property = property;
            this.status = status;
            this.multiValued = multiValued;
            this.payload = payload;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isModified() {
            return this.status != Status.UNCHANGED && this.status != Status.NEW;
        }

        public boolean isNew() {
            return this.status == Status.NEW;
        }

        public Name getName() {
            return this.property.getName();
        }

        public Property getProperty() {
            return this.property;
        }

        public PropertyPayload getPayload() {
            return this.payload;
        }

        public boolean isMultiValued() {
            return this.multiValued;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PropertyInfo) {
                PropertyInfo that = (PropertyInfo)obj;
                return this.getName().equals(that.getName());
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName());
            if (this.property.isSingle()) {
                sb.append(" with value ");
            } else {
                sb.append(" with values ");
            }
            sb.append(Arrays.asList(this.property.getValuesAsArray()));
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NEW,
        CHANGED,
        UNCHANGED,
        COPIED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    public static class Node<Payload, PropertyPayload> {
        private final GraphSession<Payload, PropertyPayload> cache;
        private final NodeId nodeId;
        private Node<Payload, PropertyPayload> parent;
        private long expirationTime = Long.MAX_VALUE;
        private Location location;
        private Status status = Status.UNCHANGED;
        private boolean changedBelow;
        private Map<Name, PropertyInfo<PropertyPayload>> properties;
        private ListMultimap<Name, Node<Payload, PropertyPayload>> childrenByName;
        private Payload payload;
        private Location originalLocation;

        public Node(GraphSession<Payload, PropertyPayload> cache, Node<Payload, PropertyPayload> parent, NodeId nodeId, Location location) {
            this.cache = cache;
            this.parent = parent;
            this.nodeId = nodeId;
            this.location = location;
            this.originalLocation = location;
            assert (this.cache != null);
            assert (this.nodeId != null);
            assert (this.location != null);
            assert (this.location.hasPath());
        }

        public GraphSession<Payload, PropertyPayload> getSession() {
            return this.cache;
        }

        public final long getExpirationTimeInMillis() {
            return this.expirationTime;
        }

        public final boolean isExpired() {
            return this.expirationTime != Long.MAX_VALUE && this.expirationTime < this.cache.getCurrentTime();
        }

        public final boolean isLoaded() {
            if (this.childrenByName == null) {
                return false;
            }
            if (this.isExpired()) {
                if (this.isChanged(true)) {
                    return true;
                }
                this.unload();
                return false;
            }
            return true;
        }

        protected final void load() throws RepositorySourceException {
            if (this.isLoaded()) {
                return;
            }
            assert (!this.isStale());
            if (this.status == Status.NEW) {
                this.childrenByName = this.cache.NO_CHILDREN;
                this.properties = this.cache.NO_PROPERTIES;
                return;
            }
            Path path = this.getPath();
            this.cache.authorizer.checkPermissions(path, Authorizer.Action.READ);
            int depth = this.cache.getDepthForLoadingNodes();
            if (depth == 1) {
                org.modeshape.graph.Node persistentNode = this.cache.store.getNodeAt(this.getOriginalLocation());
                Location actualLocation = persistentNode.getLocation();
                if (!this.location.isSame(actualLocation)) {
                    this.originalLocation = actualLocation;
                    this.location = actualLocation.with(this.location.getPath());
                }
                this.cache.nodeOperations.materialize(persistentNode, this);
            } else {
                Subgraph subgraph = this.cache.store.getSubgraphOfDepth(depth).at(this.getOriginalLocation());
                Location actualLocation = subgraph.getLocation();
                if (!this.location.isSame(actualLocation)) {
                    this.originalLocation = actualLocation;
                    this.location = actualLocation.with(this.location.getPath());
                }
                this.cache.nodeOperations.materialize(subgraph.getRoot(), this);
                for (SubgraphNode persistentNode : subgraph) {
                    Path relativePath = persistentNode.getLocation().getPath().relativeTo(path);
                    Node<Payload, PropertyPayload> node = this.cache.findNodeRelativeTo(this, relativePath);
                    if (node.isLoaded()) continue;
                    this.cache.nodeOperations.materialize(persistentNode, node);
                }
            }
        }

        protected final void unload() {
            assert (!this.isStale());
            assert (this.status == Status.UNCHANGED);
            assert (!this.changedBelow);
            if (!this.isLoaded()) {
                return;
            }
            this.cache.recordUnloaded(this);
            this.childrenByName = null;
            this.expirationTime = Long.MAX_VALUE;
        }

        protected final boolean refreshPhase1(RefreshState<Payload, PropertyPayload> refreshState) {
            assert (!this.isStale());
            if (this.childrenByName == null) {
                return true;
            }
            boolean canUnloadChildren = true;
            for (Node child : this.childrenByName.values()) {
                if (!child.refreshPhase1(refreshState)) continue;
                canUnloadChildren = false;
            }
            if (this.isChanged(false)) {
                return false;
            }
            if (canUnloadChildren) {
                return true;
            }
            refreshState.markAsRequiringRefresh(this);
            return false;
        }

        protected final void refreshPhase2(RefreshState<Payload, PropertyPayload> refreshState, Results persistentInfoForRefreshedNodes) {
            assert (!this.isStale());
            if (this.status != Status.UNCHANGED) {
                return;
            }
            if (refreshState.requiresRefresh(this)) {
                assert (this.childrenByName != null);
                org.modeshape.graph.Node persistentNode = persistentInfoForRefreshedNodes.getNode(this.location);
                assert (!persistentNode.getChildren().isEmpty());
                HashMap<Location, Node> childrenToKeep = new HashMap<Location, Node>();
                for (Node existing : this.childrenByName.values()) {
                    if (existing.isChanged(true)) {
                        childrenToKeep.put(existing.getLocation(), existing);
                        continue;
                    }
                    this.cache.removeNode(existing.getNodeId());
                    existing.parent = null;
                }
                this.childrenByName.clear();
                for (Location location : persistentNode.getChildren()) {
                    Name childName = location.getPath().getLastSegment().getName();
                    List currentChildren = this.childrenByName.get((Object)childName);
                    Node existingChild = (Node)childrenToKeep.get(location);
                    if (existingChild != null) {
                        currentChildren.add(existingChild);
                        if (currentChildren.size() == existingChild.getPath().getLastSegment().getIndex()) continue;
                        Path.Segment segment = this.cache.pathFactory.createSegment(childName, currentChildren.size());
                        existingChild.updateLocation(segment);
                        continue;
                    }
                    NodeId nodeId = this.cache.idFactory.create();
                    Node<Payload, PropertyPayload> replacementChild = this.cache.createNode(this, nodeId, location);
                    this.cache.put(replacementChild);
                    assert (replacementChild.getName().equals(childName));
                    assert (replacementChild.parent == this);
                    currentChildren.add(replacementChild);
                    Path.Segment segment = this.cache.pathFactory.createSegment(childName, currentChildren.size());
                    replacementChild.updateLocation(segment);
                }
                return;
            }
            if (!this.changedBelow) {
                this.unload();
            }
        }

        public void loadedWith(List<Location> children, Map<Name, PropertyInfo<PropertyPayload>> properties, DateTime expirationTime) {
            assert (!this.isStale());
            if (children.isEmpty()) {
                this.childrenByName = this.cache.NO_CHILDREN;
            } else {
                this.childrenByName = LinkedListMultimap.create();
                for (Location location : children) {
                    NodeId id = this.cache.idFactory.create();
                    Name childName = location.getPath().getLastSegment().getName();
                    Node<Payload, PropertyPayload> child = this.cache.createNode(this, id, location);
                    this.cache.put(child);
                    List currentChildren = this.childrenByName.get((Object)childName);
                    currentChildren.add(child);
                    child.parent = this;
                    Path.Segment segment = this.cache.pathFactory.createSegment(childName, currentChildren.size());
                    child.updateLocation(segment);
                }
            }
            this.loadedWith(properties);
            this.expirationTime = expirationTime != null ? expirationTime.getMilliseconds() : Long.MAX_VALUE;
        }

        public void loadedWith(Map<Name, PropertyInfo<PropertyPayload>> properties) {
            this.properties = properties.isEmpty() ? this.cache.NO_PROPERTIES : new HashMap<Name, PropertyInfo<PropertyPayload>>(properties);
        }

        protected void updateLocation(Path.Segment segment) {
            assert (!this.isStale());
            Path newPath = null;
            if (segment != null) {
                Path parentPath = this.getParent().getPath();
                newPath = this.cache.pathFactory.create(parentPath, segment);
            } else {
                if (this.isRoot()) {
                    return;
                }
                newPath = this.cache.pathFactory.createRootPath();
                assert (this.isRoot());
            }
            Location newLocation = this.location.with(newPath);
            if (newLocation != this.location) {
                Location oldLocation = this.location;
                this.location = newLocation;
                this.cache.nodeOperations.postUpdateLocation(this, oldLocation);
            }
            if (this.isLoaded() && this.childrenByName != this.cache.NO_CHILDREN) {
                for (Map.Entry entry : this.childrenByName.asMap().entrySet()) {
                    Name childName = (Name)entry.getKey();
                    int sns = 1;
                    for (Node child : (Collection)entry.getValue()) {
                        Path.Segment childSegment = this.cache.pathFactory.createSegment(childName, sns++);
                        child.updateLocation(childSegment);
                    }
                }
            }
        }

        protected void synchronizeWithNewlyPersistedNode(Location newChild) {
            if (!this.isLoaded()) {
                return;
            }
            Path childPath = newChild.getPath();
            Name childName = childPath.getLastSegment().getName();
            if (this.childrenByName.isEmpty()) {
                this.childrenByName = LinkedListMultimap.create();
                if (childPath.getLastSegment().hasIndex()) {
                    newChild = newChild.with(this.cache.pathFactory.create(childPath.getParent(), childName));
                }
                Node<Payload, PropertyPayload> child = this.cache.createNode(this, this.cache.idFactory.create(), newChild);
                this.childrenByName.put((Object)childName, child);
                return;
            }
            LinkedListMultimap children = LinkedListMultimap.create();
            boolean added = false;
            for (Node child : this.childrenByName.values()) {
                if (!added && child.isNew()) {
                    Node<Payload, PropertyPayload> newChildNode = this.cache.createNode(this, this.cache.idFactory.create(), newChild);
                    children.put((Object)childName, newChildNode);
                    added = true;
                }
                children.put((Object)child.getName(), (Object)child);
            }
            if (!added) {
                Node<Payload, PropertyPayload> newChildNode = this.cache.createNode(this, this.cache.idFactory.create(), newChild);
                children.put((Object)childName, newChildNode);
            }
            this.childrenByName = children;
            List childrenWithName = this.childrenByName.get((Object)childName);
            int snsIndex = 1;
            for (Node sns : childrenWithName) {
                if (sns.getSegment().getIndex() != snsIndex) {
                    Path.Segment newSegment = this.cache.pathFactory.createSegment(childName, snsIndex);
                    sns.updateLocation(newSegment);
                    sns.markAsChanged();
                }
                ++snsIndex;
            }
        }

        public final boolean isChanged(boolean recursive) {
            if (this.status == Status.UNCHANGED) {
                return recursive && this.changedBelow;
            }
            return true;
        }

        public final boolean isNew() {
            return this.status == Status.NEW;
        }

        public boolean containsChangesWithExternalDependencies() {
            assert (!this.isStale());
            if (!this.isChanged(true)) {
                return false;
            }
            for (Map.Entry<NodeId, Dependencies> entry : this.cache.changeDependencies.entrySet()) {
                Node<Payload, PropertyPayload> originalParent;
                Dependencies dependency = entry.getValue();
                NodeId nodeId = entry.getKey();
                Node<Payload, PropertyPayload> changedNode = this.cache.node(nodeId);
                if (!changedNode.isAtOrBelow(this)) {
                    if (this.cache.node(dependency.getMovedFrom()).isAtOrBelow(this)) {
                        return true;
                    }
                    for (NodeId dependentId : dependency.getRequireChangesTo()) {
                        if (!this.cache.node(dependentId).isAtOrBelow(this)) continue;
                        return true;
                    }
                    continue;
                }
                if (dependency.getMovedFrom() == null || (originalParent = this.cache.node(dependency.getMovedFrom())) == null) continue;
                if (!originalParent.isAtOrBelow(this)) {
                    return true;
                }
                for (NodeId dependentId : dependency.getRequireChangesTo()) {
                    if (this.cache.node(dependentId).isAtOrBelow(this)) continue;
                    return true;
                }
            }
            return false;
        }

        public void clearChanges() {
            assert (!this.isStale());
            if (this.status != Status.UNCHANGED) {
                this.status = Status.UNCHANGED;
                this.changedBelow = false;
                this.unload();
            } else {
                if (!this.changedBelow) {
                    return;
                }
                if (this.childrenByName != null && this.childrenByName != this.cache.NO_CHILDREN) {
                    for (Node child : this.childrenByName.values()) {
                        child.clearChanges();
                    }
                }
                this.changedBelow = false;
            }
            if (this.parent != null) {
                this.parent.recomputeChangedBelow();
            }
        }

        public final void markAsChanged() {
            assert (!this.isStale());
            if (this.status == Status.NEW) {
                return;
            }
            this.status = Status.CHANGED;
            if (this.parent != null) {
                this.parent.markAsChangedBelow();
            }
        }

        public final void markAsCopied() {
            assert (!this.isStale());
            this.status = Status.COPIED;
            if (this.parent != null) {
                this.parent.markAsChangedBelow();
            }
        }

        public final void markAsNew() {
            assert (!this.isStale());
            this.status = Status.NEW;
            if (this.parent != null) {
                this.parent.markAsChanged();
            }
        }

        protected final void markAsChangedBelow() {
            if (!this.changedBelow) {
                this.changedBelow = true;
                if (this.parent != null) {
                    this.parent.markAsChangedBelow();
                }
            }
        }

        protected final void recomputeChangedBelow() {
            if (!this.changedBelow) {
                return;
            }
            assert (this.childrenByName != null);
            for (Node child : this.childrenByName.values()) {
                if (!child.isChanged(true)) continue;
                this.markAsChangedBelow();
                return;
            }
            this.changedBelow = false;
            if (this.parent != null) {
                this.parent.recomputeChangedBelow();
            }
        }

        public void moveTo(Node<Payload, PropertyPayload> parent) {
            this.moveTo(parent, null, true);
        }

        public void moveTo(Node<Payload, PropertyPayload> parent, Name newNodeName) {
            this.moveTo(parent, newNodeName, true);
        }

        protected void moveTo(Node<Payload, PropertyPayload> parent, Name newNodeName, boolean useBatch) {
            Node child = this;
            assert (!parent.isStale());
            if (parent.isAtOrBelow(child)) {
                String path = this.cache.readable(this.getPath());
                String parentPath = this.cache.readable(parent.getPath());
                String workspaceName = this.cache.workspaceName;
                String msg = GraphI18n.unableToMoveNodeToBeChildOfDecendent.text(new Object[]{path, parentPath, workspaceName});
                throw new ValidationException(msg);
            }
            assert (!child.isRoot());
            if (newNodeName == null) {
                newNodeName = this.getName();
            }
            this.cache.authorizer.checkPermissions(parent.getPath(), Authorizer.Action.ADD_NODE);
            this.cache.authorizer.checkPermissions(child.getPath().getParent(), Authorizer.Action.REMOVE);
            parent.load();
            this.cache.nodeOperations.preMove(child, parent);
            Node<Payload, PropertyPayload> oldParent = child.parent;
            if (useBatch) {
                if (newNodeName.equals(this.getName())) {
                    this.cache.operations.move(child.getLocation()).into(parent.getLocation());
                } else {
                    ((Graph.Into)this.cache.operations.move(child.getLocation()).as(newNodeName)).into(parent.getLocation());
                }
            } else if (newNodeName.equals(this.getName())) {
                this.cache.store.move(child.getLocation()).into(parent.getLocation());
            } else {
                ((Graph.Into)this.cache.store.move(child.getLocation()).as(newNodeName)).into(parent.getLocation());
            }
            child.remove();
            if (parent.childrenByName == this.cache.NO_CHILDREN) {
                parent.childrenByName = LinkedListMultimap.create();
            }
            parent.childrenByName.put((Object)newNodeName, (Object)child);
            child.parent = parent;
            parent.markAsChanged();
            int snsIndex = parent.childrenByName.get((Object)newNodeName).size();
            Path.Segment segment = this.cache.pathFactory.createSegment(newNodeName, snsIndex);
            child.updateLocation(segment);
            this.cache.recordMove(child, oldParent, parent);
            this.cache.nodeOperations.postMove(child, oldParent);
        }

        public void rename(Name newNodeName) {
            this.moveTo(this.parent, newNodeName, true);
        }

        public void copyTo(Node<Payload, PropertyPayload> parent) {
            CheckArg.isNotNull(parent, (String)"parent");
            CheckArg.isEquals((Object)this.isRoot(), (String)"this.isRoot()", (Object)false, (String)"false");
            Node child = this;
            assert (!parent.isStale());
            assert (child.parent != this);
            assert (!child.isRoot());
            this.cache.authorizer.checkPermissions(parent.getPath(), Authorizer.Action.ADD_NODE);
            this.cache.authorizer.checkPermissions(child.getPath(), Authorizer.Action.READ);
            parent.load();
            if (parent.childrenByName == this.cache.NO_CHILDREN) {
                parent.childrenByName = LinkedListMultimap.create();
            }
            this.cache.nodeOperations.preCopy(this, parent);
            Name childName = child.getName();
            List currentChildren = parent.childrenByName.get((Object)childName);
            Location copyLocation = Location.create(this.cache.pathFactory.create(parent.getPath(), childName, currentChildren.size() + 1));
            this.cache.operations.copy(child.getLocation()).to(copyLocation);
            Node<Payload, PropertyPayload> copy = this.cache.createNode(parent, this.cache.idFactory.create(), copyLocation);
            copy.markAsCopied();
            this.cache.nodeOperations.postCopy(this, copy);
        }

        public void cloneNode() {
            this.copyTo(this.getParent());
        }

        public void orderChildBefore(Path.Segment childToBeMoved, Path.Segment before) throws PathNotFoundException {
            Node<Payload, PropertyPayload> beforeNode;
            CheckArg.isNotNull((Object)childToBeMoved, (String)"childToBeMoved");
            this.cache.authorizer.checkPermissions(this.getPath(), Authorizer.Action.REMOVE);
            this.cache.authorizer.checkPermissions(this.getPath(), Authorizer.Action.ADD_NODE);
            Node<Payload, PropertyPayload> nodeToBeMoved = this.getChild(childToBeMoved);
            Node<Payload, PropertyPayload> node = beforeNode = before != null ? this.getChild(before) : null;
            if (beforeNode == null) {
                this.cache.operations.move(nodeToBeMoved.getLocation()).into(this.location);
            } else {
                this.cache.operations.move(nodeToBeMoved.getLocation()).before(beforeNode.getLocation());
            }
            LinkedListMultimap children = LinkedListMultimap.create();
            for (Node child : this.childrenByName.values()) {
                if (child == nodeToBeMoved) continue;
                if (before != null && child.getSegment().equals(before)) {
                    children.put((Object)nodeToBeMoved.getName(), nodeToBeMoved);
                }
                children.put((Object)child.getName(), (Object)child);
            }
            if (before == null) {
                children.put((Object)nodeToBeMoved.getName(), nodeToBeMoved);
            }
            this.childrenByName = children;
            this.markAsChanged();
            Name movedName = nodeToBeMoved.getName();
            List childrenWithName = this.childrenByName.get((Object)movedName);
            int snsIndex = 1;
            for (Node sns : childrenWithName) {
                if (sns.getSegment().getIndex() != snsIndex) {
                    Path.Segment newSegment = this.cache.pathFactory.createSegment(movedName, snsIndex);
                    sns.updateLocation(newSegment);
                    sns.markAsChanged();
                }
                ++snsIndex;
            }
        }

        protected void remove() {
            this.remove(true);
        }

        protected void remove(boolean markParentAsChanged) {
            assert (!this.isStale());
            assert (this.parent != null);
            assert (this.parent.isLoaded());
            assert (this.parent.childrenByName != null);
            assert (this.parent.childrenByName != this.cache.NO_CHILDREN);
            if (markParentAsChanged) {
                this.parent.markAsChanged();
                this.markAsChanged();
            }
            Name name = this.getName();
            List childrenWithSameName = this.parent.childrenByName.get((Object)name);
            this.parent = null;
            if (childrenWithSameName.size() == 1) {
                childrenWithSameName.clear();
            } else {
                int lastIndex = childrenWithSameName.size() - 1;
                assert (lastIndex > 0);
                int index = childrenWithSameName.indexOf(this);
                childrenWithSameName.remove(index);
                if (index != lastIndex) {
                    for (int i = index; i != lastIndex; ++i) {
                        Node sibling = (Node)childrenWithSameName.get(i);
                        Path.Segment segment = this.cache.pathFactory.createSegment(name, i + 1);
                        sibling.updateLocation(segment);
                    }
                }
            }
        }

        public void destroy() {
            assert (!this.isStale());
            this.cache.authorizer.checkPermissions(this.getPath(), Authorizer.Action.REMOVE);
            Node<Payload, PropertyPayload> parent = this.parent;
            this.cache.nodeOperations.preRemoveChild(parent, this);
            this.remove();
            this.cache.recordDelete(this);
            this.cache.nodeOperations.postRemoveChild(parent, this);
        }

        public final boolean isRoot() {
            return this.parent == null;
        }

        public boolean isStale() {
            Node<Payload, PropertyPayload> node = this;
            while (node.parent != null) {
                node = node.parent;
            }
            return node != this.cache.root;
        }

        public Node<Payload, PropertyPayload> getParent() {
            assert (!this.isStale());
            return this.parent;
        }

        public final NodeId getNodeId() {
            return this.nodeId;
        }

        public Name getName() {
            return this.location.getPath().getLastSegment().getName();
        }

        public final Path.Segment getSegment() {
            return this.location.getPath().getLastSegment();
        }

        public final Path getPath() {
            return this.location.getPath();
        }

        public final Location getLocation() {
            return this.location;
        }

        public final void setUuid(UUID uuid) {
            assert (this.location.getUuid() == null || this.location.getUuid().equals(uuid));
            this.location = this.location.with(uuid);
        }

        public final Location getOriginalLocation() {
            return this.originalLocation;
        }

        public Node<Payload, PropertyPayload> createChild(Name name) {
            CheckArg.isNotNull((Object)name, (String)"name");
            return this.doCreateChild(name, null, null);
        }

        public Node<Payload, PropertyPayload> createChild(Name name, Property ... properties) {
            CheckArg.isNotNull((Object)name, (String)"name");
            CheckArg.isNotNull((Object)properties, (String)"properties");
            return this.doCreateChild(name, null, properties);
        }

        public Node<Payload, PropertyPayload> createChild(Name name, Collection<Property> idProperties) {
            CheckArg.isNotNull((Object)name, (String)"name");
            CheckArg.isNotEmpty(idProperties, (String)"idProperties");
            return this.doCreateChild(name, idProperties, null);
        }

        public Node<Payload, PropertyPayload> createChild(Name name, Collection<Property> idProperties, Property ... remainingProperties) {
            CheckArg.isNotNull((Object)name, (String)"name");
            CheckArg.isNotEmpty(idProperties, (String)"idProperties");
            return this.doCreateChild(name, idProperties, remainingProperties);
        }

        private Node<Payload, PropertyPayload> doCreateChild(Name name, Collection<Property> idProperties, Property[] remainingProperties) throws ValidationException {
            assert (!this.isStale());
            Path path = this.getPath();
            this.cache.authorizer.checkPermissions(path, Authorizer.Action.ADD_NODE);
            this.load();
            List currentChildren = this.childrenByName.get((Object)name);
            Path newPath = this.cache.pathFactory.create(path, name, currentChildren.size() + 1);
            Location newChild = idProperties != null && !idProperties.isEmpty() ? Location.create(newPath, idProperties) : Location.create(newPath);
            HashMap newProperties = new HashMap();
            if (idProperties != null) {
                for (Property idProp : idProperties) {
                    PropertyInfo<Object> info = new PropertyInfo<Object>(idProp, idProp.isMultiple(), Status.NEW, null);
                    newProperties.put(info.getName(), info);
                }
            }
            if (remainingProperties != null) {
                for (Property property : remainingProperties) {
                    PropertyInfo<Object> info2 = new PropertyInfo<Object>(property, property.isMultiple(), Status.NEW, null);
                    newProperties.put(info2.getName(), info2);
                }
            }
            this.cache.nodeOperations.preCreateChild(this, newPath.getLastSegment(), newProperties);
            Status statusBefore = this.status;
            boolean changedBelowBefore = this.changedBelow;
            Node<Payload, PropertyPayload> child = this.cache.createNode(this, this.cache.idFactory.create(), newChild);
            child.markAsNew();
            if (this.childrenByName == this.cache.NO_CHILDREN) {
                this.childrenByName = LinkedListMultimap.create();
            }
            this.childrenByName.put((Object)name, child);
            assert (child.properties == null);
            child.properties = newProperties;
            child.childrenByName = this.cache.NO_CHILDREN;
            try {
                this.cache.nodeOperations.postCreateChild(this, child, child.properties);
                Graph.Create<Graph.Batch> create = this.cache.operations.create(newChild.getPath());
                if (!child.properties.isEmpty()) {
                    for (PropertyInfo<PropertyPayload> property : child.properties.values()) {
                        create.with(property.getProperty());
                    }
                }
                create.and();
            }
            catch (ValidationException e) {
                if (this.childrenByName.size() == 1) {
                    this.childrenByName = this.cache.NO_CHILDREN;
                } else {
                    this.childrenByName.remove((Object)child.getName(), child);
                }
                this.status = statusBefore;
                this.changedBelow = changedBelowBefore;
                throw e;
            }
            this.cache.put(child);
            return child;
        }

        public boolean hasChild(Path.Segment segment) {
            return this.hasChild(segment.getName(), segment.getIndex());
        }

        public boolean hasChild(Name name, int sns) {
            this.load();
            List children = this.childrenByName.get((Object)name);
            return children.size() >= sns;
        }

        public Node<Payload, PropertyPayload> getChild(Path.Segment segment) {
            return this.getChild(segment.getName(), segment.getIndex());
        }

        public Node<Payload, PropertyPayload> getFirstChild(Name name) {
            return this.getChild(name, 1);
        }

        public Node<Payload, PropertyPayload> getChild(Name name, int sns) {
            this.load();
            List children = this.childrenByName.get((Object)name);
            try {
                return (Node)children.get(sns - 1);
            }
            catch (IndexOutOfBoundsException e) {
                Path missingPath = this.cache.pathFactory.create(this.getPath(), name, sns);
                throw new PathNotFoundException(Location.create(missingPath), this.getPath());
            }
        }

        public Iterable<Node<Payload, PropertyPayload>> getChildren(Name name) {
            this.load();
            final List children = this.childrenByName.get((Object)name);
            return new Iterable<Node<Payload, PropertyPayload>>(){

                @Override
                public Iterator<Node<Payload, PropertyPayload>> iterator() {
                    return new ReadOnlyIterator(children.iterator());
                }
            };
        }

        public Iterable<Node<Payload, PropertyPayload>> getChildren() {
            this.load();
            final Collection children = this.childrenByName.values();
            return new Iterable<Node<Payload, PropertyPayload>>(){

                @Override
                public Iterator<Node<Payload, PropertyPayload>> iterator() {
                    return new ReadOnlyIterator(children.iterator());
                }
            };
        }

        public Node<Payload, PropertyPayload> getChildAfter(Node<Payload, PropertyPayload> child) {
            assert (child.getParent() == this);
            if (this.getChildrenCount() < 2) {
                return null;
            }
            Iterator<Node<Payload, PropertyPayload>> iter = this.getChildren().iterator();
            while (iter.hasNext()) {
                Node<Payload, PropertyPayload> nextChild = iter.next();
                if (!child.equals(nextChild)) continue;
                return iter.hasNext() ? iter.next() : null;
            }
            assert (false);
            return null;
        }

        public int getChildrenCount() {
            this.load();
            return this.childrenByName.size();
        }

        public int getChildrenCount(Name name) {
            this.load();
            return this.childrenByName.get((Object)name).size();
        }

        public boolean isLeaf() {
            this.load();
            return this.childrenByName.isEmpty();
        }

        public PropertyInfo<PropertyPayload> getProperty(Name name) {
            this.load();
            return this.properties.get(name);
        }

        public PropertyInfo<PropertyPayload> setProperty(Property property, boolean isMultiValued, PropertyPayload payload) {
            assert (!this.isStale());
            this.cache.authorizer.checkPermissions(this.getPath(), Authorizer.Action.SET_PROPERTY);
            this.load();
            if (this.properties == this.cache.NO_PROPERTIES) {
                this.properties = new HashMap<Name, PropertyInfo<PropertyPayload>>();
            }
            Name name = property.getName();
            PropertyInfo<PropertyPayload> previous = this.properties.get(name);
            Status status = null;
            if (previous != null) {
                status = previous.getStatus();
                if (status == Status.UNCHANGED) {
                    status = Status.CHANGED;
                }
            } else {
                status = Status.NEW;
            }
            PropertyInfo<PropertyPayload> info = new PropertyInfo<PropertyPayload>(property, isMultiValued, status, payload);
            this.cache.nodeOperations.preSetProperty(this, property.getName(), info);
            this.properties.put(name, info);
            this.cache.operations.set(property).on(this.location);
            this.markAsChanged();
            this.cache.nodeOperations.postSetProperty(this, property.getName(), previous);
            return previous;
        }

        public PropertyInfo<PropertyPayload> removeProperty(Name name) {
            assert (!this.isStale());
            this.cache.authorizer.checkPermissions(this.getPath(), Authorizer.Action.REMOVE);
            this.load();
            if (!this.properties.containsKey(name)) {
                return null;
            }
            this.cache.nodeOperations.preRemoveProperty(this, name);
            PropertyInfo<PropertyPayload> results = this.properties.remove(name);
            this.markAsChanged();
            this.cache.operations.remove(name).on(this.location);
            this.cache.nodeOperations.postRemoveProperty(this, name, results);
            return results;
        }

        public Set<Name> getPropertyNames() {
            this.load();
            return this.properties.keySet();
        }

        public Collection<PropertyInfo<PropertyPayload>> getProperties() {
            this.load();
            return this.properties.values();
        }

        public int getPropertyCount() {
            this.load();
            return this.properties.size();
        }

        public boolean isAtOrBelow(Node<Payload, PropertyPayload> other) {
            for (Node<Payload, PropertyPayload> node = this; node != null; node = node.getParent()) {
                if (node != other) continue;
                return true;
            }
            return false;
        }

        public Payload getPayload() {
            this.load();
            return this.payload;
        }

        public void setPayload(Payload payload) {
            this.payload = payload;
        }

        public final int hashCode() {
            return this.nodeId.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Node) {
                Node that = (Node)obj;
                if (this.isStale() || that.isStale()) {
                    return false;
                }
                if (!this.nodeId.equals(that.nodeId)) {
                    return false;
                }
                return this.location.isSame(that.location);
            }
            return false;
        }

        public String getString(NamespaceRegistry registry) {
            return "Cached node <" + this.nodeId + "> at " + this.location.getString(registry);
        }

        public String toString() {
            return this.getString(null);
        }

        public void onLoadedNodes(NodeVisitor<Payload, PropertyPayload> visitor) {
            if (this.isLoaded()) {
                LinkedList<Node<Payload, PropertyPayload>> queue = new LinkedList<Node<Payload, PropertyPayload>>();
                queue.add(this);
                while (!queue.isEmpty()) {
                    Node node = (Node)queue.poll();
                    Iterator<Node<Payload, PropertyPayload>> iter = node.getChildren().iterator();
                    if (!visitor.visit(node)) continue;
                    int index = -1;
                    while (iter.hasNext()) {
                        Node<Payload, PropertyPayload> child = iter.next();
                        if (!child.isLoaded()) continue;
                        queue.add(++index, child);
                    }
                }
            }
            visitor.finish();
        }

        public void onCachedNodes(NodeVisitor<Payload, PropertyPayload> visitor) {
            LinkedList<Node<Payload, PropertyPayload>> queue = new LinkedList<Node<Payload, PropertyPayload>>();
            queue.add(this);
            while (!queue.isEmpty()) {
                Node node = (Node)queue.poll();
                if (!node.isLoaded()) {
                    visitor.visit(node);
                    continue;
                }
                Iterator<Node<Payload, PropertyPayload>> iter = node.getChildren().iterator();
                if (!visitor.visit(node)) continue;
                int index = -1;
                while (iter.hasNext()) {
                    Node<Payload, PropertyPayload> child = iter.next();
                    queue.add(++index, child);
                }
            }
            visitor.finish();
        }

        public void onChangedNodes(NodeVisitor<Payload, PropertyPayload> visitor) {
            if (this.isChanged(true)) {
                LinkedList<Node<Payload, PropertyPayload>> changedNodes = new LinkedList<Node<Payload, PropertyPayload>>();
                changedNodes.add(this);
                while (!changedNodes.isEmpty()) {
                    Node node = (Node)changedNodes.poll();
                    boolean visitChildren = true;
                    if (node.isChanged(false)) {
                        visitChildren = visitor.visit(node);
                    }
                    if (!visitChildren || !node.isChanged(true)) continue;
                    int index = -1;
                    for (Node<Payload, PropertyPayload> child : node.getChildren()) {
                        if (!node.isChanged(true)) continue;
                        changedNodes.add(++index, child);
                    }
                }
            }
            visitor.finish();
        }

        public StructureSnapshot<PropertyPayload> getSnapshot(final boolean pathsOnly) {
            final ArrayList snapshots = new ArrayList();
            this.onCachedNodes(new NodeVisitor<Payload, PropertyPayload>(){

                @Override
                public boolean visit(Node<Payload, PropertyPayload> node) {
                    snapshots.add(new Snapshot(node, pathsOnly, true));
                    return node.isLoaded();
                }
            });
            return new StructureSnapshot(this.cache.context().getNamespaceRegistry(), Collections.unmodifiableList(snapshots));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ThreadSafe
    public static class NodeOperations<Payload, PropertyPayload>
    implements Operations<Payload, PropertyPayload> {
        @Override
        public void materialize(org.modeshape.graph.Node persistentNode, Node<Payload, PropertyPayload> node) {
            HashMap properties = new HashMap();
            for (Property property : persistentNode.getProperties()) {
                Name propertyName = property.getName();
                PropertyInfo<Object> info = new PropertyInfo<Object>(property, property.isMultiple(), Status.UNCHANGED, null);
                properties.put(propertyName, info);
            }
            node.loadedWith(persistentNode.getChildren(), properties, persistentNode.getExpirationTime());
        }

        @Override
        public void materializeProperties(org.modeshape.graph.Node persistentNode, Node<Payload, PropertyPayload> node) {
            HashMap properties = new HashMap();
            for (Property property : persistentNode.getProperties()) {
                Name propertyName = property.getName();
                PropertyInfo<Object> info = new PropertyInfo<Object>(property, property.isMultiple(), Status.UNCHANGED, null);
                properties.put(propertyName, info);
            }
            node.loadedWith(properties);
        }

        @Override
        public void postUpdateLocation(Node<Payload, PropertyPayload> node, Location oldLocation) {
        }

        @Override
        public void preSave(Node<Payload, PropertyPayload> node, DateTime saveTime) throws ValidationException {
        }

        @Override
        public void compute(Graph.Batch batch, Node<Payload, PropertyPayload> node) {
        }

        @Override
        public void preSetProperty(Node<Payload, PropertyPayload> node, Name propertyName, PropertyInfo<PropertyPayload> newProperty) throws ValidationException {
        }

        @Override
        public void postSetProperty(Node<Payload, PropertyPayload> node, Name propertyName, PropertyInfo<PropertyPayload> oldProperty) {
        }

        @Override
        public void preRemoveProperty(Node<Payload, PropertyPayload> node, Name propertyName) throws ValidationException {
        }

        @Override
        public void postRemoveProperty(Node<Payload, PropertyPayload> node, Name propertyName, PropertyInfo<PropertyPayload> oldProperty) {
        }

        @Override
        public void preCreateChild(Node<Payload, PropertyPayload> parent, Path.Segment newChild, Map<Name, PropertyInfo<PropertyPayload>> properties) throws ValidationException {
        }

        @Override
        public void postCreateChild(Node<Payload, PropertyPayload> parent, Node<Payload, PropertyPayload> childChild, Map<Name, PropertyInfo<PropertyPayload>> properties) throws ValidationException {
        }

        @Override
        public void preCopy(Node<Payload, PropertyPayload> original, Node<Payload, PropertyPayload> newParent) throws ValidationException {
        }

        @Override
        public void postCopy(Node<Payload, PropertyPayload> original, Node<Payload, PropertyPayload> copy) throws ValidationException {
        }

        @Override
        public void preMove(Node<Payload, PropertyPayload> nodeToBeMoved, Node<Payload, PropertyPayload> newParent) throws ValidationException {
        }

        @Override
        public void postMove(Node<Payload, PropertyPayload> movedNode, Node<Payload, PropertyPayload> oldParent) {
        }

        @Override
        public void preRemoveChild(Node<Payload, PropertyPayload> parent, Node<Payload, PropertyPayload> newChild) throws ValidationException {
        }

        @Override
        public void postRemoveChild(Node<Payload, PropertyPayload> parent, Node<Payload, PropertyPayload> oldChild) {
        }
    }

    @ThreadSafe
    protected static class NoOpAuthorizer
    implements Authorizer {
        protected NoOpAuthorizer() {
        }

        public void checkPermissions(Path path, Authorizer.Action action) throws AccessControlException {
        }
    }

    @ThreadSafe
    public static interface Authorizer {
        public void checkPermissions(Path var1, Action var2) throws AccessControlException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Action {
            READ,
            REMOVE,
            ADD_NODE,
            SET_PROPERTY;

        }
    }

    @ThreadSafe
    public static interface NodeIdFactory {
        public NodeId create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ThreadSafe
    public static interface Operations<NodePayload, PropertyPayload> {
        public void materialize(org.modeshape.graph.Node var1, Node<NodePayload, PropertyPayload> var2);

        public void materializeProperties(org.modeshape.graph.Node var1, Node<NodePayload, PropertyPayload> var2);

        public void postUpdateLocation(Node<NodePayload, PropertyPayload> var1, Location var2);

        public void preSetProperty(Node<NodePayload, PropertyPayload> var1, Name var2, PropertyInfo<PropertyPayload> var3) throws ValidationException;

        public void postSetProperty(Node<NodePayload, PropertyPayload> var1, Name var2, PropertyInfo<PropertyPayload> var3);

        public void preRemoveProperty(Node<NodePayload, PropertyPayload> var1, Name var2) throws ValidationException;

        public void postRemoveProperty(Node<NodePayload, PropertyPayload> var1, Name var2, PropertyInfo<PropertyPayload> var3);

        public void preCreateChild(Node<NodePayload, PropertyPayload> var1, Path.Segment var2, Map<Name, PropertyInfo<PropertyPayload>> var3) throws ValidationException;

        public void postCreateChild(Node<NodePayload, PropertyPayload> var1, Node<NodePayload, PropertyPayload> var2, Map<Name, PropertyInfo<PropertyPayload>> var3) throws ValidationException;

        public void preMove(Node<NodePayload, PropertyPayload> var1, Node<NodePayload, PropertyPayload> var2) throws ValidationException;

        public void postMove(Node<NodePayload, PropertyPayload> var1, Node<NodePayload, PropertyPayload> var2);

        public void preCopy(Node<NodePayload, PropertyPayload> var1, Node<NodePayload, PropertyPayload> var2) throws ValidationException;

        public void postCopy(Node<NodePayload, PropertyPayload> var1, Node<NodePayload, PropertyPayload> var2);

        public void preRemoveChild(Node<NodePayload, PropertyPayload> var1, Node<NodePayload, PropertyPayload> var2) throws ValidationException;

        public void postRemoveChild(Node<NodePayload, PropertyPayload> var1, Node<NodePayload, PropertyPayload> var2);

        public void preSave(Node<NodePayload, PropertyPayload> var1, DateTime var2) throws ValidationException;

        public void compute(Graph.Batch var1, Node<NodePayload, PropertyPayload> var2);
    }
}

