/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import org.jgroups.Message;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Util;

public class RequestOptions {
    private int mode = 6;
    private long timeout;
    private boolean use_anycasting;
    private RspFilter rsp_filter;
    private byte flags;
    public static final RequestOptions SYNC = new RequestOptions(2, 5000L);
    public static final RequestOptions ASYNC = new RequestOptions(6, 5000L);

    public RequestOptions() {
    }

    public RequestOptions(int mode, long timeout, boolean use_anycasting, RspFilter rsp_filter, byte flags) {
        this.mode = mode;
        this.timeout = timeout;
        this.use_anycasting = use_anycasting;
        this.rsp_filter = rsp_filter;
        this.flags = flags;
    }

    public RequestOptions(int mode, long timeout, boolean use_anycasting, RspFilter rsp_filter) {
        this(mode, timeout, use_anycasting, rsp_filter, 0);
    }

    public RequestOptions(int mode, long timeout) {
        this(mode, timeout, false, null);
    }

    public int getMode() {
        return this.mode;
    }

    public RequestOptions setMode(int mode) {
        this.mode = mode;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RequestOptions setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean getAnycasting() {
        return this.use_anycasting;
    }

    public RequestOptions setAnycasting(boolean use_anycasting) {
        this.use_anycasting = use_anycasting;
        return this;
    }

    public RspFilter getRspFilter() {
        return this.rsp_filter;
    }

    public RequestOptions setRspFilter(RspFilter rsp_filter) {
        this.rsp_filter = rsp_filter;
        return this;
    }

    public byte getFlags() {
        return this.flags;
    }

    public RequestOptions setFlags(byte flags) {
        this.flags = Util.setFlag(this.flags, flags);
        return this;
    }

    public RequestOptions clearFlags(byte flags) {
        this.flags = Util.clearFlags(this.flags, flags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("mode=" + Request.modeToString(this.mode));
        sb.append(", timeout=" + this.timeout);
        if (this.use_anycasting) {
            sb.append(", anycasting=true");
        }
        sb.append(", flags=" + Message.flagsToString(this.flags));
        return sb.toString();
    }
}

