/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Event;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.TimeScheduler;

public class BARRIER
extends Protocol {
    @Property(description="Max time barrier can be closed. Default is 60000 ms")
    long max_close_time = 60000L;
    final Lock lock = new ReentrantLock();
    final AtomicBoolean barrier_closed = new AtomicBoolean(false);
    Condition barrier_opened = this.lock.newCondition();
    Condition no_msgs_pending = this.lock.newCondition();
    ConcurrentMap<Thread, Object> in_flight_threads = new ConcurrentHashMap<Thread, Object>();
    Future<?> barrier_opener_future = null;
    TimeScheduler timer;
    private static final Object NULL = new Object();

    @ManagedAttribute
    public boolean isClosed() {
        return this.barrier_closed.get();
    }

    public int getNumberOfInFlightThreads() {
        return this.in_flight_threads.size();
    }

    @ManagedAttribute
    public int getInFlightThreadsCount() {
        return this.getNumberOfInFlightThreads();
    }

    @ManagedAttribute
    public boolean isOpenerScheduled() {
        return this.barrier_opener_future != null && !this.barrier_opener_future.isDone() && !this.barrier_opener_future.isCancelled();
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.timer = this.getTransport().getTimer();
    }

    @Override
    public void stop() {
        super.stop();
        this.openBarrier();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.openBarrier();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 76: {
                this.closeBarrier();
                return null;
            }
            case 77: {
                this.openBarrier();
                return null;
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Thread current_thread = Thread.currentThread();
                this.in_flight_threads.put(current_thread, NULL);
                if (this.barrier_closed.get()) {
                    this.lock.lock();
                    try {
                        this.in_flight_threads.remove(current_thread);
                        while (this.barrier_closed.get()) {
                            try {
                                this.barrier_opened.await();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    finally {
                        this.in_flight_threads.put(current_thread, NULL);
                        this.lock.unlock();
                    }
                }
                try {
                    Object object = this.up_prot.up(evt);
                    return object;
                }
                finally {
                    this.lock.lock();
                    try {
                        if (this.in_flight_threads.remove(current_thread) == NULL && this.barrier_closed.get() && this.in_flight_threads.isEmpty()) {
                            this.no_msgs_pending.signalAll();
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
            case 76: {
                this.closeBarrier();
                return null;
            }
            case 77: {
                this.openBarrier();
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeBarrier() {
        if (!this.barrier_closed.compareAndSet(false, true)) {
            return;
        }
        HashSet<Thread> threads = new HashSet<Thread>();
        this.lock.lock();
        try {
            this.in_flight_threads.remove(Thread.currentThread());
            while (!this.in_flight_threads.isEmpty()) {
                Iterator it = this.in_flight_threads.keySet().iterator();
                while (it.hasNext()) {
                    Thread thread = (Thread)it.next();
                    Thread.State state = thread.getState();
                    if (state == Thread.State.RUNNABLE || state == Thread.State.NEW) continue;
                    threads.add(thread);
                    it.remove();
                }
                if (this.in_flight_threads.isEmpty()) continue;
                try {
                    this.no_msgs_pending.await(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {}
            }
        }
        finally {
            for (Thread thread : threads) {
                this.in_flight_threads.put(thread, NULL);
            }
            this.lock.unlock();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("barrier was closed");
        }
        if (this.max_close_time > 0L) {
            this.scheduleBarrierOpener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openBarrier() {
        this.lock.lock();
        try {
            if (!this.barrier_closed.compareAndSet(true, false)) {
                return;
            }
            this.barrier_opened.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("barrier was opened");
        }
        this.cancelBarrierOpener();
    }

    private void scheduleBarrierOpener() {
        if (this.barrier_opener_future == null || this.barrier_opener_future.isDone()) {
            this.barrier_opener_future = this.timer.schedule(new Runnable(){

                @Override
                public void run() {
                    BARRIER.this.openBarrier();
                }
            }, this.max_close_time, TimeUnit.MILLISECONDS);
        }
    }

    private void cancelBarrierOpener() {
        if (this.barrier_opener_future != null) {
            this.barrier_opener_future.cancel(true);
            this.barrier_opener_future = null;
        }
    }
}

