/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import org.jboss.marshalling.ByteInput;

public class NioByteInput
extends InputStream
implements ByteInput {
    private final Queue<ByteBuffer> queue;
    private final InputHandler inputHandler;
    private boolean eof;
    private IOException failure;

    public NioByteInput(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
        this.queue = new ArrayDeque<ByteBuffer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(ByteBuffer buffer) {
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            if (!this.eof && this.failure == null) {
                this.queue.add(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEof() {
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            this.eof = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushException(IOException e) {
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            if (!this.eof) {
                this.failure = e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Queue<ByteBuffer> queue = this.queue;
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            while (queue.isEmpty()) {
                if (this.eof) {
                    return -1;
                }
                this.checkFailure();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("Interrupted on read()");
                }
            }
            ByteBuffer buf = queue.peek();
            int v = buf.get() & 0xFF;
            if (buf.remaining() == 0) {
                queue.poll();
                try {
                    this.inputHandler.acknowledge();
                }
                catch (IOException e) {
                    this.eof = true;
                    queue.clear();
                    throw e;
                }
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        Queue<ByteBuffer> queue = this.queue;
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            ByteBuffer buffer;
            while (queue.isEmpty()) {
                if (this.eof) {
                    return -1;
                }
                this.checkFailure();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("Interrupted on read()");
                }
            }
            int total = 0;
            while (len > 0 && (buffer = queue.peek()) != null) {
                int bytecnt = Math.min(buffer.remaining(), len);
                buffer.get(b, off, bytecnt);
                total += bytecnt;
                len -= bytecnt;
                if (buffer.remaining() != 0) continue;
                try {
                    this.inputHandler.acknowledge();
                }
                catch (IOException e) {
                    this.eof = true;
                    queue.clear();
                    throw e;
                }
            }
            return total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            int total = 0;
            for (ByteBuffer buffer : this.queue) {
                if ((total += buffer.remaining()) >= 0) continue;
                return Integer.MAX_VALUE;
            }
            return total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long qty) throws IOException {
        Queue<ByteBuffer> queue = this.queue;
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            ByteBuffer buffer;
            while (queue.isEmpty()) {
                if (this.eof) {
                    return 0L;
                }
                this.checkFailure();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("Interrupted on read()");
                }
            }
            long skipped = 0L;
            while (qty > 0L && (buffer = queue.peek()) != null) {
                int bytecnt = Math.min(buffer.remaining(), (int)Math.max(Integer.MAX_VALUE, qty));
                buffer.position(buffer.position() + bytecnt);
                skipped += (long)bytecnt;
                qty -= (long)bytecnt;
                if (buffer.remaining() != 0) continue;
                queue.poll();
                try {
                    this.inputHandler.acknowledge();
                }
                catch (IOException e) {
                    this.eof = true;
                    queue.clear();
                    throw e;
                }
            }
            return skipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        NioByteInput nioByteInput = this;
        synchronized (nioByteInput) {
            if (!this.eof) {
                this.queue.clear();
                this.eof = true;
                this.inputHandler.close();
            }
        }
    }

    private void checkFailure() throws IOException {
        IOException failure = this.failure;
        if (failure != null) {
            failure.fillInStackTrace();
            try {
                throw failure;
            }
            catch (Throwable throwable) {
                this.eof = true;
                this.failure = null;
                throw throwable;
            }
        }
    }

    public static interface InputHandler
    extends Closeable {
        public void acknowledge() throws IOException;

        public void close() throws IOException;
    }
}

