/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa;

import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.Session;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.engine.SessionFactoryImplementor;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.Logger;
import org.modeshape.connector.store.jpa.JpaAdapter;
import org.modeshape.connector.store.jpa.JpaConnectorI18n;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.connector.store.jpa.model.common.NamespaceEntity;
import org.modeshape.connector.store.jpa.model.common.WorkspaceEntity;
import org.modeshape.connector.store.jpa.model.simple.LargeValueEntity;
import org.modeshape.connector.store.jpa.model.simple.NodeEntity;
import org.modeshape.connector.store.jpa.model.simple.SubgraphNodeEntity;
import org.modeshape.connector.store.jpa.model.simple.SubgraphQueryEntity;
import org.modeshape.connector.store.jpa.util.StoreOptionEntity;
import org.modeshape.graph.ExecutionContext;

public class HibernateAdapter
implements JpaAdapter {
    private static final Logger LOGGER = Logger.getLogger(HibernateAdapter.class);

    @Override
    public Properties getProperties(JpaSource source) {
        Properties jpaProperties = new Properties();
        if (source.getDialect() != null) {
            this.setProperty(jpaProperties, "hibernate.dialect", source.getDialect());
        }
        if (source.getIsolationLevel() != null) {
            this.setProperty(jpaProperties, "hibernate.connection.isolation", source.getIsolationLevel());
        }
        if (source.getSchemaName() != null) {
            this.setProperty(jpaProperties, "hibernate.default_schema", source.getSchemaName());
        }
        String showSql = String.valueOf(source.getShowSql());
        this.setProperty(jpaProperties, "hibernate.show_sql", showSql);
        this.setProperty(jpaProperties, "hibernate.format_sql", showSql);
        this.setProperty(jpaProperties, "hibernate.use_sql_comments", showSql);
        if (!"disable".equalsIgnoreCase(source.getAutoGenerateSchema())) {
            this.setProperty(jpaProperties, "hibernate.hbm2ddl.auto", source.getAutoGenerateSchema());
        }
        if (source.getDataSourceJndiName() != null) {
            this.setProperty(jpaProperties, "hibernate.connection.datasource", source.getDataSourceJndiName());
        } else {
            if (source.getRepositoryContext() != null && source.getDriverClassloaderName() != null) {
                try {
                    ExecutionContext context = source.getRepositoryContext().getExecutionContext();
                    ClassLoader loader = context.getClassLoader(new String[]{source.getDriverClassloaderName()});
                    if (loader != null) {
                        Thread.currentThread().setContextClassLoader(loader);
                    }
                }
                catch (Throwable t) {
                    I18n msg = JpaConnectorI18n.errorSettingContextClassLoader;
                    Logger.getLogger(this.getClass()).error(t, msg, new Object[]{source.getName(), source.getDriverClassloaderName()});
                }
            }
            this.setProperty(jpaProperties, "hibernate.connection.driver_class", source.getDriverClassName());
            this.setProperty(jpaProperties, "hibernate.connection.username", source.getUsername());
            this.setProperty(jpaProperties, "hibernate.connection.password", source.getPassword());
            this.setProperty(jpaProperties, "hibernate.connection.url", source.getUrl());
            this.setProperty(jpaProperties, "hibernate.max_fetch_depth", 3);
            this.setProperty(jpaProperties, "hibernate.connection.pool_size", 0);
            if (source.getMaximumConnectionsInPool() > 0) {
                this.setProperty(jpaProperties, "hibernate.connection.provider_class", "org.hibernate.connection.C3P0ConnectionProvider");
                this.setProperty(jpaProperties, "hibernate.c3p0.max_size", source.getMaximumConnectionsInPool());
                this.setProperty(jpaProperties, "hibernate.c3p0.min_size", source.getMinimumConnectionsInPool());
                this.setProperty(jpaProperties, "hibernate.c3p0.timeout", source.getMaximumConnectionIdleTimeInSeconds());
                this.setProperty(jpaProperties, "hibernate.c3p0.max_statements", source.getMaximumSizeOfStatementCache());
                this.setProperty(jpaProperties, "hibernate.c3p0.idle_test_period", source.getIdleTimeInSecondsBeforeTestingConnections());
                this.setProperty(jpaProperties, "hibernate.c3p0.acquire_increment", source.getNumberOfConnectionsToAcquireAsNeeded());
                this.setProperty(jpaProperties, "hibernate.c3p0.validate", "false");
            }
        }
        if (source.getCacheProviderClassName() != null) {
            this.setProperty(jpaProperties, "hibernate.cache.use_query_cache", "true");
            this.setProperty(jpaProperties, "hibernate.cache.provider_class", source.getCacheProviderClassName());
            String cacheConcurrencyStrategy = source.getCacheConcurrencyStrategy();
            this.setProperty(jpaProperties, "hibernate.ejb.classcache.org.modeshape.connector.store.jpa.model.common.WorkspaceEntity", cacheConcurrencyStrategy);
            this.setProperty(jpaProperties, "hibernate.ejb.classcache.org.modeshape.connector.store.jpa.model.common.NamespaceEntity", cacheConcurrencyStrategy);
            this.setProperty(jpaProperties, "hibernate.ejb.classcache.org.modeshape.connector.store.jpa.model.simple.NodeEntity", cacheConcurrencyStrategy);
            this.setProperty(jpaProperties, "hibernate.ejb.classcache.org.modeshape.connector.store.jpa.model.simple.LargeValueEntity", cacheConcurrencyStrategy);
            this.setProperty(jpaProperties, "hibernate.ejb.collectioncache.org.modeshape.connector.store.jpa.model.simple.NodeEntity.children", cacheConcurrencyStrategy);
            this.setProperty(jpaProperties, "hibernate.ejb.collectioncache.org.modeshape.connector.store.jpa.model.simple.NodeEntity.largeValues", cacheConcurrencyStrategy);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Properties for Hibernate configuration used for ModeShape JPA Source {0}:", new Object[]{source.getName()});
            for (Map.Entry<Object, Object> entry : jpaProperties.entrySet()) {
                String propName = entry.getKey().toString();
                if (!propName.startsWith("hibernate")) continue;
                LOGGER.debug("  {0} = {1}", new Object[]{propName, entry.getValue()});
            }
        }
        return jpaProperties;
    }

    protected void setProperty(Properties configurator, String propertyName, String propertyValue) {
        assert (configurator != null);
        assert (propertyName != null);
        assert (propertyName.trim().length() != 0);
        if (propertyValue != null) {
            configurator.put(propertyName, propertyValue.trim());
        }
    }

    protected void setProperty(Properties configurator, String propertyName, int propertyValue) {
        assert (configurator != null);
        assert (propertyName != null);
        assert (propertyName.trim().length() != 0);
        configurator.put(propertyName, Integer.toString(propertyValue));
    }

    @Override
    public String determineDialect(EntityManager entityManager) {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)((Session)entityManager.unwrap(Session.class)).getSessionFactory();
        return sessionFactory.getDialect().toString();
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory(JpaSource source) {
        return new Ejb3Configuration().addAnnotatedClass(StoreOptionEntity.class).addAnnotatedClass(NamespaceEntity.class).addAnnotatedClass(WorkspaceEntity.class).addAnnotatedClass(LargeValueEntity.class).addAnnotatedClass(NodeEntity.class).addAnnotatedClass(SubgraphNodeEntity.class).addAnnotatedClass(SubgraphQueryEntity.class).addProperties(this.getProperties(source)).buildEntityManagerFactory();
    }
}

