/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Timestamper {
    public static final int BIN_DIGITS = Integer.getInteger("net.sf.ehcache.util.Timestamper.shift", 12);
    public static final int ONE_MS = 1 << BIN_DIGITS;
    private static final Logger LOG = LoggerFactory.getLogger(Timestamper.class);
    private static final AtomicLong VALUE = new AtomicLong();

    private Timestamper() {
    }

    public static long next() {
        int runs = 0;
        block0: while (true) {
            if (runs++ > 0 && LOG.isInfoEnabled()) {
                LOG.info("Thread spin-waits on time to pass. Looped " + runs + " times, you might want to increase -Dnet.sf.ehcache.util.Timestamper.shift");
            }
            long base = System.currentTimeMillis() << BIN_DIGITS;
            long maxValue = base + (long)ONE_MS - 1L;
            long current = VALUE.get();
            long update = Math.max(base, current + 1L);
            while (true) {
                if (update >= maxValue) continue block0;
                if (VALUE.compareAndSet(current, update)) {
                    return update;
                }
                current = VALUE.get();
                update = Math.max(base, current + 1L);
            }
            break;
        }
    }
}

