/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Region;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.infinispan.util.AddressAdapter;
import org.hibernate.cache.infinispan.util.AddressAdapterImpl;
import org.hibernate.cache.infinispan.util.CacheAdapter;
import org.hibernate.cache.infinispan.util.CacheHelper;
import org.hibernate.cache.infinispan.util.FlagAdapter;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseRegion
implements Region {
    private static final Log log = LogFactory.getLog(BaseRegion.class);
    private final String name;
    protected final CacheAdapter cacheAdapter;
    protected final AddressAdapter address;
    protected final Set<AddressAdapter> currentView = new HashSet<AddressAdapter>();
    protected final TransactionManager transactionManager;
    protected final boolean replication;
    protected final Object invalidationMutex = new Object();
    protected final AtomicReference<InvalidateState> invalidateState = new AtomicReference<InvalidateState>(InvalidateState.VALID);
    private final RegionFactory factory;

    public BaseRegion(CacheAdapter cacheAdapter, String name, TransactionManager transactionManager, RegionFactory factory) {
        this.cacheAdapter = cacheAdapter;
        this.name = name;
        this.transactionManager = transactionManager;
        this.replication = cacheAdapter.isClusteredReplication();
        this.address = this.cacheAdapter.getAddress();
        this.cacheAdapter.addListener(this);
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.address != null) {
            Set<AddressAdapter> set = this.currentView;
            synchronized (set) {
                List<AddressAdapter> view = this.cacheAdapter.getMembers();
                if (view != null) {
                    this.currentView.addAll(view);
                    this.establishInternalNodes();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishInternalNodes() {
        Transaction tx = this.suspend();
        try {
            for (AddressAdapter member : this.currentView) {
                CacheHelper.initInternalEvict(this.cacheAdapter, member);
            }
        }
        finally {
            this.resume(tx);
        }
    }

    public String getName() {
        return this.name;
    }

    public CacheAdapter getCacheAdapter() {
        return this.cacheAdapter;
    }

    public long getElementCountInMemory() {
        if (this.checkValid()) {
            Set keySet = this.cacheAdapter.keySet();
            int size = this.cacheAdapter.size();
            if (CacheHelper.containsEvictAllNotification(keySet, this.address)) {
                --size;
            }
            return size;
        }
        return 0L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public int getTimeout() {
        return 600;
    }

    public long nextTimestamp() {
        return this.factory.nextTimestamp();
    }

    public Map toMap() {
        if (this.checkValid()) {
            HashMap map = new HashMap();
            Set entries = this.cacheAdapter.toMap().entrySet();
            for (Map.Entry entry : entries) {
                Object key = entry.getKey();
                if (CacheHelper.isEvictAllNotification(key)) continue;
                map.put(key, entry.getValue());
            }
            return map;
        }
        return Collections.EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws CacheException {
        try {
            this.cacheAdapter.clear();
        }
        finally {
            this.cacheAdapter.removeListener(this);
        }
    }

    public boolean contains(Object key) {
        if (!this.checkValid()) {
            return false;
        }
        return this.cacheAdapter.withFlags(FlagAdapter.ZERO_LOCK_ACQUISITION_TIMEOUT).containsKey(key);
    }

    public AddressAdapter getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkValid() {
        boolean valid;
        boolean bl = valid = this.invalidateState.get() == InvalidateState.VALID;
        if (!valid) {
            Object object = this.invalidationMutex;
            synchronized (object) {
                if (this.invalidateState.compareAndSet(InvalidateState.INVALID, InvalidateState.CLEARING)) {
                    Transaction tx = this.suspend();
                    try {
                        this.cacheAdapter.withFlags(FlagAdapter.CACHE_MODE_LOCAL, FlagAdapter.ZERO_LOCK_ACQUISITION_TIMEOUT).clear();
                        this.invalidateState.compareAndSet(InvalidateState.CLEARING, InvalidateState.VALID);
                    }
                    catch (Exception e) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Could not invalidate region: " + e.getLocalizedMessage()));
                        }
                    }
                    finally {
                        this.resume(tx);
                    }
                }
            }
            valid = this.invalidateState.get() == InvalidateState.VALID;
        }
        return valid;
    }

    protected Object get(Object key, FlagAdapter opt, boolean suppressTimeout) throws CacheException {
        if (suppressTimeout) {
            return this.cacheAdapter.getAllowingTimeout(key);
        }
        return this.cacheAdapter.get(key);
    }

    public Object getOwnerForPut() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.getTransaction();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not obtain transaction", (Throwable)se);
        }
        return tx == null ? Thread.currentThread() : tx;
    }

    public Transaction suspend() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.suspend();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not suspend transaction", (Throwable)se);
        }
        return tx;
    }

    public void resume(Transaction tx) {
        try {
            if (tx != null) {
                this.transactionManager.resume(tx);
            }
        }
        catch (Exception e) {
            throw new CacheException("Could not resume transaction", (Throwable)e);
        }
    }

    @CacheEntryModified
    public void entryModified(CacheEntryModifiedEvent event) {
        this.handleEvictAllModification(event);
    }

    protected boolean handleEvictAllModification(CacheEntryModifiedEvent event) {
        if (!event.isPre() && (this.replication || event.isOriginLocal()) && CacheHelper.isEvictAllNotification(event.getKey(), event.getValue())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Set invalid state because marker cache entry was put: {0}", new Object[]{event});
            }
            this.invalidateState.set(InvalidateState.INVALID);
            return true;
        }
        return false;
    }

    @CacheEntryInvalidated
    public void entryInvalidated(CacheEntryInvalidatedEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Cache entry invalidated: {0}", new Object[]{event});
        }
        this.handleEvictAllInvalidation(event);
    }

    protected boolean handleEvictAllInvalidation(CacheEntryInvalidatedEvent event) {
        if (!event.isPre() && CacheHelper.isEvictAllNotification(event.getKey())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Set invalid state because marker cache entry was invalidated: {0}", new Object[]{event});
            }
            this.invalidateState.set(InvalidateState.INVALID);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ViewChanged
    public void viewChanged(ViewChangedEvent event) {
        Set<AddressAdapter> set = this.currentView;
        synchronized (set) {
            List<AddressAdapter> view = AddressAdapterImpl.toAddressAdapter(event.getNewMembers());
            if (view != null) {
                this.currentView.addAll(view);
                this.establishInternalNodes();
            }
        }
    }

    private static enum InvalidateState {
        INVALID,
        CLEARING,
        VALID;

    }
}

