/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.lang.reflect.Method;
import javax.management.MBeanServer;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.MembershipListenerAdapter;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Util;

public class RpcDispatcherSpeedTest
extends MembershipListenerAdapter {
    Channel channel;
    RpcDispatcher disp;
    String props = null;
    boolean server = false;
    boolean jmx = false;
    int num = 1000;
    int mode = 1;
    static final int OLD = 1;
    static final int METHOD = 2;
    static final int TYPES = 3;
    static final int ID = 5;
    static final long TIMEOUT = 10000L;
    static final Class LONG_CLASS = Long.TYPE;
    static final String LONG = Long.TYPE.getName();
    final Method[] METHODS = new Method[1];
    final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    final String[] EMPTY_STRING_ARRAY = new String[0];
    private long sleep = 0L;
    private boolean async;

    public RpcDispatcherSpeedTest(String props, boolean server, boolean async, int num, int mode, boolean jmx, long sleep) throws NoSuchMethodException {
        this.props = props;
        this.server = server;
        this.async = async;
        this.num = num;
        this.mode = mode;
        this.jmx = jmx;
        this.sleep = sleep;
        this.initMethods();
    }

    final void initMethods() throws NoSuchMethodException {
        Class<?> cl = this.getClass();
        this.METHODS[0] = cl.getMethod("measure", new Class[0]);
    }

    public long measure() throws Exception {
        long retval = System.currentTimeMillis();
        if (this.sleep > 0L) {
            Util.sleep(this.sleep);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        this.channel.setOpt(3, Boolean.FALSE);
        this.disp = new RpcDispatcher(this.channel, null, (MembershipListener)this, (Object)this);
        this.disp.setMethodLookup(new MethodLookup(){

            @Override
            public Method findMethod(short id) {
                return RpcDispatcherSpeedTest.this.METHODS[0];
            }
        });
        if (this.jmx) {
            MBeanServer srv = Util.getMBeanServer();
            if (srv == null) {
                throw new Exception("No MBeanServers found;\nDraw needs to be run with an MBeanServer present, or inside JDK 5");
            }
            JmxConfigurator.registerChannel((JChannel)this.channel, srv, "jgroups", this.channel.getClusterName(), true);
        }
        this.channel.connect("RpcDispatcherSpeedTestGroup");
        try {
            if (this.server) {
                System.out.println("-- Started as server. Press ctrl-c to kill");
                while (true) {
                    Util.sleep(10000L);
                }
            }
            this.invokeRpcs(this.num, this.mode, this.async);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            this.channel.close();
            this.disp.stop();
        }
    }

    void invokeRpcs(int num, int mode, boolean async) throws Exception {
        int show = num / 10;
        Method measure_method = this.getClass().getMethod("measure", this.EMPTY_CLASS_ARRAY);
        MethodCall measure_method_call = new MethodCall(measure_method, this.EMPTY_OBJECT_ARRAY);
        if (show <= 0) {
            show = 1;
        }
        int request_type = async ? 6 : 2;
        long start = System.currentTimeMillis();
        switch (mode) {
            case 1: {
                System.out.println("-- invoking " + num + " methods using mode=OLD");
                for (int i = 1; i <= num; ++i) {
                    this.disp.callRemoteMethods(null, "measure", this.EMPTY_OBJECT_ARRAY, this.EMPTY_CLASS_ARRAY, request_type, 10000L);
                    if (i % show != 0) continue;
                    System.out.println(i);
                }
                break;
            }
            case 2: {
                System.out.println("-- invoking " + num + " methods using mode=METHOD");
                for (int i = 1; i <= num; ++i) {
                    this.disp.callRemoteMethods(null, measure_method_call, request_type, 10000L);
                    if (i % show != 0) continue;
                    System.out.println(i);
                }
                break;
            }
            case 3: {
                System.out.println("-- invoking " + num + " methods using mode=TYPES");
                for (int i = 1; i <= num; ++i) {
                    this.disp.callRemoteMethods(null, "measure", this.EMPTY_OBJECT_ARRAY, this.EMPTY_CLASS_ARRAY, request_type, 10000L);
                    if (i % show != 0) continue;
                    System.out.println(i);
                }
                break;
            }
            case 5: {
                System.out.println("-- invoking " + num + " methods using mode=ID");
                measure_method_call = new MethodCall(0, new Object[0]);
                RequestOptions opts = new RequestOptions(request_type, 10000L, false, null, 4);
                opts.setFlags((byte)8);
                for (int i = 1; i <= num; ++i) {
                    this.disp.callRemoteMethods(null, measure_method_call, opts);
                    if (i % show != 0) continue;
                    System.out.println(i);
                }
                break;
            }
        }
        long stop = System.currentTimeMillis();
        RpcDispatcherSpeedTest.printStats(stop - start, num);
    }

    static void printStats(long total_time, int num) {
        double throughput = (double)num / ((double)total_time / 1000.0);
        System.out.println("time for " + num + " remote calls was " + total_time + ", avg=" + (double)total_time / (double)num + "ms/invocation, " + (long)throughput + " calls/sec");
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("-- new view: " + new_view);
    }

    public static void main(String[] args) {
        String props = null;
        boolean server = false;
        boolean jmx = false;
        int num = 1000;
        long sleep = 0L;
        int mode = 1;
        boolean async = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-server".equals(args[i])) {
                server = true;
                continue;
            }
            if ("-async".equals(args[i])) {
                async = true;
                continue;
            }
            if ("-num".equals(args[i])) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-jmx".equals(args[i])) {
                jmx = true;
                continue;
            }
            if ("-sleep".equals(args[i])) {
                sleep = Long.parseLong(args[++i]);
                continue;
            }
            if ("-mode".equals(args[i])) {
                String m;
                if ("old".equals(m = args[++i].toLowerCase().trim())) {
                    mode = 1;
                    continue;
                }
                if ("method".equals(m)) {
                    mode = 2;
                    continue;
                }
                if ("types".equals(m)) {
                    mode = 3;
                    continue;
                }
                if ("ID".equals(m) || "id".equals(m)) {
                    mode = 5;
                    continue;
                }
                System.err.println("mode " + m + " is invalid");
                RpcDispatcherSpeedTest.help();
                return;
            }
            RpcDispatcherSpeedTest.help();
            return;
        }
        try {
            RpcDispatcherSpeedTest test = new RpcDispatcherSpeedTest(props, server, async, num, mode, jmx, sleep);
            test.start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println("RpcDispatcherSpeedTest [-help] [-props <props>] [-server] [-async] [-num <number of calls>] [-mode <mode>] [-jmx] [-sleep <ms>]");
        System.out.println("mode can be either 'old', 'method', 'types' or 'id'");
    }
}

