/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.cluster;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.loaders.AbstractCacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.cluster.ClusterCacheLoaderConfig;
import org.infinispan.marshall.Marshaller;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterCacheLoader
extends AbstractCacheLoader {
    private static Log log = LogFactory.getLog(ClusterCacheLoader.class);
    private ClusterCacheLoaderConfig config;
    private RpcManager rpcManager;
    private AdvancedCache cache;

    public void init(CacheLoaderConfig config, Cache cache, Marshaller m) {
        this.config = (ClusterCacheLoaderConfig)config;
        this.cache = cache.getAdvancedCache();
        this.rpcManager = this.cache.getRpcManager();
    }

    @Override
    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        if (!this.isCacheReady() || !this.isLocalCall()) {
            return null;
        }
        ClusteredGetCommand clusteredGetCommand = new ClusteredGetCommand(key, this.cache.getName());
        List<Response> response = this.doRemoteCall(clusteredGetCommand);
        if (response.isEmpty()) {
            return null;
        }
        if (response.size() > 1) {
            throw new CacheLoaderException("Response length is always 0 or 1, received: " + response);
        }
        Response firstResponse = response.get(0);
        if (firstResponse.isSuccessful() && firstResponse instanceof SuccessfulResponse) {
            InternalCacheValue value = (InternalCacheValue)((SuccessfulResponse)firstResponse).getResponseValue();
            return value.toInternalCacheEntry(key);
        }
        String message = "Unknown response from remote cache: " + response;
        log.error(message);
        throw new CacheLoaderException(message);
    }

    @Override
    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return Collections.EMPTY_SET;
    }

    @Override
    public void start() throws CacheLoaderException {
    }

    @Override
    public void stop() throws CacheLoaderException {
    }

    @Override
    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        throw new IllegalStateException("TODO - please implement me!!!");
    }

    private List<Response> doRemoteCall(ClusteredGetCommand clusteredGetCommand) throws CacheLoaderException {
        HashSet<Address> validMembers = new HashSet<Address>(this.rpcManager.getTransport().getMembers());
        validMembers.remove(this.rpcManager.getTransport().getAddress());
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(validMembers);
        try {
            return this.rpcManager.invokeRemotely(null, clusteredGetCommand, ResponseMode.WAIT_FOR_VALID_RESPONSE, this.config.getRemoteCallTimeout(), false, filter);
        }
        catch (Exception e) {
            log.error((Object)"error while doing remote call", e);
            throw new CacheLoaderException(e);
        }
    }

    private boolean isLocalCall() {
        InvocationContext invocationContext = this.cache.getInvocationContextContainer().getInvocationContext();
        return invocationContext.isOriginLocal();
    }

    protected boolean isCacheReady() {
        return this.cache.getStatus() == ComponentStatus.RUNNING;
    }
}

