/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.Externalizer;

public class ReplicableCommandExternalizer
implements Externalizer {
    private RemoteCommandsFactory cmdFactory;

    public void inject(RemoteCommandsFactory cmdFactory) {
        this.cmdFactory = cmdFactory;
    }

    @Override
    public void writeObject(ObjectOutput output, Object subject) throws IOException {
        ReplicableCommand command = (ReplicableCommand)subject;
        output.writeShort(command.getCommandId());
        Object[] args = command.getParameters();
        int numArgs = args == null ? 0 : args.length;
        UnsignedNumeric.writeUnsignedInt(output, numArgs);
        for (int i = 0; i < numArgs; ++i) {
            output.writeObject(args[i]);
        }
    }

    @Override
    public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        short methodId = input.readShort();
        int numArgs = UnsignedNumeric.readUnsignedInt(input);
        Object[] args = null;
        if (numArgs > 0) {
            args = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                args[i] = input.readObject();
            }
        }
        return this.cmdFactory.fromStream((byte)methodId, args);
    }
}

