/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.Readable;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SetQuery
implements QueryCommand {
    private static final long serialVersionUID = 1L;
    private final List<? extends Ordering> orderings;
    private final Limit limits;
    private final QueryCommand left;
    private final QueryCommand right;
    private final Operation operation;
    private final boolean all;
    private final int hc;

    protected static boolean unionableColumns(List<? extends Column> left, List<? extends Column> right) {
        if (left.size() != right.size()) {
            return false;
        }
        Iterator<? extends Column> leftIter = left.iterator();
        Iterator<? extends Column> rightIter = right.iterator();
        while (leftIter.hasNext() && rightIter.hasNext()) {
            Column leftColumn = leftIter.next();
            Column rightColumn = rightIter.next();
            if (leftColumn != null && rightColumn != null) continue;
            return false;
        }
        return leftIter.hasNext() == rightIter.hasNext();
    }

    public SetQuery(QueryCommand left, Operation operation, QueryCommand right, boolean all) {
        CheckArg.isNotNull((Object)left, (String)"left");
        CheckArg.isNotNull((Object)right, (String)"right");
        CheckArg.isNotNull((Object)operation, (String)"operation");
        if (!SetQuery.unionableColumns(left.columns(), right.columns())) {
            I18n msg = GraphI18n.leftAndRightQueriesInSetQueryMustHaveUnionableColumns;
            throw new IllegalArgumentException(msg.text(new Object[]{left.columns(), right.columns()}));
        }
        this.left = left;
        this.right = right;
        this.operation = operation;
        this.all = all;
        this.orderings = Collections.emptyList();
        this.limits = Limit.NONE;
        this.hc = HashCode.compute((Object[])new Object[]{this.left, this.right, this.operation});
    }

    public SetQuery(QueryCommand left, Operation operation, QueryCommand right, boolean all, List<? extends Ordering> orderings, Limit limit) {
        CheckArg.isNotNull((Object)left, (String)"left");
        CheckArg.isNotNull((Object)right, (String)"right");
        CheckArg.isNotNull((Object)operation, (String)"operation");
        if (!SetQuery.unionableColumns(left.columns(), right.columns())) {
            I18n msg = GraphI18n.leftAndRightQueriesInSetQueryMustHaveUnionableColumns;
            throw new IllegalArgumentException(msg.text(new Object[]{left.columns(), right.columns()}));
        }
        this.left = left;
        this.right = right;
        this.operation = operation;
        this.all = all;
        this.orderings = orderings != null ? orderings : Collections.emptyList();
        this.limits = limit != null ? limit : Limit.NONE;
        this.hc = HashCode.compute((Object[])new Object[]{this.left, this.right, this.operation});
    }

    @Override
    public List<? extends Column> columns() {
        return this.left.columns();
    }

    @Override
    public Limit limits() {
        return this.limits;
    }

    @Override
    public List<? extends Ordering> orderings() {
        return this.orderings;
    }

    public QueryCommand left() {
        return this.left;
    }

    public QueryCommand right() {
        return this.right;
    }

    public final Operation operation() {
        return this.operation;
    }

    public final boolean isAll() {
        return this.all;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SetQuery) {
            SetQuery that = (SetQuery)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (this.operation != that.operation) {
                return false;
            }
            if (!this.left.equals(that.left)) {
                return false;
            }
            if (!this.right.equals(that.right)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls((Object)this.limits(), (Object)that.limits())) {
                return false;
            }
            return ObjectUtil.isEqualWithNulls(this.orderings(), that.orderings());
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SetQuery withLimit(int rowLimit) {
        if (this.limits().rowLimit() == rowLimit) {
            return this;
        }
        return new SetQuery(this.left, this.operation, this.right, this.all, this.orderings(), this.limits().withRowLimit(rowLimit));
    }

    @Override
    public SetQuery withOffset(int offset) {
        if (this.limits().offset() == offset) {
            return this;
        }
        return new SetQuery(this.left, this.operation, this.right, this.all, this.orderings(), this.limits().withOffset(offset));
    }

    public SetQuery adding(Ordering ... orderings) {
        List<Ordering> newOrderings = null;
        if (this.orderings() != null) {
            newOrderings = new ArrayList<Ordering>(this.orderings());
            for (Ordering ordering : orderings) {
                newOrderings.add(ordering);
            }
        } else {
            newOrderings = Arrays.asList(orderings);
        }
        return new SetQuery(this.left, this.operation, this.right, this.all, newOrderings, this.limits());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation implements Readable
    {
        UNION("UNION"),
        INTERSECT("INTERSECT"),
        EXCEPT("EXCEPT");

        private static final Map<String, Operation> OPERATIONS_BY_SYMBOL;
        private final String symbol;

        private Operation(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String toString() {
            return this.symbol;
        }

        public static Operation forSymbol(String symbol) {
            CheckArg.isNotNull((Object)symbol, (String)"symbol");
            return OPERATIONS_BY_SYMBOL.get(symbol.toUpperCase());
        }

        @Override
        public String getString() {
            return this.getSymbol();
        }

        static {
            HashMap<String, Operation> opsBySymbol = new HashMap<String, Operation>();
            for (Operation op : Operation.values()) {
                opsBySymbol.put(op.getSymbol(), op);
            }
            OPERATIONS_BY_SYMBOL = Collections.unmodifiableMap(opsBySymbol);
        }
    }
}

