/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.util.LinkedList;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.util.Util;

public abstract class ChatCore
implements MessageListener,
MembershipListener {
    Channel channel;
    PullPushAdapter ad;
    Thread mainThread;
    static final String group_name = "ChatGroup";
    String props = null;
    String username = null;
    LinkedList history = new LinkedList();

    public ChatCore(String props) {
        this.props = props;
        try {
            this.username = System.getProperty("user.name");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    abstract void post(String var1);

    public void link() {
        try {
            this.channel = new JChannel(this.props);
            System.out.println("Connecting to ChatGroup");
            this.channel.connect(group_name);
            this.ad = new PullPushAdapter(this.channel, this, this);
            this.channel.getState(null, 5000L);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.post(e.toString());
        }
    }

    public void dumpHist() {
        if (!this.history.isEmpty()) {
            for (String s : this.history) {
                this.post(s + "\n");
                System.err.print(s + "\n");
            }
        }
    }

    @Override
    public void receive(Message msg) {
        try {
            String o = new String(msg.getBuffer());
            System.err.print(o + " [" + msg.getSrc() + "]\n");
            this.post(o + " [" + msg.getSrc() + "]\n");
            this.history.add(o);
        }
        catch (Exception e) {
            this.post("Chat.receive(): " + e);
            System.err.print("Chat.receive(): " + e);
        }
    }

    @Override
    public byte[] getState() {
        try {
            return Util.objectToByteBuffer(this.history);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setState(byte[] state) {
        try {
            this.history = (LinkedList)Util.objectFromByteBuffer(state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void viewAccepted(View new_view) {
        this.post("Received view " + new_view + '\n');
        System.err.print("Received view " + new_view + '\n');
    }

    @Override
    public void suspect(Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    public void stop() {
        System.out.print("Stopping PullPushAdapter");
        this.ad.stop();
        System.out.println(" -- done");
    }

    public void disconnect() {
        System.out.print("Disconnecting the channel");
        this.channel.disconnect();
        System.out.println(" -- done");
    }

    public void close() {
        System.out.print("Closing the channel");
        this.channel.close();
        System.out.println(" -- done");
    }

    protected synchronized void handleLeave() {
        try {
            this.stop();
            this.disconnect();
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.print("Failed leaving the group: " + e.toString() + '\n');
            this.post("Failed leaving the group: " + e.toString() + '\n');
        }
    }

    protected void handleSend(String txt) {
        String tmp = this.username + ": " + txt;
        try {
            Message msg = new Message(null, null, tmp.getBytes());
            this.channel.send(msg);
        }
        catch (Exception e) {
            System.err.print("Failed sending message: " + e.toString() + '\n');
            this.post("Failed sending message: " + e.toString() + '\n');
        }
    }
}

