/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Vector;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-independent", "broken"}, sequential=true)
public class EncryptMessageOrderTestCase {
    public static int MESSAGE_NUMBER = 500;
    public static boolean SLEEP_BETWEEN_SENDING = false;
    public static int SLEEP_TIME = 1;
    String groupName = "ENCRYPT_ORDER_TEST";
    boolean orderCounterFailure = false;
    public static final String properties = "EncryptNoKeyStore.xml";
    protected JChannel channel1;
    protected JChannel channel2;
    protected volatile boolean finishedReceiving;

    protected static void printSelectedOptions() {
        System.out.println("will sleep : " + SLEEP_BETWEEN_SENDING);
        if (SLEEP_BETWEEN_SENDING) {
            System.out.println("sleep time : " + SLEEP_TIME);
        }
        System.out.println("msg num : " + MESSAGE_NUMBER);
    }

    @BeforeClass
    static void init() {
        ClassConfigurator.add((short)24526, EncryptOrderTestHeader.class);
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        EncryptMessageOrderTestCase.printSelectedOptions();
        this.channel1 = new JChannel(properties);
        System.out.print("Connecting to channel...");
        this.channel1.connect(this.groupName);
        System.out.println("channel1 connected, view is " + this.channel1.getView());
        this.channel2 = new JChannel(properties);
        this.channel2.connect(this.groupName);
        System.out.println("channel2 connected, view is " + this.channel2.getView());
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        this.channel2.close();
        this.channel1.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoad() {
        try {
            Object message;
            String startMessage = "start";
            String stopMessage = "stop";
            final Object mutex = new Object();
            final Vector receivedTimes = new Vector(MESSAGE_NUMBER);
            final Vector normalMessages = new Vector(MESSAGE_NUMBER);
            final Vector tooQuickMessages = new Vector();
            final Vector tooSlowMessages = new Vector();
            this.channel1.setReceiver(new ReceiverAdapter(){
                private boolean started = false;
                private boolean stopped = false;
                private long counter = 0L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receive(Message jgMessage) {
                    Object message = jgMessage.getObject();
                    if ("start".equals(message)) {
                        this.started = true;
                        EncryptMessageOrderTestCase.this.finishedReceiving = false;
                    } else {
                        if ("stop".equals(message)) {
                            this.stopped = true;
                            EncryptMessageOrderTestCase.this.finishedReceiving = true;
                            Object object = mutex;
                            synchronized (object) {
                                mutex.notifyAll();
                            }
                        }
                        if (message instanceof Long) {
                            Long travelTime = new Long(System.currentTimeMillis() - (Long)message);
                            try {
                                Assert.assertEquals((long)this.counter, (long)((EncryptOrderTestHeader)jgMessage.getHeader((String)"EncryptOrderTest")).seqno);
                                ++this.counter;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                EncryptMessageOrderTestCase.this.orderCounterFailure = true;
                            }
                            if (!this.started) {
                                tooQuickMessages.add(message);
                            } else if (!this.stopped) {
                                receivedTimes.add(travelTime);
                                normalMessages.add(message);
                            } else {
                                tooSlowMessages.add(message);
                            }
                        }
                    }
                }
            });
            System.out.println("Free memory: " + Runtime.getRuntime().freeMemory());
            System.out.println("Total memory: " + Runtime.getRuntime().totalMemory());
            System.out.println("Starting sending messages.");
            long time = System.currentTimeMillis();
            Message startJgMessage = new Message();
            startJgMessage.setObject((Serializable)((Object)"start"));
            JChannel sender = this.channel2;
            sender.send(startJgMessage);
            for (int i = 0; i < MESSAGE_NUMBER; ++i) {
                message = new Long(System.currentTimeMillis());
                Message jgMessage = new Message();
                jgMessage.putHeader("EncryptOrderTest", new EncryptOrderTestHeader(i));
                jgMessage.setObject((Serializable)message);
                sender.send(jgMessage);
                if (i % 1000 == 0) {
                    System.out.println("sent " + i + " messages.");
                }
                if (!SLEEP_BETWEEN_SENDING) continue;
                Util.sleep(1L, true);
            }
            Message stopJgMessage = new Message();
            stopJgMessage.setObject((Serializable)((Object)"stop"));
            sender.send(stopJgMessage);
            time = System.currentTimeMillis() - time;
            System.out.println("Finished sending messages. Operation took " + time);
            message = mutex;
            synchronized (message) {
                int received = 0;
                while (!this.finishedReceiving) {
                    mutex.wait(1000L);
                    if (receivedTimes.size() != received) {
                        received = receivedTimes.size();
                        System.out.println();
                        System.out.print("Received " + receivedTimes.size() + " messages.");
                        continue;
                    }
                    System.out.print(".");
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            double avgDeliveryTime = -1.0;
            long maxDeliveryTime = Long.MIN_VALUE;
            long minDeliveryTime = Long.MAX_VALUE;
            for (Long message2 : receivedTimes) {
                avgDeliveryTime = avgDeliveryTime == -1.0 ? (double)message2.longValue() : (avgDeliveryTime + message2.doubleValue()) / 2.0;
                if (message2 > maxDeliveryTime) {
                    maxDeliveryTime = message2;
                }
                if (message2 >= minDeliveryTime) continue;
                minDeliveryTime = message2;
            }
            System.out.println("Sent " + MESSAGE_NUMBER + " messages.");
            System.out.println("Received " + receivedTimes.size() + " messages.");
            System.out.println("Average delivery time " + avgDeliveryTime + " ms");
            System.out.println("Minimum delivery time " + minDeliveryTime + " ms");
            System.out.println("Maximum delivery time " + maxDeliveryTime + " ms");
            System.out.println("Received " + tooQuickMessages.size() + " too quick messages");
            System.out.println("Received " + tooSlowMessages.size() + " too slow messages");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("Free memory: " + Runtime.getRuntime().freeMemory());
        System.out.println("Total memory: " + Runtime.getRuntime().totalMemory());
        System.out.println("Performing GC");
        Runtime.getRuntime().gc();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Free memory: " + Runtime.getRuntime().freeMemory());
        System.out.println("Total memory: " + Runtime.getRuntime().totalMemory());
        assert (!this.orderCounterFailure) : "Message ordering is incorrect - check log output";
    }

    static void help() {
        System.out.println("EncryptOrderTest [-help] [-sleep <sleep time between sends (ms)>]  [-msg_num <number of msgs to send>]");
    }

    public static class EncryptOrderTestHeader
    extends Header {
        long seqno = -1L;
        private static final long serialVersionUID = -7995117434876250849L;

        public EncryptOrderTestHeader() {
        }

        public EncryptOrderTestHeader(long seqno) {
            this.seqno = seqno;
        }

        @Override
        public int size() {
            return 512;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.seqno);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.seqno = in.readLong();
        }

        public EncryptOrderTestHeader copy() {
            return new EncryptOrderTestHeader(this.seqno);
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append("[ENCRYPT_ORDER_TEST: seqno=" + this.seqno);
            ret.append(']');
            return ret.toString();
        }
    }
}

