/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FragHeader;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.TpHeader;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.VERIFY_SUSPECT;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExposedByteArrayOutputStream;

public class MessageSerializationTest2 {
    Message msg;
    Buffer buf;
    long start;
    long stop;
    long total;
    double msgs_per_sec;
    double time_per_msg;
    List<Message> my_list = new LinkedList<Message>();
    int num = 50000;
    ObjectOutputStream out;
    ExposedByteArrayOutputStream output;
    ByteArrayInputStream input;
    ObjectInputStream in;
    DataOutputStream dos;
    DataInputStream dis;
    int msgs_read = 0;
    List<Message> l2 = new LinkedList<Message>();

    public void start(int num, boolean use_additional_data, boolean add_headers) throws Exception {
        IpAddress dest = new IpAddress("228.8.8.8", 7500);
        IpAddress src = new IpAddress("127.0.0.1", 5555);
        if (use_additional_data) {
            src.setAdditionalData("bela".getBytes());
        }
        this.num = num;
        System.out.println("-- starting to create " + num + " msgs");
        this.start = System.currentTimeMillis();
        for (int i = 1; i <= num; ++i) {
            this.msg = new Message((Address)dest, (Address)src, ("Hello world from message #" + i).getBytes());
            if (add_headers) {
                MessageSerializationTest2.addHeaders(this.msg);
            }
            this.my_list.add(this.msg);
        }
        this.stop = System.currentTimeMillis();
        this.total = this.stop - this.start;
        this.msgs_per_sec = (double)num / ((double)this.total / 1000.0);
        this.time_per_msg = (double)this.total / (double)num;
        System.out.println("\n-- total time for creating " + num + " msgs = " + this.total + "ms \n(" + this.msgs_per_sec + " msgs/sec, time_per_msg=" + this.time_per_msg + " ms)");
        Object l_ser = null;
        LinkedList<Long> l_stream = null;
        l_stream = this.marshalMessages();
    }

    static void addHeaders(Message msg) {
        msg.putHeader("UDP", new TpHeader("MyGroup"));
        msg.putHeader("PING", new PingHeader(1, "bla"));
        msg.putHeader("FD_SOCK", new FD_SOCK.FdHeader());
        msg.putHeader("VERIFY_SUSPECT", new VERIFY_SUSPECT.VerifyHeader());
        msg.putHeader("STABLE", new STABLE.StableHeader());
        msg.putHeader("NAKACK", new NakAckHeader());
        msg.putHeader("UNICAST", new UNICAST.UnicastHeader());
        msg.putHeader("FRAG", new FragHeader());
        msg.putHeader("GMS", new GMS.GmsHeader());
    }

    private static void printDiffs(List<Long> l_ser, List<Long> l_stream) {
        long size_ser = l_ser.get(0);
        long size_stream = l_stream.get(0);
        long write_ser = l_ser.get(1);
        long read_ser = l_ser.get(2);
        long write_stream = l_stream.get(1);
        long read_stream = l_stream.get(2);
        System.out.println("\n\nserialized size=" + size_ser + ", streamable size=" + size_stream + ", streamable is " + (100.0 / (double)size_stream * (double)size_ser - 100.0) + " percent smaller");
        System.out.println("serialized write=" + write_ser + ", streamable write=" + write_stream + ", streamable write is " + (100.0 / (double)write_stream * (double)write_ser - 100.0) + " percent faster");
        System.out.println("serialized read=" + read_ser + ", streamable read=" + read_stream + ", streamable read is " + (100.0 / (double)read_stream * (double)read_ser - 100.0) + " percent faster");
    }

    LinkedList<Long> marshalMessages() throws IOException, IllegalAccessException, InstantiationException {
        LinkedList<Long> retval = new LinkedList<Long>();
        System.out.println("\n\n-- starting to marshal " + this.num + " msgs (using Streamable)");
        this.start = System.currentTimeMillis();
        this.output = new ExposedByteArrayOutputStream(65000);
        this.dos = new DataOutputStream(this.output);
        this.dos.writeInt(this.my_list.size());
        for (Message tmp : this.my_list) {
            tmp.writeTo(this.dos);
        }
        this.dos.close();
        this.stop = System.currentTimeMillis();
        this.buf = new Buffer(this.output.getRawBuffer(), 0, this.output.size());
        System.out.println("** marshalled buffer size=" + this.buf.getLength() + " bytes");
        retval.add(new Long(this.buf.getLength()));
        this.total = this.stop - this.start;
        retval.add(new Long(this.total));
        this.msgs_per_sec = (double)this.num / ((double)this.total / 1000.0);
        this.time_per_msg = (double)this.total / (double)this.num;
        System.out.println("\n-- total time for marshaling " + this.num + " msgs = " + this.total + "ms \n(" + this.msgs_per_sec + " msgs/sec, time_per_msg=" + this.time_per_msg + " ms)");
        System.out.println("-- starting to unmarshal msgs (using Streamable)");
        this.start = System.currentTimeMillis();
        this.input = new ByteArrayInputStream(this.buf.getBuf(), this.buf.getOffset(), this.buf.getLength());
        this.dis = new DataInputStream(this.input);
        this.msgs_read = 0;
        int b = this.dis.readInt();
        for (int i = 0; i < b; ++i) {
            Message tmp;
            tmp = new Message(false);
            tmp.readFrom(this.dis);
            this.l2.add(tmp);
        }
        this.stop = System.currentTimeMillis();
        this.total = this.stop - this.start;
        retval.add(new Long(this.total));
        this.msgs_read = this.l2.size();
        this.msgs_per_sec = (double)this.msgs_read / ((double)this.total / 1000.0);
        this.time_per_msg = (double)this.total / (double)this.msgs_read;
        System.out.println("\n-- total time for reading " + this.msgs_read + " msgs = " + this.total + "ms \n(" + this.msgs_per_sec + " msgs/sec, time_per_msg=" + this.time_per_msg + ')');
        return retval;
    }

    public static void main(String[] args) {
        int num = 50000;
        boolean use_additional_data = false;
        boolean add_headers = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-num")) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-use_additional_data")) {
                use_additional_data = Boolean.parseBoolean(args[++i]);
                continue;
            }
            if (args[i].equals("-add_headers")) {
                add_headers = Boolean.parseBoolean(args[++i]);
                continue;
            }
            MessageSerializationTest2.help();
            return;
        }
        try {
            new MessageSerializationTest2().start(num, use_additional_data, add_headers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void help() {
        System.out.println("MessageSerializationTest2 [-help] [-num <number>] [-use_additional_data <true|false>] [-add_headers <true|false>]");
    }
}

