/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.stack.GossipRouter;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Promise;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"stack-independent", "gossip-router"}, sequential=true)
public class TUNNELDeadLockTest
extends ChannelTestBase {
    private JChannel channel;
    private Promise<Boolean> promise;
    private int receivedCnt;
    private int msgCount = 20000;
    private int payloadSize = 32;
    private int mainTimeout = 60000;
    GossipRouter gossipRouter;

    @BeforeMethod
    void setUp() throws Exception {
        String bind_addr = Util.getProperty("jgroups.bind_addr");
        if (bind_addr == null) {
            StackType type = Util.getIpStackType();
            bind_addr = type == StackType.IPv6 ? "::1" : "127.0.0.1";
        }
        this.promise = new Promise();
        this.gossipRouter = new GossipRouter(12001, bind_addr);
        this.gossipRouter.start();
    }

    @AfterMethod(alwaysRun=true)
    void tearDown() throws Exception {
        this.channel.close();
        this.promise.reset();
        this.promise = null;
        this.gossipRouter.stop();
        System.out.println("Router stopped");
    }

    @Test
    public void testStress() throws Exception {
        this.channel = new JChannel("tunnel.xml");
        this.channel.connect("agroup");
        this.channel.setReceiver(new ReceiverAdapter(){

            @Override
            public void receive(Message msg) {
                TUNNELDeadLockTest.this.receivedCnt++;
                if (TUNNELDeadLockTest.this.receivedCnt % 2000 == 0) {
                    System.out.println("-- received " + TUNNELDeadLockTest.this.receivedCnt);
                }
                if (TUNNELDeadLockTest.this.receivedCnt == TUNNELDeadLockTest.this.msgCount) {
                    TUNNELDeadLockTest.this.promise.setResult(Boolean.TRUE);
                }
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < TUNNELDeadLockTest.this.msgCount; ++i) {
                        TUNNELDeadLockTest.this.channel.send(null, null, (Serializable)new byte[TUNNELDeadLockTest.this.payloadSize]);
                        if (i % 2000 != 0) continue;
                        System.out.println("-- sent " + i);
                    }
                }
                catch (Exception e) {
                    System.err.println("Error sending data over ...");
                    e.printStackTrace();
                }
            }
        }).start();
        Boolean result = this.promise.getResult(this.mainTimeout);
        if (result == null) {
            String msg = "The channel has failed to send/receive " + this.msgCount + " messages " + "possibly because of the channel deadlock or too short " + "timeout (currently " + this.mainTimeout + " ms). " + this.receivedCnt + " messages received so far.";
            assert (false) : msg;
        }
    }
}

