/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.marshalling.reflect.SerializableField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializableClass {
    private final WeakReference<Class<?>> subjectRef;
    private final LazyWeakMethodRef writeObject;
    private final LazyWeakMethodRef writeReplace;
    private final LazyWeakMethodRef readObject;
    private final LazyWeakMethodRef readObjectNoData;
    private final LazyWeakMethodRef readResolve;
    private final SerializableField[] fields;
    private final long effectiveSerialVersionUID;
    private static final Comparator<? super SerializableField> NAME_COMPARATOR = new Comparator<SerializableField>(){

        @Override
        public int compare(SerializableField o1, SerializableField o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final SerializableField[] NOFIELDS = new SerializableField[0];

    SerializableClass(Class<?> subject) {
        WeakReference subjectRef = new WeakReference(subject);
        this.subjectRef = subjectRef;
        this.writeObject = LazyWeakMethodRef.getInstance(new MethodFinder(){

            @Override
            public Method get(Class<?> clazz) {
                return SerializableClass.lookupPrivateMethod(clazz, "writeObject", new Class[]{ObjectOutputStream.class});
            }
        }, subjectRef);
        this.readObject = LazyWeakMethodRef.getInstance(new MethodFinder(){

            @Override
            public Method get(Class<?> clazz) {
                return SerializableClass.lookupPrivateMethod(clazz, "readObject", new Class[]{ObjectInputStream.class});
            }
        }, subjectRef);
        this.readObjectNoData = LazyWeakMethodRef.getInstance(new MethodFinder(){

            @Override
            public Method get(Class<?> clazz) {
                return SerializableClass.lookupPrivateMethod(clazz, "readObjectNoData", new Class[0]);
            }
        }, subjectRef);
        this.writeReplace = LazyWeakMethodRef.getInstance(new MethodFinder(){

            @Override
            public Method get(Class<?> clazz) {
                return SerializableClass.lookupInheritableMethod(clazz, "writeReplace");
            }
        }, subjectRef);
        this.readResolve = LazyWeakMethodRef.getInstance(new MethodFinder(){

            @Override
            public Method get(Class<?> clazz) {
                return SerializableClass.lookupInheritableMethod(clazz, "readResolve");
            }
        }, subjectRef);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(subject);
        this.effectiveSerialVersionUID = objectStreamClass == null ? 0L : objectStreamClass.getSerialVersionUID();
        this.fields = SerializableClass.getSerializableFields(subject);
    }

    private static SerializableField[] getSerializableFields(Class<?> clazz) {
        ObjectStreamField[] objectStreamFields = SerializableClass.getDeclaredSerialPersistentFields(clazz);
        if (objectStreamFields != null) {
            SerializableField[] fields = new SerializableField[objectStreamFields.length];
            for (int i = 0; i < objectStreamFields.length; ++i) {
                ObjectStreamField field = objectStreamFields[i];
                fields[i] = new SerializableField(clazz, field.getType(), field.getName(), field.isUnshared());
            }
            Arrays.sort(fields, NAME_COMPARATOR);
            return fields;
        }
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList<SerializableField> fields = new ArrayList<SerializableField>(declaredFields.length);
        for (Field field : declaredFields) {
            if ((field.getModifiers() & 0x88) != 0) continue;
            fields.add(new SerializableField(clazz, field.getType(), field.getName(), false));
        }
        Collections.sort(fields, NAME_COMPARATOR);
        return fields.toArray(new SerializableField[fields.size()]);
    }

    private static ObjectStreamField[] getDeclaredSerialPersistentFields(Class<?> clazz) {
        Field field;
        try {
            field = clazz.getDeclaredField("serialPersistentFields");
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        if (field == null) {
            return null;
        }
        int requiredModifiers = 26;
        if ((field.getModifiers() & 0x1A) != 26) {
            return null;
        }
        field.setAccessible(true);
        try {
            return (ObjectStreamField[])field.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public SerializableField[] getFields() {
        return this.fields;
    }

    public SerializableField getSerializableField(String name, Class<?> fieldType, boolean unshared) throws ClassNotFoundException {
        return new SerializableField(this.getSubjectClass(), fieldType, name, unshared);
    }

    public boolean hasWriteObject() {
        return this.writeObject != null;
    }

    public void callWriteObject(Object object, ObjectOutputStream outputStream) throws IOException {
        try {
            this.writeObject.getMethod().invoke(object, outputStream);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof IOException) {
                throw (IOException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class is unexpectedly missing or changed");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasReadObject() {
        return this.readObject != null;
    }

    public void callReadObject(Object object, ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        try {
            this.readObject.getMethod().invoke(object, inputStream);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof IOException) {
                throw (IOException)te;
            }
            if (te instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class is unexpectedly missing or changed");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasReadObjectNoData() {
        return this.readObjectNoData != null;
    }

    public void callReadObjectNoData(Object object) throws ObjectStreamException {
        try {
            this.readObjectNoData.getMethod().invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof ObjectStreamException) {
                throw (ObjectStreamException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class is unexpectedly missing or changed");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasWriteReplace() {
        return this.writeReplace != null;
    }

    public Object callWriteReplace(Object object) throws ObjectStreamException {
        try {
            return this.writeReplace.getMethod().invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof ObjectStreamException) {
                throw (ObjectStreamException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class is unexpectedly missing or changed");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasReadResolve() {
        return this.readResolve != null;
    }

    public Object callReadResolve(Object object) throws ObjectStreamException {
        try {
            return this.readResolve.getMethod().invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof ObjectStreamException) {
                throw (ObjectStreamException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class is unexpectedly missing or changed");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public long getEffectiveSerialVersionUID() {
        return this.effectiveSerialVersionUID;
    }

    public Class<?> getSubjectClass() throws ClassNotFoundException {
        return SerializableClass.dereference(this.subjectRef);
    }

    private static Method lookupPrivateMethod(final Class<?> subject, final String name, final Class<?> ... params) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    Method method = subject.getDeclaredMethod(name, params);
                    int modifiers = method.getModifiers();
                    if ((modifiers & 2) == 0) {
                        return null;
                    }
                    if ((modifiers & 8) != 0) {
                        return null;
                    }
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
    }

    private static Method lookupInheritableMethod(final Class<?> subject, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                Class foundClass = subject;
                Method method = null;
                while (method == null) {
                    try {
                        if (foundClass == null) {
                            return null;
                        }
                        method = foundClass.getDeclaredMethod(name, new Class[0]);
                        if (method != null) continue;
                        foundClass = foundClass.getSuperclass();
                    }
                    catch (NoSuchMethodException e) {
                        foundClass = foundClass.getSuperclass();
                    }
                }
                int modifiers = method.getModifiers();
                if ((modifiers & 8) != 0) {
                    return null;
                }
                if ((modifiers & 0x400) != 0) {
                    return null;
                }
                if ((modifiers & 2) != 0 && foundClass != subject) {
                    return null;
                }
                if ((modifiers & 5) != 0 || SerializableClass.isSamePackage(foundClass, subject)) {
                    method.setAccessible(true);
                    return method;
                }
                return null;
            }
        });
    }

    private static boolean isSamePackage(Class<?> a, Class<?> b) {
        return a.getClassLoader() == b.getClassLoader() && SerializableClass.getPackageName(a).equals(SerializableClass.getPackageName(b));
    }

    private static String getPackageName(Class<?> c) {
        String name = c.getName();
        int idx = name.lastIndexOf(91);
        if (idx > -1) {
            name = name.substring(idx + 2);
        }
        if ((idx = name.lastIndexOf(46)) > -1) {
            name = name.substring(0, idx);
            return name;
        }
        return "";
    }

    static Class<?> dereference(WeakReference<Class<?>> classRef) throws ClassNotFoundException {
        Class clazz = (Class)classRef.get();
        if (clazz == null) {
            throw new ClassNotFoundException("Class was unloaded");
        }
        return clazz;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyWeakMethodRef {
        private final AtomicReference<WeakReference<Method>> ref;
        private final MethodFinder finder;
        private final WeakReference<Class<?>> classRef;

        private LazyWeakMethodRef(MethodFinder finder, Method initial, WeakReference<Class<?>> classRef) {
            this.finder = finder;
            this.classRef = classRef;
            this.ref = new AtomicReference<WeakReference<Method>>(new WeakReference<Method>(initial));
        }

        private static LazyWeakMethodRef getInstance(MethodFinder finder, WeakReference<Class<?>> classRef) {
            Class clazz = (Class)classRef.get();
            if (clazz == null) {
                throw new NullPointerException("clazz is null (no strong reference held to class when serialization info was acquired");
            }
            Method method = finder.get(clazz);
            if (method == null) {
                return null;
            }
            return new LazyWeakMethodRef(finder, method, classRef);
        }

        private Method getMethod() throws ClassNotFoundException {
            Method method;
            WeakReference<Method> weakReference = this.ref.get();
            if (weakReference != null && (method = (Method)weakReference.get()) != null) {
                return method;
            }
            Class<?> clazz = SerializableClass.dereference(this.classRef);
            Method method2 = this.finder.get(clazz);
            if (method2 == null) {
                throw new NullPointerException("method is null (was non-null on last check)");
            }
            WeakReference<Method> newVal = new WeakReference<Method>(method2);
            this.ref.compareAndSet(weakReference, newVal);
            return method2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MethodFinder {
        public Method get(Class<?> var1);
    }
}

