/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.common;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.hibernate.annotations.Index;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.basic.JodaDateTime;

@Deprecated
@Entity
@Table(name="DNA_CHANGELOG")
@org.hibernate.annotations.Table(appliesTo="DNA_CHANGELOG", indexes={@Index(name="NS_CHANGE_TS_INX", columnNames={"TIMESTAMP_IN_UTC"})})
@NamedQueries(value={@NamedQuery(name="ChangeLogEntity.findBetween", query="select entry from ChangeLogEntity as entry where entry.timestampInUtc >= :start and entry.timestampInUtc <= :end"), @NamedQuery(name="ChangeLogEntity.deleteBefore", query="delete ChangeLogEntity entry where entry.timestampInUtc < :timestamp")})
public class ChangeLogEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", updatable=false)
    private Long id;
    @Column(name="USERNAME", updatable=false, nullable=false, length=64, unique=false)
    private String username;
    @Column(name="TIMESTAMP_IN_UTC", updatable=false, nullable=false, unique=false)
    private long timestampInUtc;
    @Column(name="CHANGE_COUNT", updatable=false, nullable=false, unique=false)
    private int numChanges;
    @Lob
    @Column(name="CHANGES", updatable=false, nullable=false, unique=false)
    private byte[] changes;

    public ChangeLogEntity(String username, DateTime timestamp, int numChanges, byte[] changes) {
        this.username = username;
        this.timestampInUtc = timestamp.toUtcTimeZone().getMilliseconds();
        this.numChanges = numChanges;
        this.changes = changes;
    }

    public Long getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public long getTimestampInUtc() {
        return this.timestampInUtc;
    }

    public byte[] getChanges() {
        return this.changes;
    }

    public int getNumChanges() {
        return this.numChanges;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChangeLogEntity) {
            ChangeLogEntity that = (ChangeLogEntity)obj;
            return this.id.equals(that.id);
        }
        return false;
    }

    public String toString() {
        return "" + this.numChanges + " changes by " + this.username + " at " + new JodaDateTime(this.timestampInUtc);
    }
}

