/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.query.model.Readable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Order implements Readable
{
    ASCENDING("ASC"),
    DESCENDING("DESC");

    private final String symbol;

    private Order(String symbol) {
        this.symbol = symbol;
    }

    public String symbol() {
        return this.symbol;
    }

    public String toString() {
        return this.symbol;
    }

    public static Order forSymbol(String symbol) {
        CheckArg.isNotNull((Object)symbol, (String)"symbol");
        if (ASCENDING.symbol().equalsIgnoreCase(symbol)) {
            return ASCENDING;
        }
        if (DESCENDING.symbol().equalsIgnoreCase(symbol)) {
            return DESCENDING;
        }
        return null;
    }

    @Override
    public String getString() {
        return this.symbol();
    }
}

