/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.process.ProcessingComponent;
import org.modeshape.graph.query.process.SortLocationsComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SetOperationComponent
extends ProcessingComponent {
    private final Iterable<ProcessingComponent> sources;
    protected final Comparator<Object[]> removeDuplicatesComparator;

    protected SetOperationComponent(QueryContext context, QueryResults.Columns columns, Iterable<ProcessingComponent> sources, boolean alreadySorted, boolean all) {
        super(context, columns);
        assert (SetOperationComponent.unionCompatible(columns, sources));
        this.sources = SetOperationComponent.wrapWithLocationOrdering(sources, alreadySorted);
        this.removeDuplicatesComparator = all ? null : this.createSortComparator(context, columns);
    }

    protected static boolean unionCompatible(QueryResults.Columns columns, Iterable<ProcessingComponent> sources) {
        for (ProcessingComponent source : sources) {
            if (columns.isUnionCompatible(source.getColumns())) continue;
            return false;
        }
        return true;
    }

    protected Iterable<ProcessingComponent> sources() {
        return this.sources;
    }

    protected static Iterable<ProcessingComponent> wrapWithLocationOrdering(Iterable<ProcessingComponent> sources, boolean alreadySorted) {
        assert (sources != null);
        if (alreadySorted) {
            return sources;
        }
        LinkedList<ProcessingComponent> wrapped = new LinkedList<ProcessingComponent>();
        for (ProcessingComponent source : sources) {
            wrapped.add(new SortLocationsComponent(source));
        }
        return wrapped;
    }

    protected void removeDuplicatesIfRequested(List<Object[]> tuples) {
        if (this.removeDuplicatesComparator != null) {
            Iterator<Object[]> iter = tuples.iterator();
            Object[] previous = null;
            while (iter.hasNext()) {
                Object[] current = iter.next();
                if (previous != null && this.removeDuplicatesComparator.compare(previous, current) == 0) {
                    iter.remove();
                    continue;
                }
                previous = current;
            }
        }
    }
}

