/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.file;

import org.modeshape.common.logging.Logger;
import org.modeshape.persistence.file.FileDb;
import org.modeshape.schematic.SchematicDbProvider;
import org.modeshape.schematic.document.Document;

public class FileDbProvider
implements SchematicDbProvider<FileDb> {
    public static final String TYPE_MEM = "mem";
    public static final String TYPE_FILE = "file";
    public static final String PATH_FIELD = "path";
    public static final String COMPRESS_FIELD = "compress";
    private static final Logger LOGGER = Logger.getLogger(FileDbProvider.class);

    public FileDb getDB(String type, Document configuration) {
        if (TYPE_MEM.equalsIgnoreCase(type)) {
            LOGGER.debug("Returning new in-memory schematic DB...", new Object[0]);
            return FileDb.inMemory(configuration.getBoolean(COMPRESS_FIELD, false));
        }
        if (TYPE_FILE.equalsIgnoreCase(type)) {
            boolean compress = configuration.getBoolean(COMPRESS_FIELD, true);
            String path = configuration.getString(PATH_FIELD, null);
            LOGGER.debug("Returning new disk schematic DB at {0}...", new Object[]{path});
            return FileDb.onDisk(compress, path);
        }
        return null;
    }
}

