/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.relational;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.persistence.relational.RelationalDbConfig;
import org.modeshape.persistence.relational.RelationalProviderException;
import org.modeshape.persistence.relational.Statements;
import org.modeshape.schematic.document.Bson;
import org.modeshape.schematic.document.Document;

public class DefaultStatements
implements Statements {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private final Map<String, String> statements;
    private final RelationalDbConfig config;

    protected DefaultStatements(RelationalDbConfig config, Map<String, String> statements) {
        this.statements = statements;
        this.config = config;
    }

    @Override
    public Void createTable(Connection connection) throws SQLException {
        this.logTableInfo("Creating table {0}...");
        try (PreparedStatement createStmt = connection.prepareStatement(this.statements.get("create_table"));){
            if (createStmt.executeUpdate() > 0) {
                this.logTableInfo("Table {0} created");
            } else {
                this.logTableInfo("Table {0} already exists");
            }
        }
        return null;
    }

    @Override
    public Void dropTable(Connection connection) throws SQLException {
        this.logTableInfo("Dropping table {0}...");
        try (PreparedStatement createStmt = connection.prepareStatement(this.statements.get("delete_table"));){
            if (createStmt.executeUpdate() > 0) {
                this.logTableInfo("Table {0} dropped");
            } else {
                this.logTableInfo("Table {0} does not exist");
            }
        }
        return null;
    }

    @Override
    public List<String> getAllIds(Connection connection) throws SQLException {
        this.logTableInfo("Returning all ids from {0}");
        try (PreparedStatement ps = connection.prepareStatement(this.statements.get("get_all_ids"));){
            ArrayList<String> result = new ArrayList<String>();
            ps.setFetchSize(this.config.fetchSize());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Document getById(Connection connection, String id) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <R> List<R> load(Connection connection, List<String> ids, Function<Document, R> parser) throws SQLException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loading ids {0} from {1}", new Object[]{ids.toString(), this.tableName()});
        }
        String getMultipleStatement = this.statements.get("get_multiple");
        int batchLoadSize = this.batchLoadSize();
        ArrayList results = new ArrayList();
        this.runBatchOperation(connection, getMultipleStatement, ids, batchLoadSize, (dbConnection, statement, startIdx1, endIdx1, data) -> results.addAll(this.loadIDs(dbConnection, statement, startIdx1, endIdx1, ids, parser)));
        return results;
    }

    /*
     * Exception decompiling
     */
    private <R> List<R> loadIDs(Connection connection, String statement, int startIdx, int endIdx, List<String> ids, Function<Document, R> parser) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public DefaultBatchUpdate batchUpdate(Connection connection) {
        return new DefaultBatchUpdate(connection);
    }

    @Override
    public boolean exists(Connection connection, String id) throws SQLException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Checking if the content with ID {0} exists in {1}", new Object[]{id, this.tableName()});
        }
        try (PreparedStatement ps = connection.prepareStatement(this.statements.get("content_exists"));){
            ps.setString(1, id);
            ResultSet rs = ps.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
    }

    @Override
    public Void removeAll(Connection connection) throws SQLException {
        this.logTableInfo("Removing all content from {0}");
        try (PreparedStatement ps = connection.prepareStatement(this.statements.get("remove_all_content"));){
            ps.executeUpdate();
        }
        return null;
    }

    protected int batchLoadSize() {
        return 500;
    }

    protected void logTableInfo(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message, new Object[]{this.tableName()});
        }
    }

    protected String tableName() {
        return this.config.tableName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Document readDocument(InputStream is) {
        try (InputStream contentStream = this.config.compress() ? new GZIPInputStream(is) : is;){
            Document document = Bson.read((InputStream)contentStream);
            return document;
        }
        catch (IOException e) {
            throw new RelationalProviderException(e);
        }
    }

    protected byte[] writeDocument(Document content) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (OutputStream out = this.config.compress() ? new GZIPOutputStream(bos) : bos;){
                Bson.write((Document)content, (OutputStream)out);
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RelationalProviderException(e);
        }
    }

    private <T> void runBatchOperation(Connection connection, String statement, List<T> data, int batchSize, BatchOperation<T> operation) throws SQLException {
        if (data.isEmpty()) {
            return;
        }
        int dataSize = data.size();
        if (dataSize <= batchSize) {
            operation.run(connection, statement, 0, dataSize, data);
            return;
        }
        int startIdx = 0;
        while (startIdx < dataSize) {
            int endIdx = startIdx + batchSize > dataSize ? dataSize : startIdx + batchSize;
            operation.run(connection, statement, startIdx, endIdx, data);
            startIdx = endIdx;
        }
    }

    private static /* synthetic */ String lambda$loadIDs$1(String id) {
        return "?";
    }

    @NotThreadSafe
    protected class DefaultBatchUpdate
    implements Statements.BatchUpdate {
        private final Connection connection;

        protected DefaultBatchUpdate(Connection connection) {
            this.connection = connection;
        }

        @Override
        public void insert(Map<String, Document> documentsById) throws SQLException {
            String sql = (String)DefaultStatements.this.statements.get("insert_content");
            PreparedStatement insert = this.connection.prepareStatement(sql);
            documentsById.forEach((id, document) -> {
                if (DefaultStatements.this.logger.isDebugEnabled()) {
                    DefaultStatements.this.logger.debug("adding batch statement: {0}", new Object[]{sql.replaceFirst("\\?", (String)id)});
                }
                this.insertDocument(insert, (String)id, (Document)document);
            });
            insert.executeBatch();
        }

        protected void insertDocument(PreparedStatement statement, String id, Document document) {
            try {
                statement.setString(1, id);
                byte[] content = DefaultStatements.this.writeDocument(document);
                statement.setBytes(2, content);
                statement.addBatch();
            }
            catch (SQLException e) {
                throw new RelationalProviderException(e);
            }
        }

        @Override
        public void update(Map<String, Document> documentsById) throws SQLException {
            String sql = (String)DefaultStatements.this.statements.get("update_content");
            PreparedStatement update = this.connection.prepareStatement(sql);
            documentsById.forEach((id, document) -> {
                if (DefaultStatements.this.logger.isDebugEnabled()) {
                    DefaultStatements.this.logger.debug("adding batch statement: {0}", new Object[]{sql.replaceFirst(" ID.*=.*\\?", " ID = " + id)});
                }
                this.updateDocument(update, (String)id, (Document)document);
            });
            update.executeBatch();
        }

        protected void updateDocument(PreparedStatement statement, String id, Document document) {
            try {
                byte[] content = DefaultStatements.this.writeDocument(document);
                statement.setBytes(1, content);
                statement.setString(2, id);
                statement.addBatch();
            }
            catch (SQLException e) {
                throw new RelationalProviderException(e);
            }
        }

        @Override
        public void remove(List<String> ids) throws SQLException {
            String sql = (String)DefaultStatements.this.statements.get("remove_content");
            DefaultStatements.this.runBatchOperation(this.connection, sql, ids, DefaultStatements.this.batchLoadSize(), this::batchRemove);
        }

        private void batchRemove(Connection connection, String statement, int startIdx, int endIdx, List<String> ids) throws SQLException {
            List<String> sublist = ids.subList(startIdx, endIdx);
            String params = sublist.stream().map(id -> "?").collect(Collectors.joining(","));
            String statementString = statement.replaceAll("#", params);
            if (DefaultStatements.this.logger.isDebugEnabled()) {
                DefaultStatements.this.logger.debug("running statement: {0}", new Object[]{statementString});
            }
            try (PreparedStatement remove = connection.prepareStatement(statementString);){
                AtomicInteger counter = new AtomicInteger(1);
                for (String id2 : sublist) {
                    remove.setString(counter.getAndIncrement(), id2);
                }
                remove.executeUpdate();
            }
        }
    }

    @FunctionalInterface
    protected static interface BatchOperation<T> {
        public void run(Connection var1, String var2, int var3, int var4, List<T> var5) throws SQLException;
    }
}

