/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.relational;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.modeshape.persistence.relational.DefaultStatements;
import org.modeshape.persistence.relational.RelationalDbConfig;

public class OracleStatements
extends DefaultStatements {
    private static final List<Integer> IGNORABLE_ERROR_CODES = Arrays.asList(942, 955);

    protected OracleStatements(RelationalDbConfig config, Map<String, String> statements) {
        super(config, statements);
    }

    @Override
    public Void createTable(Connection connection) throws SQLException {
        try {
            return super.createTable(connection);
        }
        catch (SQLException e) {
            int errorCode = e.getErrorCode();
            if (IGNORABLE_ERROR_CODES.contains(errorCode)) {
                this.logger.debug((Throwable)e, "Ignoring Oracle SQL exception for database {0} with error code {1}", new Object[]{this.tableName(), errorCode});
                return null;
            }
            throw e;
        }
    }

    @Override
    public Void dropTable(Connection connection) throws SQLException {
        try {
            return super.dropTable(connection);
        }
        catch (SQLException e) {
            int errorCode = e.getErrorCode();
            if (IGNORABLE_ERROR_CODES.contains(e.getErrorCode())) {
                this.logger.debug((Throwable)e, "Ignoring Oracle SQL exception for database {0} with error code {1}", new Object[]{this.tableName(), errorCode});
                return null;
            }
            throw e;
        }
    }
}

