/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.relational;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.persistence.relational.RelationalProviderException;
import org.modeshape.schematic.AbstractSchematicDBTest;
import org.modeshape.schematic.Schematic;
import org.modeshape.schematic.SchematicDb;
import org.modeshape.schematic.SchematicEntry;
import org.modeshape.schematic.internal.annotation.FixFor;

public class RelationalDbIT
extends AbstractSchematicDBTest {
    protected SchematicDb getDb() throws Exception {
        return Schematic.getDb((InputStream)RelationalDbIT.class.getClassLoader().getResourceAsStream("db-config.json"));
    }

    @Before
    public void before() throws Exception {
        super.before();
        junit.framework.Assert.assertEquals((int)0, (int)this.db.keys().size());
    }

    @After
    public void after() throws Exception {
        super.after();
        try {
            this.db.keys();
            junit.framework.Assert.fail((String)"The DB table should have been dropped...");
        }
        catch (RelationalProviderException relationalProviderException) {
            // empty catch block
        }
    }

    @Test
    public void shouldLockEntriesExclusively() throws Exception {
        this.insertAndLock(100);
    }

    protected void insertAndLock(int entriesCount) throws Exception {
        List ids = (List)this.insertMultipleEntries(entriesCount, Executors.newSingleThreadExecutor()).get();
        boolean result = (Boolean)this.simulateTransaction(() -> this.db.lockForWriting(ids));
        junit.framework.Assert.assertTrue((String)"Locks should have been obtained", (boolean)result);
        result = (Boolean)this.simulateTransaction(() -> this.db.lockForWriting(ids));
        junit.framework.Assert.assertTrue((String)"Locks should have been obtained", (boolean)result);
    }

    @Test
    public void shouldReportNonExistentEntryAsLocked() throws Exception {
        this.simulateTransaction(() -> {
            Assert.assertTrue((boolean)this.db.lockForWriting(new String[]{"non_existant"}));
            return null;
        });
    }

    @Test(expected=RelationalProviderException.class)
    public void shouldNotLockEntriesWithoutTransaction() throws Exception {
        String id = this.writeSingleEntry().id();
        this.db.lockForWriting(new String[]{id});
    }

    @Test
    @Ignore(value="ignored by default because on most DBs running in Docker it takes a long time for the lock timeout message")
    public void concurrentThreadsShouldNotGetSameLock() throws Exception {
        String id = this.writeSingleEntry().id();
        CyclicBarrier barrier = new CyclicBarrier(2);
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<Boolean> t1 = executorService.submit(() -> {
            this.db.txStarted("1");
            boolean result = this.db.lockForWriting(new String[]{id});
            barrier.await();
            this.db.txCommitted("1");
            return result;
        });
        Future<Boolean> t2 = executorService.submit(() -> {
            this.db.txStarted("2");
            boolean result = this.db.lockForWriting(new String[]{id});
            barrier.await();
            this.db.txCommitted("2");
            return result;
        });
        boolean t1Success = t1.get();
        boolean t2Success = t2.get();
        junit.framework.Assert.assertTrue((String)"Only one of the threads should have been able to lock", (t1Success && !t2Success || !t1Success && t2Success ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"MODE-2629"})
    public void shouldReadWithDifferentBatches() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        int maxStatementParamCount = 1000;
        try {
            List ids = (List)this.insertMultipleEntries(2000, executorService).get(10L, TimeUnit.SECONDS);
            this.loadAndAssertIds(ids, 0);
            this.loadAndAssertIds(ids, 1);
            this.loadAndAssertIds(ids, maxStatementParamCount / 2);
            this.loadAndAssertIds(ids, maxStatementParamCount / 2 + 1);
            this.loadAndAssertIds(ids, maxStatementParamCount / 2 + maxStatementParamCount / 4);
            this.loadAndAssertIds(ids, maxStatementParamCount);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private void loadAndAssertIds(List<String> insertedIds, int batchSize) {
        List<String> expectedIds = insertedIds.subList(0, batchSize);
        List entries = this.db.load(expectedIds);
        List actualIds = entries.stream().map(SchematicEntry::id).collect(Collectors.toList());
        Collections.sort(expectedIds);
        Collections.sort(actualIds);
        junit.framework.Assert.assertEquals((String)"The same entries should have been read back", expectedIds, actualIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"MODE-2629"})
    public void shouldLockWithDifferentBatches() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        int maxStatementParamCount = 1000;
        try {
            List ids = (List)this.insertMultipleEntries(2000, executorService).get(10L, TimeUnit.SECONDS);
            this.lockIds(ids, 1);
            this.lockIds(ids, maxStatementParamCount / 2);
            this.lockIds(ids, maxStatementParamCount / 2 + 1);
            this.lockIds(ids, maxStatementParamCount / 2 + maxStatementParamCount / 4);
            this.lockIds(ids, maxStatementParamCount);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private void lockIds(List<String> insertedIds, int batchSize) throws Exception {
        List<String> subList = insertedIds.subList(0, batchSize);
        this.simulateTransaction(() -> {
            junit.framework.Assert.assertTrue((String)"Entries could not be locked", (boolean)this.db.lockForWriting(subList));
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"MODE-2629"})
    public void shouldRemoveInBatches() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        int maxStatementParamCount = 1000;
        try {
            int count = 2000;
            List ids = (List)this.insertMultipleEntries(count, executorService).get(10L, TimeUnit.SECONDS);
            this.removeBatch(ids, 0, 1);
            this.removeBatch(ids, 1, maxStatementParamCount / 2 + 1);
            int start = maxStatementParamCount / 2 + 1;
            while (start < count) {
                int end = start + maxStatementParamCount > count ? count : start + maxStatementParamCount;
                this.removeBatch(ids, start, end);
                start = end;
            }
            junit.framework.Assert.assertTrue((String)"Not all keys were deleted", (boolean)this.db.keys().isEmpty());
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private void removeBatch(List<String> ids, int start, int end) throws Exception {
        this.simulateTransaction(() -> {
            List toRemove = ids.subList(start, end);
            toRemove.forEach(id -> this.db.remove(id));
            return null;
        });
    }
}

