/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.IsNodeWithChildren;
import org.modeshape.graph.IsNodeWithProperty;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.mimetype.ExtensionBasedMimeTypeDetector;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.repository.ModeShapeEngine;
import org.modeshape.repository.ModeShapeLexicon;
import org.modeshape.repository.sequencer.MockStreamSequencerA;

public class ModeShapeConfigurationTest {
    private ExecutionContext context;
    private ModeShapeConfiguration configuration;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.configuration = new ModeShapeConfiguration();
    }

    protected Path.Segment segment(String segment) {
        return this.context.getValueFactories().getPathFactory().createSegment(segment);
    }

    @Test
    public void shouldAllowCreatingWithNoArguments() {
        this.configuration = new ModeShapeConfiguration();
    }

    @Test
    public void shouldAllowCreatingWithSpecifiedExecutionContext() {
        this.configuration = new ModeShapeConfiguration(this.context);
    }

    @Test
    public void shouldHaveDefaultConfigurationSourceIfNotSpecified() {
        Assert.assertThat((Object)this.configuration.getConfigurationDefinition(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldLoadConfigurationFromFilePath() throws Exception {
        File file = new File("src/test/resources/config/configRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom("src/test/resources/config/configRepository.xml");
        Assert.assertThat((Object)this.configuration.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph.getNode("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Cars"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Cars"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.RETRY_LIMIT, (Object[])new Object[]{"3"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Cars"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{InMemoryRepositorySource.class.getName()}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Aircraft"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Aircraft"), (Matcher)IsNodeWithProperty.hasProperty((String)"defaultWorkspaceName", (Object[])new Object[]{"default"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Aircraft"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{InMemoryRepositorySource.class.getName()}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Cache"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Cache"), (Matcher)IsNodeWithProperty.hasProperty((String)"defaultWorkspaceName", (Object[])new Object[]{"default"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Cache"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{InMemoryRepositorySource.class.getName()}));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:mimeTypeDetectors")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("Detector")));
        Assert.assertThat((Object)subgraph.getNode("/mode:mimeTypeDetectors/Detector"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:mimeTypeDetectors/Detector"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.DESCRIPTION, (Object[])new Object[]{"Standard extension-based MIME type detector"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:mimeTypeDetectors/Detector"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{ExtensionBasedMimeTypeDetector.class.getName()}));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:sequencers")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("Image Sequencer")));
        Assert.assertThat((Object)subgraph.getNode("/mode:sequencers/Image Sequencer"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sequencers/Image Sequencer"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.DESCRIPTION, (Object[])new Object[]{"Image metadata sequencer"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sequencers/Image Sequencer"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{"org.modeshape.sequencer.image.ImageMetadataSequencer"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sequencers/Image Sequencer"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.PATH_EXPRESSION, (Object[])new Object[]{"/foo/source => /foo/target", "/bar/source => /bar/target"}));
    }

    @Test
    public void shoulLoadConfigurationFromFileObject() throws Exception {
        File file = new File("src/test/resources/config/configRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        this.configuration.loadFrom(new File("src/test/resources/config/configRepository.xml"));
        Assert.assertThat((Object)this.configuration.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shoulLoadConfigurationFromURL() throws Exception {
        File file = new File("src/test/resources/config/configRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        URL fileUrl = file.toURI().toURL();
        Assert.assertThat((Object)fileUrl, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.configuration.loadFrom(fileUrl);
        Assert.assertThat((Object)this.configuration.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shoulLoadConfigurationFromInputStream() throws Exception {
        File file = new File("src/test/resources/config/configRepository.xml");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.canRead(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)file.isFile(), (Matcher)Is.is((Object)true));
        FileInputStream stream = new FileInputStream(file);
        try {
            this.configuration.loadFrom((InputStream)stream);
        }
        finally {
            ((InputStream)stream).close();
        }
        Assert.assertThat((Object)this.configuration.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shoulLoadConfigurationFromRepositorySource() throws Exception {
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName("name");
        this.configuration.loadFrom((RepositorySource)source);
        Assert.assertThat((Object)this.configuration.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
        ModeShapeEngine engine = this.configuration.build();
        Assert.assertThat((Object)engine, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)engine.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldLoadConfigurationEvenAfterAlreadyHavingLoadedConfiguration() throws Exception {
        this.configuration.loadFrom("src/test/resources/config/configRepository.xml");
        this.configuration.loadFrom(new File("src/test/resources/config/configRepository.xml"));
        this.configuration.loadFrom(new File("src/test/resources/config/configRepository.xml").toURI().toURL());
        Assert.assertThat((Object)this.configuration.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldBuildEngineWithDefaultConfiguration() throws Exception {
        Assert.assertThat((Object)this.configuration.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
        ModeShapeEngine engine = this.configuration.build();
        Assert.assertThat((Object)engine, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)engine.getProblems().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldLoadConfigurationFromInMemoryRepositorySource() {
        InMemoryRepositorySource configSource = new InMemoryRepositorySource();
        configSource.setName("config repo");
        this.configuration.loadFrom((RepositorySource)configSource).and().save();
        Assert.assertThat((Object)this.configuration, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Assert.assertThat((Object)content.getRepositorySource(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        InMemoryRepositorySource source = (InMemoryRepositorySource)content.getRepositorySource();
        Assert.assertThat((Object)source.getName(), (Matcher)Is.is((Object)configSource.getName()));
        Assert.assertThat((Object)source.getRetryLimit(), (Matcher)Is.is((Object)configSource.getRetryLimit()));
    }

    @Test
    public void shouldAllowAddingRepositorySourceByClassNameAndSettingProperties() {
        ((ModeShapeConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("Source1").usingClass(InMemoryRepositorySource.class.getName()).loadedFromClasspath()).setDescription("description")).setRetryLimit(5).and()).save();
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph.getNode("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.DESCRIPTION, (Object[])new Object[]{"description"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.RETRY_LIMIT, (Object[])new Object[]{5}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{InMemoryRepositorySource.class.getName()}));
    }

    @Test
    public void shouldAllowSettingDescriptionOnRepositorySourceUsingPrefixedPropertyName() {
        ((ModeShapeConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("Source1").usingClass(InMemoryRepositorySource.class.getName()).loadedFromClasspath()).setProperty("mode:description", "desc")).and()).save();
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph.getNode("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.DESCRIPTION, (Object[])new Object[]{"desc"}));
    }

    @Test
    public void shouldAllowSettingDescriptionOnRepositorySourceUsingNonPrefixedPropertyName() {
        ((ModeShapeConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("Source1").usingClass(InMemoryRepositorySource.class.getName()).loadedFromClasspath()).setProperty("description", "desc")).and()).save();
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph.getNode("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.DESCRIPTION, (Object[])new Object[]{"desc"}));
    }

    @Test
    public void shouldAllowSettingRetryLimitOnRepositorySourceUsingPrefixedPropertyName() {
        ((ModeShapeConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("Source1").usingClass(InMemoryRepositorySource.class.getName()).loadedFromClasspath()).setProperty("mode:retryLimit", 5)).and()).save();
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph.getNode("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.RETRY_LIMIT, (Object[])new Object[]{5}));
    }

    @Test
    public void shouldAllowSettingRetryLimitOnRepositorySourceUsingNonPrefixedPropertyName() {
        ((ModeShapeConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("Source1").usingClass(InMemoryRepositorySource.class.getName()).loadedFromClasspath()).setProperty("retryLimit", 5)).and()).save();
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph.getNode("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.RETRY_LIMIT, (Object[])new Object[]{5}));
    }

    @Test
    public void shouldAllowAddingRepositorySourceByClassNameAndClasspathAndSettingProperties() {
        ((ModeShapeConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("Source1").usingClass(InMemoryRepositorySource.class.getName()).loadedFrom(new String[]{"cp1", "cp2"})).setProperty("retryLimit", 5)).and()).save();
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph.getNode("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.RETRY_LIMIT, (Object[])new Object[]{5}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{InMemoryRepositorySource.class.getName()}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSPATH, (Object[])new Object[]{"cp1", "cp2"}));
    }

    @Test
    public void shouldAllowAddingRepositorySourceByClassReferenceAndSettingProperties() {
        ((ModeShapeConfiguration)((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("Source1").usingClass(InMemoryRepositorySource.class)).setProperty("retryLimit", 5)).and()).save();
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph.getNode("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.RETRY_LIMIT, (Object[])new Object[]{5}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{InMemoryRepositorySource.class.getName()}));
    }

    @Test
    public void shouldAllowAddingMimeTypeDetector() {
        ((ModeShapeConfiguration)((ModeShapeConfiguration.MimeTypeDetectorDefinition)((ModeShapeConfiguration.MimeTypeDetectorDefinition)this.configuration.mimeTypeDetector("detector").usingClass(ExtensionBasedMimeTypeDetector.class)).setDescription("default detector")).and()).save();
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:mimeTypeDetectors")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("detector")));
        Assert.assertThat((Object)subgraph.getNode("/mode:mimeTypeDetectors/detector"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:mimeTypeDetectors/detector"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.DESCRIPTION, (Object[])new Object[]{"default detector"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:mimeTypeDetectors/detector"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{ExtensionBasedMimeTypeDetector.class.getName()}));
    }

    @Test
    public void shouldAllowAddingSequencer() {
        ((ModeShapeConfiguration)((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)this.configuration.sequencer("sequencerA").usingClass(MockStreamSequencerA.class)).setDescription("Mock Sequencer A")).sequencingFrom("/foo/source").andOutputtingTo("/foo/target").sequencingFrom("/bar/source").andOutputtingTo("/bar/target").and()).save();
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:sequencers")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("sequencerA")));
        Assert.assertThat((Object)subgraph.getNode("/mode:sequencers/sequencerA"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sequencers/sequencerA"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.DESCRIPTION, (Object[])new Object[]{"Mock Sequencer A"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sequencers/sequencerA"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{MockStreamSequencerA.class.getName()}));
        System.out.println(((SubgraphNode)subgraph.getNode("/mode:sequencers/sequencerA")).getProperty(ModeShapeLexicon.PATH_EXPRESSION));
        Assert.assertThat((Object)subgraph.getNode("/mode:sequencers/sequencerA"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.PATH_EXPRESSION, (Object[])new Object[]{"/foo/source => /foo/target", "/bar/source => /bar/target"}));
    }

    @Test
    public void shouldAllowConfigurationInMultipleSteps() {
        ((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("Source1").usingClass(InMemoryRepositorySource.class.getName()).loadedFrom(new String[]{"cp1", "cp2"})).setProperty("retryLimit", 5);
        ((ModeShapeConfiguration.MimeTypeDetectorDefinition)this.configuration.mimeTypeDetector("detector").usingClass(ExtensionBasedMimeTypeDetector.class)).setDescription("default detector");
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)this.configuration.sequencer("sequencerA").usingClass(MockStreamSequencerA.class)).setDescription("Mock Sequencer A")).sequencingFrom("/foo/source").andOutputtingTo("/foo/target").sequencingFrom("/bar/source").andOutputtingTo("/bar/target");
        this.configuration.save();
        ModeShapeConfiguration.ConfigurationDefinition content = this.configuration.getConfigurationDefinition();
        Subgraph subgraph = (Subgraph)content.graph().getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph.getNode("/mode:sources"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.RETRY_LIMIT, (Object[])new Object[]{5}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{InMemoryRepositorySource.class.getName()}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sources/Source1"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSPATH, (Object[])new Object[]{"cp1", "cp2"}));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:mimeTypeDetectors")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("detector")));
        Assert.assertThat((Object)subgraph.getNode("/mode:mimeTypeDetectors/detector"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:mimeTypeDetectors/detector"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.DESCRIPTION, (Object[])new Object[]{"default detector"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:mimeTypeDetectors/detector"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{ExtensionBasedMimeTypeDetector.class.getName()}));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("/mode:sequencers")).getChildren(), (Matcher)IsNodeWithChildren.hasChild((Path.Segment)this.segment("sequencerA")));
        Assert.assertThat((Object)subgraph.getNode("/mode:sequencers/sequencerA"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("/mode:sequencers/sequencerA"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.DESCRIPTION, (Object[])new Object[]{"Mock Sequencer A"}));
        Assert.assertThat((Object)subgraph.getNode("/mode:sequencers/sequencerA"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.CLASSNAME, (Object[])new Object[]{MockStreamSequencerA.class.getName()}));
        System.out.println(((SubgraphNode)subgraph.getNode("/mode:sequencers/sequencerA")).getProperty(ModeShapeLexicon.PATH_EXPRESSION));
        Assert.assertThat((Object)subgraph.getNode("/mode:sequencers/sequencerA"), (Matcher)IsNodeWithProperty.hasProperty((Name)ModeShapeLexicon.PATH_EXPRESSION, (Object[])new Object[]{"/foo/source => /foo/target", "/bar/source => /bar/target"}));
    }
}

