/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.sequencer;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.collection.Problems;
import org.modeshape.graph.Node;
import org.modeshape.graph.observe.NetChangeObserver;
import org.modeshape.repository.sequencer.Sequencer;
import org.modeshape.repository.sequencer.SequencerConfig;
import org.modeshape.repository.sequencer.SequencerContext;
import org.modeshape.repository.util.RepositoryNodePath;

@ThreadSafe
public class MockSequencerB
implements Sequencer {
    private SequencerConfig config;
    private AtomicInteger counter = new AtomicInteger();
    private CountDownLatch latch = new CountDownLatch(0);

    public void setExpectedCount(int numExpected) {
        this.latch = new CountDownLatch(numExpected);
    }

    public boolean awaitExecution(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    public void setConfiguration(SequencerConfig sequencerConfiguration) {
        this.config = sequencerConfiguration;
    }

    public void execute(Node input, String sequencedPropertyName, NetChangeObserver.NetChange changes, Set<RepositoryNodePath> outputPaths, SequencerContext context, Problems problems) {
        this.counter.incrementAndGet();
        this.latch.countDown();
    }

    public int getCounter() {
        return this.counter.get();
    }

    public boolean isConfigured() {
        return this.config != null;
    }

    public SequencerConfig getConfiguration() {
        return this.config;
    }

    public String toString() {
        return (this.config != null ? this.config.getName() : "SampleSequencer") + " [" + this.getCounter() + "]";
    }
}

