/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.sequencer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.Reflection;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Results;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.observe.NetChangeObserver;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.repository.ModeShapeLexicon;
import org.modeshape.repository.RepositoryI18n;
import org.modeshape.repository.sequencer.Sequencer;
import org.modeshape.repository.sequencer.SequencerConfig;
import org.modeshape.repository.sequencer.SequencerContext;
import org.modeshape.repository.sequencer.SequencerException;
import org.modeshape.repository.sequencer.SequencerOutputMap;
import org.modeshape.repository.util.RepositoryNodePath;

public class StreamSequencerAdapter
implements Sequencer {
    public static final boolean DEFAULT_ADD_DEFAULT_MIXIN = true;
    private static final Logger LOGGER = Logger.getLogger(StreamSequencerAdapter.class);
    private SequencerConfig configuration;
    private final StreamSequencer streamSequencer;
    private final boolean addDerivedMixin;

    public StreamSequencerAdapter(StreamSequencer streamSequencer) {
        this(streamSequencer, true);
    }

    public StreamSequencerAdapter(StreamSequencer streamSequencer, boolean addDerivedMixin) {
        this.streamSequencer = streamSequencer;
        this.addDerivedMixin = addDerivedMixin;
    }

    public SequencerConfig getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SequencerConfig configuration) {
        this.configuration = configuration;
        if (configuration.getProperties() != null) {
            Class<?> streamSequencerClass = this.streamSequencer.getClass();
            Reflection reflection = new Reflection(streamSequencerClass);
            try {
                reflection.invokeSetterMethodOnTarget("classpath", (Object)this.streamSequencer, (Object)configuration.getComponentClasspathArray());
            }
            catch (Exception e) {
                try {
                    reflection.invokeSetterMethodOnTarget("classpath", (Object)this.streamSequencer, (Object)configuration.getComponentClasspath());
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            for (Map.Entry entry : configuration.getProperties().entrySet()) {
                String propertyName = (String)entry.getKey();
                try {
                    reflection.invokeSetterMethodOnTarget(propertyName, (Object)this.streamSequencer, entry.getValue());
                    LOGGER.trace("Set '{0}' property from sequencer configuration on '{1}' stream sequencer implementation to {2}", new Object[]{propertyName, streamSequencerClass.getName(), entry.getValue()});
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception ignore) {
                    LOGGER.debug("Unable to set '{0}' property from sequencer configuration on '{1}' stream sequencer implementation", new Object[]{propertyName, streamSequencerClass.getName()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(Node input, String sequencedPropertyName, NetChangeObserver.NetChange changes, Set<RepositoryNodePath> outputPaths, SequencerContext context, Problems problems) throws SequencerException {
        Object value;
        Property sequencedProperty = input.getProperty(sequencedPropertyName);
        if (sequencedProperty == null || sequencedProperty.isEmpty()) {
            String msg = RepositoryI18n.unableToFindPropertyForSequencing.text(new Object[]{sequencedPropertyName, input.getLocation()});
            throw new SequencerException(msg);
        }
        ValueFactories factories = context.getExecutionContext().getValueFactories();
        SequencerOutputMap output = new SequencerOutputMap(factories);
        InputStream stream = null;
        Throwable firstError = null;
        Binary binary = (Binary)factories.getBinaryFactory().create(sequencedProperty.getFirstValue());
        binary.acquire();
        try {
            stream = binary.getStream();
            StreamSequencerContext streamSequencerContext = this.createStreamSequencerContext(input, sequencedProperty, context, problems);
            this.streamSequencer.sequence(stream, (SequencerOutput)output, streamSequencerContext);
        }
        catch (Throwable t) {
            firstError = t;
        }
        finally {
            try {
                if (stream != null) {
                    try {
                        try {
                            stream.close();
                            stream = null;
                        }
                        catch (Throwable t) {
                            if (firstError == null) {
                                firstError = t;
                            }
                            stream = null;
                        }
                    }
                    catch (Throwable throwable) {
                        stream = null;
                        throw throwable;
                    }
                }
                if (firstError != null) {
                    throw new SequencerException(firstError);
                }
            }
            finally {
                binary.release();
            }
        }
        HashSet<Path> builtPaths = new HashSet<Path>();
        boolean replacePreviouslyDerivedContent = Boolean.parseBoolean(SequencerConfig.DEFAULT_REPLACE_PREVIOUSLY_DERIVED_CONTENT_PROPERTY_VALUE);
        SequencerConfig config = this.getConfiguration();
        if (config != null && (value = config.getProperties().get("replacePreviouslyDerivedContent")) != null) {
            replacePreviouslyDerivedContent = Boolean.parseBoolean(value.toString());
        }
        Path inputPath = input.getLocation().getPath();
        Iterator<RepositoryNodePath> i$ = outputPaths.iterator();
        while (true) {
            if (!i$.hasNext()) {
                context.getDestination().submit();
                return;
            }
            RepositoryNodePath outputPath = i$.next();
            String repositoryWorkspaceName = outputPath.getWorkspaceName();
            String nodePath = outputPath.getNodePath();
            context.destinationGraph().useWorkspace(repositoryWorkspaceName);
            this.buildPathTo(nodePath, context, builtPaths);
            this.saveOutput(inputPath, nodePath, output, context, builtPaths, replacePreviouslyDerivedContent);
        }
    }

    private void buildPathTo(String nodePath, SequencerContext context, Set<Path> builtPaths) {
        PathFactory pathFactory = context.getExecutionContext().getValueFactories().getPathFactory();
        Path targetPath = (Path)pathFactory.create(nodePath);
        this.buildPathTo(targetPath, context, builtPaths);
    }

    private void buildPathTo(Path targetPath, SequencerContext context, Set<Path> builtPaths) {
        PathFactory pathFactory = context.getExecutionContext().getValueFactories().getPathFactory();
        PropertyFactory propFactory = context.getExecutionContext().getPropertyFactory();
        if (targetPath.isRoot()) {
            return;
        }
        Path workingPath = pathFactory.createRootPath();
        Path.Segment[] segments = targetPath.getSegmentsArray();
        Property primaryType = propFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.UNSTRUCTURED});
        int max = segments.length;
        for (int i = 0; i < max; ++i) {
            if (builtPaths.contains(workingPath = pathFactory.create(workingPath, new Path.Segment[]{segments[i]}))) continue;
            try {
                context.destinationGraph().getNodeAt(workingPath);
                continue;
            }
            catch (PathNotFoundException pnfe) {
                context.getDestination().create(workingPath, primaryType, new Property[0]);
                builtPaths.add(workingPath);
            }
        }
    }

    protected void saveOutput(Path inputPath, String outputPath, SequencerOutputMap output, SequencerContext context, Set<Path> builtPaths, boolean replacePreviouslyDerivedContent) {
        if (output.isEmpty()) {
            return;
        }
        PathFactory pathFactory = context.getExecutionContext().getValueFactories().getPathFactory();
        PropertyFactory propertyFactory = context.getExecutionContext().getPropertyFactory();
        Path outputNodePath = (Path)pathFactory.create(outputPath);
        Path derivedFromPath = this.derivedFromPath(inputPath);
        PathStrategy pathStrategy = null;
        try {
            Graph graph = context.destinationGraph();
            Graph.Batch batch = graph.batch();
            List children = (List)graph.getChildren().of(outputNodePath);
            HashMap<Name, AtomicInteger> existingSnsByNodeName = new HashMap<Name, AtomicInteger>();
            for (Location child : children) {
                Path.Segment childSegment = child.getPath().getLastSegment();
                Name childName = childSegment.getName();
                AtomicInteger sns = (AtomicInteger)existingSnsByNodeName.get(childName);
                if (sns == null) {
                    sns = new AtomicInteger(childSegment.getIndex());
                    existingSnsByNodeName.put(childName, sns);
                } else if (childSegment.getIndex() > sns.get()) {
                    sns.set(childSegment.getIndex());
                }
                if (!replacePreviouslyDerivedContent) continue;
                ((Graph.BatchConjunction)batch.readProperty(ModeShapeLexicon.DERIVED_FROM).on(child)).and();
            }
            Results derivedResults = batch.execute();
            if (!derivedResults.getRequests().isEmpty()) {
                Graph.Batch deleteExistingBatch = graph.batch();
                block5: for (Node child : derivedResults) {
                    Property derivedFrom = child.getProperty(ModeShapeLexicon.DERIVED_FROM);
                    if (derivedFrom == null) continue;
                    for (Object value : derivedFrom) {
                        try {
                            Location childLocation;
                            Path.Segment childSegment;
                            Name childName;
                            AtomicInteger sns;
                            Path derivedFromValue = (Path)pathFactory.create(value);
                            if (!derivedFromPath.isSameAs(derivedFromValue) || (sns = (AtomicInteger)existingSnsByNodeName.get(childName = (childSegment = (childLocation = child.getLocation()).getPath().getLastSegment()).getName())) == null) continue;
                            if (sns.decrementAndGet() < 1) {
                                existingSnsByNodeName.remove(childName);
                            }
                            deleteExistingBatch.delete(childLocation).and();
                            continue block5;
                        }
                        catch (ValueFormatException e) {
                        }
                    }
                }
                deleteExistingBatch.execute();
            }
            if (!existingSnsByNodeName.isEmpty()) {
                pathStrategy = new NextSnsPathStrategy(existingSnsByNodeName, pathFactory);
            }
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        if (pathStrategy == null) {
            pathStrategy = new PassThroughStrategy();
        }
        HashSet<Path> pathsOfTopLevelNodes = new HashSet<Path>();
        Destination destination = context.getDestination();
        for (SequencerOutputMap.Entry entry : output) {
            Path path = entry.getPath();
            Path targetNodePath = pathStrategy.validate(path);
            Path absolutePath = targetNodePath.isAbsolute() ? targetNodePath : outputNodePath.resolve(targetNodePath);
            Collection<Property> properties = new LinkedList<Property>();
            for (SequencerOutputMap.PropertyValue property : entry.getPropertyValues()) {
                Object value;
                value = property.getValue();
                Property newProperty = propertyFactory.create(property.getName(), new Object[]{value});
                properties.add(newProperty);
            }
            if (targetNodePath.size() <= 1 && this.addDerivedMixin && pathsOfTopLevelNodes.add(absolutePath)) {
                properties = this.addDerivedProperties(properties, context, derivedFromPath);
            }
            if (absolutePath.getParent() != null) {
                this.buildPathTo(absolutePath.getParent(), context, builtPaths);
            }
            destination.create(absolutePath, properties);
            builtPaths.add(absolutePath);
        }
    }

    protected Collection<Property> addDerivedProperties(Collection<Property> properties, SequencerContext context, Path derivedPath) {
        Property derivedOn;
        HashMap<Name, Property> propertiesByName = new HashMap<Name, Property>();
        for (Property property : properties) {
            propertiesByName.put(property.getName(), property);
        }
        Object[] values = null;
        Property mixinTypes = (Property)propertiesByName.get(JcrLexicon.MIXIN_TYPES);
        if (mixinTypes == null || mixinTypes.isEmpty()) {
            values = ModeShapeLexicon.DERIVED;
        } else if (mixinTypes.isSingle()) {
            Name name = (Name)context.getExecutionContext().getValueFactories().getNameFactory().create(mixinTypes.getFirstValue());
            values = new Object[]{name, ModeShapeLexicon.DERIVED};
        } else {
            Object[] oldValues = mixinTypes.getValuesAsArray();
            Object[] newValues = new Object[oldValues.length + 1];
            newValues[0] = ModeShapeLexicon.DERIVED;
            System.arraycopy(oldValues, 0, newValues, 1, oldValues.length);
            values = newValues;
        }
        PropertyFactory propertyFactory = context.getExecutionContext().getPropertyFactory();
        Property newMixinTypes = propertyFactory.create(JcrLexicon.MIXIN_TYPES, new Object[]{values});
        propertiesByName.put(newMixinTypes.getName(), newMixinTypes);
        Property derivedFrom = (Property)propertiesByName.get(ModeShapeLexicon.DERIVED_FROM);
        if (derivedFrom == null) {
            derivedFrom = propertyFactory.create(ModeShapeLexicon.DERIVED_FROM, derivedPath);
            propertiesByName.put(derivedFrom.getName(), derivedFrom);
        }
        if ((derivedOn = (Property)propertiesByName.get(ModeShapeLexicon.DERIVED_AT)) == null) {
            derivedOn = propertyFactory.create(ModeShapeLexicon.DERIVED_AT, new Object[]{context.getTimestamp()});
            propertiesByName.put(derivedOn.getName(), derivedOn);
        }
        return propertiesByName.values();
    }

    protected Path derivedFromPath(Path inputPath) {
        assert (inputPath != null);
        if (!inputPath.isRoot() && inputPath.getLastSegment().getName().equals(JcrLexicon.CONTENT)) {
            inputPath = inputPath.getParent();
        }
        return inputPath;
    }

    protected String[] extractMixinTypes(Object value) {
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        return null;
    }

    protected StreamSequencerContext createStreamSequencerContext(Node input, Property sequencedProperty, SequencerContext context, Problems problems) {
        assert (input != null);
        assert (sequencedProperty != null);
        assert (context != null);
        assert (problems != null);
        ValueFactories factories = context.getExecutionContext().getValueFactories();
        Path path = (Path)factories.getPathFactory().create(input.getLocation().getPath());
        Set props = Collections.unmodifiableSet(input.getPropertiesByName().values());
        Name fileName = path.getLastSegment().getName();
        if (JcrLexicon.CONTENT.equals(fileName) && !path.isRoot()) {
            fileName = path.getParent().getLastSegment().getName();
        }
        String mimeType = this.getMimeType(context, sequencedProperty, fileName.getLocalName());
        return new StreamSequencerContext(context.getExecutionContext(), path, props, mimeType, problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMimeType(SequencerContext context, Property sequencedProperty, String name) {
        SequencerException err = null;
        String mimeType = null;
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(sequencedProperty.toString().getBytes());
            String string = mimeType = context.getExecutionContext().getMimeTypeDetector().mimeTypeOf(name, (InputStream)stream);
            return string;
        }
        catch (Exception error) {
            err = new SequencerException(error);
        }
        finally {
            block13: {
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException error) {
                        if (err != null) break block13;
                        err = new SequencerException(error);
                    }
                }
            }
        }
        throw err;
    }

    protected class NextSnsPathStrategy
    implements PathStrategy {
        private final Map<Name, AtomicInteger> existingSnsByNodeName;
        private final PathFactory pathFactory;
        private final Map<Path.Segment, Path> topLevelSegmentReplacements = new HashMap<Path.Segment, Path>();

        protected NextSnsPathStrategy(Map<Name, AtomicInteger> existingSnsByNodeName, PathFactory pathFactory) {
            this.existingSnsByNodeName = existingSnsByNodeName;
            assert (this.existingSnsByNodeName != null);
            this.pathFactory = pathFactory;
        }

        @Override
        public Path validate(Path path) {
            if (path.size() == 0) {
                return path;
            }
            if (path.isAbsolute()) {
                return path;
            }
            Path.Segment firstSegment = path.getSegment(0);
            if (path.size() == 1) {
                Name nodeName = firstSegment.getName();
                AtomicInteger lastSns = this.existingSnsByNodeName.get(nodeName);
                if (lastSns == null) {
                    lastSns = new AtomicInteger(1);
                    this.existingSnsByNodeName.put(nodeName, lastSns);
                } else {
                    lastSns.incrementAndGet();
                }
                int sns = lastSns.get();
                if (sns != firstSegment.getIndex()) {
                    Path.Segment newSegment = this.pathFactory.createSegment(nodeName, sns);
                    path = this.pathFactory.createRelativePath(new Path.Segment[]{newSegment});
                    this.topLevelSegmentReplacements.put(firstSegment, path);
                }
            } else {
                Path newBasePath = this.topLevelSegmentReplacements.get(firstSegment);
                if (newBasePath != null) {
                    path = this.pathFactory.create(newBasePath, path.subpath(1));
                }
            }
            return path;
        }
    }

    protected class PassThroughStrategy
    implements PathStrategy {
        protected PassThroughStrategy() {
        }

        @Override
        public Path validate(Path path) {
            return path;
        }
    }

    protected static interface PathStrategy {
        public Path validate(Path var1);
    }
}

