/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.common.FixFor;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.LocalObservationBus;
import org.modeshape.graph.observe.ObservationBus;
import org.modeshape.graph.property.Path;
import org.modeshape.repository.FakeRepositorySource;
import org.modeshape.repository.RepositoryLibrary;
import org.modeshape.repository.RepositoryService;
import org.modeshape.repository.service.ServiceAdministrator;

public class RepositoryServiceTest {
    private RepositoryService service;
    private String configSourceName;
    private String configWorkspaceName;
    private Graph configRepository;
    private InMemoryRepositorySource configRepositorySource;
    private ExecutionContext context;
    private Path root;
    private Problems problems;
    private ObservationBus bus;
    @Mock
    private RepositoryLibrary sources;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("mode", "http://www.modeshape.org/1.0");
        this.configSourceName = "configSource";
        this.configWorkspaceName = null;
        this.configRepositorySource = new InMemoryRepositorySource();
        this.configRepositorySource.setName(this.configSourceName);
        this.configRepositorySource.setDefaultWorkspaceName("default");
        this.configRepository = Graph.create((RepositorySource)this.configRepositorySource, (ExecutionContext)this.context);
        RepositoryConnection configRepositoryConnection = this.configRepositorySource.getConnection();
        Mockito.when((Object)this.sources.createConnection(this.configSourceName)).thenReturn((Object)configRepositoryConnection);
        this.root = this.context.getValueFactories().getPathFactory().createRootPath();
        this.problems = new SimpleProblems();
        this.bus = new LocalObservationBus();
        this.service = new RepositoryService((RepositorySource)this.configRepositorySource, this.configWorkspaceName, this.root, this.context, this.bus, this.problems);
    }

    @After
    public void afterEach() throws Exception {
        this.service.getAdministrator().shutdown();
        this.service.getAdministrator().awaitTermination(4L, TimeUnit.SECONDS);
        Logger.getLogger(this.getClass()).trace("", new Object[0]);
    }

    @Test
    public void shouldHaveServiceAdministratorAfterInstantiation() {
        Assert.assertThat((Object)this.service.getAdministrator(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveConfigurationSourceAfterInstantiation() {
        Assert.assertThat((Object)this.service.getConfigurationSourceName(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.service.getConfigurationSourceName(), (Matcher)Is.is((Object)this.configSourceName));
    }

    @Test
    public void shouldHaveAnExecutionEnvironmentAfterInstantiation() {
        Assert.assertThat((Object)this.service.getExecutionEnvironment(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.service.getExecutionEnvironment(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.context)));
    }

    @Test
    public void shouldHaveNullJndiNameAfterInstantiation() {
        Assert.assertThat((Object)this.service.getJndiName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldAllowShuttingDownBeforeStartingUp() throws Exception {
        Assert.assertThat((Object)this.service.getAdministrator().getState(), (Matcher)Is.is((Object)ServiceAdministrator.State.PAUSED));
        this.service.getAdministrator().shutdown();
        this.service.getAdministrator().awaitTermination(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)this.service.getAdministrator().getState(), (Matcher)Is.is((Object)ServiceAdministrator.State.TERMINATED));
    }

    @Test
    public void shouldStartUpUsingConfigurationRepositoryThatContainsNoSources() throws Exception {
        this.configRepository.create("/mode:sources").and();
        this.service.getAdministrator().start();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.sources});
    }

    @Test
    public void shouldStartUpAndCreateRepositoryUsingConfigurationRepositoryThatContainsNoSources() {
        this.configRepository.useWorkspace("default");
        this.configRepository.create("/mode:sources").and();
        this.configRepository.create("/mode:sources/source A").and();
        String className = InMemoryRepositorySource.class.getName();
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSNAME).on("/mode:sources/source A")).to(className);
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSPATH).on("/mode:sources/source A")).to("");
        ((Graph.SetValuesTo)this.configRepository.set("retryLimit").on("/mode:sources/source A")).to(3);
        String fedReposPath = "/mode:repositories/fed repos/";
        this.configRepository.create("/mode:repositories").and();
        this.configRepository.create("/mode:repositories/fed repos").and();
        this.configRepository.create("/mode:repositories/fed repos/mode:regions").and();
        this.configRepository.create("/mode:repositories/fed repos/mode:regions/source A").and();
        this.configRepository.create("/mode:repositories/fed repos/mode:regions/source B").and();
        this.configRepository.create("/mode:repositories/fed repos/mode:regions/source C").and();
        this.configRepository.create("/mode:repositories/fed repos/mode:regions/source D").and();
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.TIME_TO_EXPIRE).on(fedReposPath)).to(20000);
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.PROJECTION_RULES).on(fedReposPath + "mode:regions/source A")).to("/a/b/c => /sx/sy");
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.PROJECTION_RULES).on(fedReposPath + "mode:regions/source B")).to("/ => /");
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.PROJECTION_RULES).on(fedReposPath + "mode:regions/source C")).to("/d/e/f => /");
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.PROJECTION_RULES).on(fedReposPath + "mode:regions/source D")).to("/ => /x/y/z");
        this.service.getAdministrator().start();
    }

    @Test
    public void shouldConfigureRepositorySourceWithSetterThatTakesArrayButWithSingleValues() {
        Path configPath = (Path)this.context.getValueFactories().getPathFactory().create("/mode:system");
        this.service = new RepositoryService((RepositorySource)this.configRepositorySource, this.configWorkspaceName, configPath, this.context, this.bus, this.problems);
        this.configRepository.useWorkspace("default");
        this.configRepository.create("/mode:system").and();
        this.configRepository.create("/mode:system/mode:sources").and();
        this.configRepository.create("/mode:system/mode:sources/source A").and();
        String className = FakeRepositorySource.class.getName();
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSNAME).on("/mode:system/mode:sources/source A")).to(className);
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSPATH).on("/mode:system/mode:sources/source A")).to("");
        ((Graph.SetValuesTo)this.configRepository.set("retryLimit").on("/mode:system/mode:sources/source A")).to(3);
        ((Graph.SetValuesTo)this.configRepository.set("intParam").on("/mode:system/mode:sources/source A")).to("3");
        ((Graph.SetValuesTo)this.configRepository.set("shortParam").on("/mode:system/mode:sources/source A")).to("32");
        ((Graph.SetValuesTo)this.configRepository.set("booleanParam").on("/mode:system/mode:sources/source A")).to("true");
        ((Graph.SetValuesTo)this.configRepository.set("stringParam").on("/mode:system/mode:sources/source A")).to("string value");
        ((Graph.SetValuesTo)this.configRepository.set("intArrayParam").on("/mode:system/mode:sources/source A")).to("3");
        ((Graph.SetValuesTo)this.configRepository.set("booleanArrayParam").on("/mode:system/mode:sources/source A")).to("true");
        ((Graph.SetValuesTo)this.configRepository.set("longObjectArrayParam").on("/mode:system/mode:sources/source A")).to("987654321");
        ((Graph.SetValuesTo)this.configRepository.set("booleanObjectArrayParam").on("/mode:system/mode:sources/source A")).to("true");
        ((Graph.SetValuesTo)this.configRepository.set("stringArrayParam").on("/mode:system/mode:sources/source A")).to("string value");
        this.service.getAdministrator().start();
        RepositorySource repositorySourceA = this.service.getRepositoryLibrary().getSource("source A");
        Assert.assertThat((Object)repositorySourceA, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FakeRepositorySource.class)));
        FakeRepositorySource sourceA = (FakeRepositorySource)repositorySourceA;
        Assert.assertThat((Object)sourceA.getIntParam(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)sourceA.getShortParam(), (Matcher)Is.is((Object)32));
        Assert.assertThat((Object)sourceA.isBooleanParam(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)sourceA.getStringParam(), (Matcher)Is.is((Object)"string value"));
        Assert.assertThat((Object)sourceA.getIntArrayParam(), (Matcher)Is.is((Object)new int[]{3}));
        Assert.assertThat((Object)sourceA.getBooleanArrayParam(), (Matcher)Is.is((Object)new boolean[]{true}));
        Assert.assertThat((Object)sourceA.getLongObjectArrayParam(), (Matcher)Is.is((Object)new Long[]{987654321L}));
        Assert.assertThat((Object)sourceA.getBooleanObjectArrayParam(), (Matcher)Is.is((Object)new Boolean[]{Boolean.TRUE}));
        Assert.assertThat((Object)sourceA.getStringArrayParam(), (Matcher)Is.is((Object)new String[]{"string value"}));
    }

    @Test
    @FixFor(value={"MODE-1168"})
    public void shouldUseCorrectSetterForOverloadedSimpleProperties() {
        Path configPath = (Path)this.context.getValueFactories().getPathFactory().create("/mode:system");
        this.service = new RepositoryService((RepositorySource)this.configRepositorySource, this.configWorkspaceName, configPath, this.context, this.bus, this.problems);
        this.configRepository.useWorkspace("default");
        this.configRepository.create("/mode:system").and();
        this.configRepository.create("/mode:system/mode:sources").and();
        this.configRepository.create("/mode:system/mode:sources/source A").and();
        String className = FakeRepositorySource.class.getName();
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSNAME).on("/mode:system/mode:sources/source A")).to(className);
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSPATH).on("/mode:system/mode:sources/source A")).to("");
        ((Graph.SetValuesTo)this.configRepository.set("overloadedParam").on("/mode:system/mode:sources/source A")).to("true");
        this.service.getAdministrator().start();
        RepositorySource repositorySourceA = this.service.getRepositoryLibrary().getSource("source A");
        Assert.assertThat((Object)repositorySourceA, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FakeRepositorySource.class)));
        FakeRepositorySource sourceA = (FakeRepositorySource)repositorySourceA;
        Assert.assertThat((Object)sourceA.isBooleanParam(), (Matcher)Is.is((Object)true));
    }

    @Test
    @FixFor(value={"MODE-1168"})
    public void shouldUseCorrectSetterForOverloadedObjectProperties() {
        Path configPath = (Path)this.context.getValueFactories().getPathFactory().create("/mode:system");
        this.service = new RepositoryService((RepositorySource)this.configRepositorySource, this.configWorkspaceName, configPath, this.context, this.bus, this.problems);
        this.configRepository.useWorkspace("default");
        this.configRepository.create("/mode:system").and();
        this.configRepository.create("/mode:system/mode:sources").and();
        this.configRepository.create("/mode:system/mode:sources/source A").and();
        String className = FakeRepositorySource.class.getName();
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSNAME).on("/mode:system/mode:sources/source A")).to(className);
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSPATH).on("/mode:system/mode:sources/source A")).to("");
        this.configRepository.create("/mode:system/mode:sources/source A/objectParam").and();
        className = FakeRepositorySource.StringWrapperA.class.getName();
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSNAME).on("/mode:system/mode:sources/source A/objectParam")).to(className);
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSPATH).on("/mode:system/mode:sources/source A/objectParam")).to("");
        ((Graph.SetValuesTo)this.configRepository.set("string").on("/mode:system/mode:sources/source A/objectParam")).to("test string");
        this.configRepository.create("/mode:system/mode:sources/source B").and();
        this.configRepository.create("/mode:system/mode:sources/source B/objectParam").and();
        className = FakeRepositorySource.StringWrapperB.class.getName();
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSNAME).on("/mode:system/mode:sources/source B/objectParam")).to(className);
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSPATH).on("/mode:system/mode:sources/source B/objectParam")).to("");
        ((Graph.SetValuesTo)this.configRepository.set("string").on("/mode:system/mode:sources/source B/objectParam")).to("test string");
        className = FakeRepositorySource.class.getName();
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSNAME).on("/mode:system/mode:sources/source B")).to(className);
        ((Graph.SetValuesTo)this.configRepository.set(ModeShapeLexicon.CLASSPATH).on("/mode:system/mode:sources/source B")).to("");
        ((Graph.SetValuesTo)this.configRepository.set("overloadedParam").on("/mode:system/mode:sources/source B")).to("true");
        this.service.getAdministrator().start();
        RepositorySource repositorySourceA = this.service.getRepositoryLibrary().getSource("source A");
        Assert.assertThat((Object)repositorySourceA, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FakeRepositorySource.class)));
        FakeRepositorySource sourceA = (FakeRepositorySource)repositorySourceA;
        Assert.assertThat((Object)sourceA.getStringParam(), (Matcher)Is.is((Object)"test string A"));
        RepositorySource repositorySourceB = this.service.getRepositoryLibrary().getSource("source B");
        Assert.assertThat((Object)repositorySourceB, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FakeRepositorySource.class)));
        FakeRepositorySource sourceB = (FakeRepositorySource)repositorySourceB;
        Assert.assertThat((Object)sourceB.getStringParam(), (Matcher)Is.is((Object)"test string B"));
    }
}

