/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.ArrayOperation;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.util.Util;

@SerializeWith(value=Externalizer.class)
public class AddValueOperation
extends ArrayOperation {
    protected static final int APPEND_INDEX = -1;
    protected final Object value;
    protected final int index;
    protected transient int actualIndex = -1;

    public AddValueOperation(Path path, Object value) {
        super(path);
        this.value = value;
        this.index = -1;
    }

    public AddValueOperation(Path path, Object value, int index) {
        super(path);
        this.value = value;
        this.index = index;
    }

    @Override
    public AddValueOperation clone() {
        return new AddValueOperation(this.getParentPath(), this.cloneValue(this.value), this.index);
    }

    public Object getValue() {
        return this.value;
    }

    public int getIndex() {
        return this.index;
    }

    public int getActualIndex() {
        return this.actualIndex;
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.actualIndex > -1) {
            MutableArray array = this.mutableParent(delegate);
            array.remove(this.actualIndex);
        }
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        if (this.index == -1) {
            this.actualIndex = array.addValue(this.value);
        } else {
            array.addValue(this.index, this.value);
            this.actualIndex = this.index;
        }
    }

    public String toString() {
        return "Add to '" + this.parentPath + "' the value '" + this.value + "'" + (this.index >= 0 ? " at index " + this.index : "");
    }

    public static final class Externalizer
    extends SchematicExternalizer<AddValueOperation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, AddValueOperation put) throws IOException {
            output.writeObject(put.parentPath);
            output.writeObject(put.index);
            output.writeObject(put.value);
        }

        public AddValueOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Path path = (Path)input.readObject();
            int index = input.readInt();
            Object value = input.readObject();
            return new AddValueOperation(path, value, index);
        }

        @Override
        public Integer getId() {
            return 1605;
        }

        @Override
        public Set<Class<? extends AddValueOperation>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{AddValueOperation.class});
        }
    }
}

