/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.ArrayOperation;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.util.Util;

@SerializeWith(value=Externalizer.class)
public class RetainAllValuesOperation
extends ArrayOperation {
    protected final Collection<?> values;
    protected transient List<Array.Entry> removedEntries;

    public RetainAllValuesOperation(Path parentPath, Collection<?> values) {
        super(parentPath);
        this.values = values;
    }

    @Override
    public RetainAllValuesOperation clone() {
        return new RetainAllValuesOperation(this.getParentPath(), this.cloneValues(this.values));
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.removedEntries != null) {
            MutableArray array = this.mutableParent(delegate);
            for (Array.Entry entry : this.removedEntries) {
                array.add(entry.getIndex(), entry.getValue());
            }
        }
    }

    public Collection<?> getRetainedValues() {
        return this.values;
    }

    public List<Array.Entry> getRemovedEntries() {
        return this.removedEntries;
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        this.removedEntries = array.retainAllValues(this.values);
    }

    public String toString() {
        return "Retain at '" + this.parentPath + "' the values: " + this.values;
    }

    public static final class Externalizer
    extends SchematicExternalizer<RetainAllValuesOperation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, RetainAllValuesOperation put) throws IOException {
            output.writeObject(put.parentPath);
            output.writeObject(put.values);
        }

        public RetainAllValuesOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Path path = (Path)input.readObject();
            Collection values = (Collection)input.readObject();
            return new RetainAllValuesOperation(path, values);
        }

        @Override
        public Integer getId() {
            return 1611;
        }

        @Override
        public Set<Class<? extends RetainAllValuesOperation>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{RetainAllValuesOperation.class});
        }
    }
}

