/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.Cache;
import org.infinispan.context.FlagContainer;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.internal.CacheSchemaLibrary;
import org.infinispan.schematic.internal.DocumentValidationMapper;
import org.infinispan.schematic.internal.DocumentValidationReducer;
import org.infinispan.schematic.internal.InMemoryDocumentLibrary;
import org.infinispan.schematic.internal.SchematicEntryLiteral;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFuture;

public class CacheSchematicDb
implements SchematicDb {
    private final String name;
    private final Cache<String, SchematicEntry> store;
    private final AtomicReference<CacheSchemaLibrary> schemaLibrary = new AtomicReference();
    private final String schemaCacheName;
    private String defaultContentTypeForDocument;
    private String defaultContentTypeForBinary;
    private String defaultSchemaUri;
    private String description;

    public CacheSchematicDb(Cache<String, SchematicEntry> store) {
        this.name = store.getName();
        this.store = store;
        String defaultContentTypeForDocs = "application/json";
        String defaultContentTypeForBinary = "application/octet-stream";
        String defaultSchemaUri = "http://json-schema.org/draft-03/schema#";
        String description = "";
        String schemaCacheName = store.getName() + "Schemas";
        SchematicEntry databaseDocument = (SchematicEntry)store.get((Object)"");
        if (databaseDocument != null && databaseDocument.hasDocumentContent()) {
            Document dbDoc = databaseDocument.getContentAsDocument();
            defaultContentTypeForDocs = dbDoc.getString("defaultContentTypeForDocuments", defaultContentTypeForDocs);
            defaultContentTypeForBinary = dbDoc.getString("defaultContentTypeForBinary", defaultContentTypeForBinary);
            defaultSchemaUri = dbDoc.getString("defaultSchemaUri", defaultSchemaUri);
            description = dbDoc.getString("description", description);
            schemaCacheName = dbDoc.getString("schemaCacheName", schemaCacheName);
        }
        this.defaultContentTypeForBinary = defaultContentTypeForBinary;
        this.defaultContentTypeForDocument = defaultContentTypeForDocs;
        this.defaultSchemaUri = defaultSchemaUri;
        this.description = description;
        this.schemaCacheName = schemaCacheName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Cache<String, SchematicEntry> getCache() {
        return this.store;
    }

    public void start() {
        this.store.start();
    }

    public void stop() {
        this.store.stop();
        CacheSchemaLibrary schemaLibrary = this.schemaLibrary(false);
        if (schemaLibrary != null) {
            schemaLibrary.stop();
        }
    }

    @Override
    public SchemaLibrary getSchemaLibrary() {
        return this.schemaLibrary(true);
    }

    protected CacheSchemaLibrary schemaLibrary(boolean createIfMissing) {
        CacheSchemaLibrary schemaLibrary = this.schemaLibrary.get();
        if (schemaLibrary == null && createIfMissing) {
            Cache schemaStore = this.store.getCacheManager().getCache(this.schemaCacheName);
            schemaLibrary = new CacheSchemaLibrary((Cache<String, SchematicEntry>)schemaStore);
            if (this.schemaLibrary.compareAndSet(null, schemaLibrary)) {
                schemaLibrary.start();
            } else {
                schemaLibrary = this.schemaLibrary.get();
            }
        }
        return schemaLibrary;
    }

    @Override
    public Map<String, SchemaLibrary.Results> validateAll() {
        CacheSchemaLibrary schemaLibrary = this.schemaLibrary(true);
        if (this.store.getAdvancedCache().getRpcManager() == null) {
            DocumentValidationMapper mapper = new DocumentValidationMapper(schemaLibrary, this.defaultSchemaUri);
            ResultsCollector resultsCollector = new ResultsCollector();
            for (Map.Entry entry : this.store.entrySet()) {
                String key = (String)entry.getKey();
                SchematicEntry value = (SchematicEntry)entry.getValue();
                mapper.map(key, value, resultsCollector);
            }
            return resultsCollector.getResultsByKey();
        }
        InMemoryDocumentLibrary schemaDocs = new InMemoryDocumentLibrary(schemaLibrary.getName());
        for (Map.Entry entry : schemaLibrary.store().entrySet()) {
            String key = (String)entry.getKey();
            SchematicEntry value = (SchematicEntry)entry.getValue();
            schemaDocs.put(key, value.getContentAsDocument());
        }
        MapReduceTask task = new MapReduceTask(this.store);
        task.mappedWith((Mapper)new DocumentValidationMapper(schemaDocs, this.defaultSchemaUri));
        task.reducedWith((Reducer)new DocumentValidationReducer());
        return task.execute();
    }

    @Override
    public Map<String, SchemaLibrary.Results> validate(String firstKey, String ... additionalKeys) {
        HashMap<String, SchemaLibrary.Results> resultsByKey = new HashMap<String, SchemaLibrary.Results>();
        SchemaLibrary.Results results = this.validate(firstKey);
        if (results != null && results.hasProblems()) {
            resultsByKey.put(firstKey, results);
        }
        for (String key : additionalKeys) {
            results = this.validate(key);
            if (results == null || !results.hasProblems()) continue;
            resultsByKey.put(key, results);
        }
        return resultsByKey;
    }

    @Override
    public SchemaLibrary.Results validate(String key) {
        SchematicEntry entry = (SchematicEntry)this.store.get((Object)key);
        if (entry != null) {
            DocumentValidationMapper mapper = new DocumentValidationMapper(this.schemaLibrary(true), this.defaultSchemaUri);
            return mapper.validate(key, entry);
        }
        return null;
    }

    protected SchematicEntry proxy(String key, SchematicEntry entry) {
        if (entry == null) {
            return null;
        }
        SchematicEntryLiteral literal = (SchematicEntryLiteral)entry;
        FlagContainer flagContainer = null;
        return literal.getProxy(this.store, key, flagContainer);
    }

    protected SchematicEntry removedResult(String key, SchematicEntry entry) {
        SchematicEntryLiteral literal = (SchematicEntryLiteral)entry;
        literal.markRemoved(true);
        return this.proxy(key, literal);
    }

    protected SchematicEntryProxyFuture future(String key, NotifyingFuture<SchematicEntry> future, boolean isRemoved) {
        return new SchematicEntryProxyFuture(future, key, isRemoved);
    }

    @Override
    public SchematicEntry get(String key) {
        return this.proxy(key, (SchematicEntry)this.store.get((Object)key));
    }

    @Override
    public boolean containsKey(String key) {
        return this.store.containsKey((Object)key);
    }

    @Override
    public SchematicEntry put(String key, Document document, Document metadata) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key);
        newEntry.setContent(document, metadata, this.defaultContentTypeForDocument);
        SchematicEntry oldValue = (SchematicEntry)this.store.put((Object)key, (Object)newEntry);
        return oldValue != null ? this.removedResult(key, oldValue) : null;
    }

    @Override
    public SchematicEntry put(String key, Binary binaryContent, Document metadata) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key);
        newEntry.setContent(binaryContent, metadata, this.defaultContentTypeForBinary);
        SchematicEntry oldValue = (SchematicEntry)this.store.put((Object)key, (Object)newEntry);
        return oldValue != null ? this.removedResult(key, oldValue) : null;
    }

    @Override
    public SchematicEntry putIfAbsent(String key, Document document, Document metadata) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key);
        newEntry.setContent(document, metadata, this.defaultContentTypeForDocument);
        SchematicEntry existingEntry = (SchematicEntry)this.store.putIfAbsent((Object)key, (Object)newEntry);
        if (existingEntry == null) {
            return null;
        }
        return this.proxy(key, existingEntry);
    }

    @Override
    public SchematicEntry putIfAbsent(String key, Binary binaryContent, Document metadata) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key);
        newEntry.setContent(binaryContent, metadata, this.defaultContentTypeForBinary);
        SchematicEntry existingEntry = (SchematicEntry)this.store.putIfAbsent((Object)key, (Object)newEntry);
        if (existingEntry == null) {
            return null;
        }
        return this.proxy(key, existingEntry);
    }

    @Override
    public SchematicEntry replace(String key, Document document, Document metadata) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key);
        newEntry.setContent(document, metadata, this.defaultContentTypeForDocument);
        return this.removedResult(key, (SchematicEntry)this.store.replace((Object)key, (Object)newEntry));
    }

    @Override
    public SchematicEntry replace(String key, Binary binaryContent, Document metadata) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key);
        newEntry.setContent(binaryContent, metadata, this.defaultContentTypeForBinary);
        return this.removedResult(key, (SchematicEntry)this.store.replace((Object)key, (Object)newEntry));
    }

    @Override
    public SchematicEntry remove(String key) {
        return this.removedResult(key, (SchematicEntry)this.store.remove((Object)key));
    }

    @Override
    public NotifyingFuture<SchematicEntry> getAsync(String key) {
        return this.future(key, (NotifyingFuture<SchematicEntry>)this.store.getAsync((Object)key), false);
    }

    @Override
    public NotifyingFuture<SchematicEntry> putAsync(String key, Document document, Document metadata) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key);
        newEntry.setContent(document, metadata, this.defaultContentTypeForDocument);
        return this.future(key, (NotifyingFuture<SchematicEntry>)this.store.putAsync((Object)key, (Object)newEntry), true);
    }

    @Override
    public NotifyingFuture<SchematicEntry> putAsync(String key, Binary binaryContent, Document metadata) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key);
        newEntry.setContent(binaryContent, metadata, this.defaultContentTypeForBinary);
        return this.future(key, (NotifyingFuture<SchematicEntry>)this.store.putAsync((Object)key, (Object)newEntry), true);
    }

    @Override
    public NotifyingFuture<SchematicEntry> putIfAbsentAsync(String key, Document document, Document metadata) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key);
        newEntry.setContent(document, metadata, this.defaultContentTypeForDocument);
        return this.future(key, (NotifyingFuture<SchematicEntry>)this.store.putIfAbsentAsync((Object)key, (Object)newEntry), true);
    }

    @Override
    public NotifyingFuture<SchematicEntry> putIfAbsentAsync(String key, Binary binaryContent, Document metadata) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key);
        newEntry.setContent(binaryContent, metadata, this.defaultContentTypeForBinary);
        return this.future(key, (NotifyingFuture<SchematicEntry>)this.store.putIfAbsentAsync((Object)key, (Object)newEntry), true);
    }

    @Override
    public NotifyingFuture<SchematicEntry> replaceAsync(String key, Document document, Document metadata) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key);
        newEntry.setContent(document, metadata, this.defaultContentTypeForDocument);
        return this.future(key, (NotifyingFuture<SchematicEntry>)this.store.replaceAsync((Object)key, (Object)newEntry), true);
    }

    @Override
    public NotifyingFuture<SchematicEntry> replaceAsync(String key, Binary binaryContent, Document metadata) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key);
        newEntry.setContent(binaryContent, metadata, this.defaultContentTypeForBinary);
        return this.future(key, (NotifyingFuture<SchematicEntry>)this.store.replaceAsync((Object)key, (Object)newEntry), true);
    }

    @Override
    public NotifyingFuture<SchematicEntry> removeAsync(String key) {
        return this.future(key, (NotifyingFuture<SchematicEntry>)this.store.removeAsync((Object)key), true);
    }

    protected class SchematicEntryProxyFuture
    implements NotifyingFuture<SchematicEntry> {
        private final NotifyingFuture<SchematicEntry> original;
        private final String key;
        private final boolean isRemoved;

        protected SchematicEntryProxyFuture(NotifyingFuture<SchematicEntry> original, String key, boolean isRemoved) {
            this.original = original;
            this.key = key;
            this.isRemoved = isRemoved;
        }

        public NotifyingFuture<SchematicEntry> attachListener(FutureListener<SchematicEntry> listener) {
            this.original.attachListener(listener);
            return this;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.original.cancel(mayInterruptIfRunning);
        }

        public SchematicEntry get() throws InterruptedException, ExecutionException {
            SchematicEntry result = (SchematicEntry)this.original.get();
            return this.isRemoved ? CacheSchematicDb.this.removedResult(this.key, result) : CacheSchematicDb.this.proxy(this.key, result);
        }

        public SchematicEntry get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            SchematicEntry result = (SchematicEntry)this.original.get(timeout, unit);
            return this.isRemoved ? CacheSchematicDb.this.removedResult(this.key, result) : CacheSchematicDb.this.proxy(this.key, result);
        }

        public boolean isCancelled() {
            return this.original.isCancelled();
        }

        public boolean isDone() {
            return this.original.isDone();
        }
    }

    protected static class ResultsCollector
    implements Collector<String, SchemaLibrary.Results> {
        private final Map<String, SchemaLibrary.Results> resultsByKey = new HashMap<String, SchemaLibrary.Results>();

        protected ResultsCollector() {
        }

        public void emit(String key, SchemaLibrary.Results value) {
            this.resultsByKey.put(key, value);
        }

        public Map<String, SchemaLibrary.Results> getResultsByKey() {
            return this.resultsByKey;
        }
    }
}

