/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.batch.AutoBatchSupport;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.FlagContainer;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.internal.SchematicEntryLiteral;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SchematicEntryProxy
extends AutoBatchSupport
implements SchematicEntry {
    private static final Log log = LogFactory.getLog(SchematicEntryProxy.class);
    private static final boolean trace = log.isTraceEnabled();
    final AdvancedCache<String, SchematicEntry> cache;
    final String key;
    final FlagContainer flagContainer;
    protected TransactionTable transactionTable;
    protected TransactionManager transactionManager;
    volatile boolean startedReadingValue = false;

    SchematicEntryProxy(AdvancedCache<String, SchematicEntry> cache, String key, FlagContainer flagContainer) {
        this.key = key;
        this.cache = cache;
        this.batchContainer = cache.getBatchContainer();
        this.flagContainer = flagContainer;
        this.transactionTable = (TransactionTable)cache.getComponentRegistry().getComponent(TransactionTable.class);
        this.transactionManager = cache.getTransactionManager();
    }

    protected SchematicEntryLiteral toValue(Object object) {
        Object value = object instanceof MarshalledValue ? ((MarshalledValue)object).get() : object;
        return (SchematicEntryLiteral)value;
    }

    private void assertValid(SchematicEntryLiteral value) {
        if (this.startedReadingValue && (value == null || value.removed)) {
            throw new IllegalStateException("SchematicValue stored under key " + this.key + " has been concurrently removed!");
        }
    }

    protected CacheEntry lookupEntryFromCurrentTransaction() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            LocalTransaction localTransaction = tx == null ? null : this.transactionTable.getLocalTransaction(tx);
            return localTransaction == null ? null : localTransaction.lookupEntry((Object)this.key);
        }
        catch (SystemException e) {
            return null;
        }
    }

    private SchematicEntryLiteral getDeltaValueForRead() {
        SchematicEntryLiteral value = this.toValue(this.cache.get((Object)this.key));
        if (value != null && !this.startedReadingValue) {
            this.startedReadingValue = true;
        }
        this.assertValid(value);
        return value;
    }

    private SchematicEntryLiteral getDeltaValueForWrite() {
        SchematicEntryLiteral value;
        boolean suppressLocks;
        boolean lockedAndCopied;
        CacheEntry lookedUpEntry = this.lookupEntryFromCurrentTransaction();
        boolean bl = lockedAndCopied = lookedUpEntry != null && lookedUpEntry.isChanged() && this.toValue((Object)lookedUpEntry.getValue()).copied;
        if (lockedAndCopied) {
            return this.getDeltaValueForRead();
        }
        boolean bl2 = suppressLocks = this.flagContainer != null && this.flagContainer.hasFlag(Flag.SKIP_LOCKING);
        if (!suppressLocks && this.flagContainer != null) {
            this.flagContainer.setFlags(new Flag[]{Flag.FORCE_WRITE_LOCK});
        }
        if (trace) {
            if (suppressLocks) {
                log.trace((Object)"Skip locking flag used.  Skipping locking.");
            } else {
                log.trace((Object)"Forcing write lock even for reads");
            }
        }
        SchematicEntryLiteral copy = (value = this.getDeltaValueForRead()) == null ? new SchematicEntryLiteral(this.key, true) : value.copyForWrite();
        copy.initForWriting();
        if (suppressLocks) {
            this.flagContainer.setFlags(new Flag[]{Flag.SKIP_LOCKING});
        }
        this.cache.put((Object)this.key, (Object)copy);
        return copy;
    }

    @Override
    public Document getMetadata() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getMetadata();
    }

    @Override
    public String getContentType() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getContentType();
    }

    @Override
    public Object getContent() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getContent();
    }

    @Override
    public Document getContentAsDocument() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getContentAsDocument();
    }

    @Override
    public Binary getContentAsBinary() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.getContentAsBinary();
    }

    @Override
    public boolean hasDocumentContent() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.hasDocumentContent();
    }

    @Override
    public boolean hasBinaryContent() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.hasBinaryContent();
    }

    @Override
    public Document asDocument() {
        SchematicEntryLiteral value = this.getDeltaValueForRead();
        return value.asDocument();
    }

    public String toString() {
        return "SchematicValueProxy{key=" + this.key + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(Binary content, Document metadata, String defaultContentType) {
        try {
            this.startAtomic();
            this.getDeltaValueForWrite().setContent(content, metadata, defaultContentType);
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(Document content, Document metadata, String defaultContentType) {
        try {
            this.startAtomic();
            this.getDeltaValueForWrite().setContent(content, metadata, defaultContentType);
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EditableDocument editDocumentContent() {
        try {
            this.startAtomic();
            EditableDocument editableDocument = this.getDeltaValueForWrite().editDocumentContent();
            return editableDocument;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EditableDocument editMetadata() {
        try {
            this.startAtomic();
            EditableDocument editableDocument = this.getDeltaValueForWrite().editMetadata();
            return editableDocument;
        }
        finally {
            this.endAtomic();
        }
    }
}

