/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.container.versioning.EntryVersion;

public class InternalEntryFactoryImpl
implements InternalEntryFactory {
    @Override
    public InternalCacheEntry create(Object key, Object value, EntryVersion ignored) {
        return new ImmortalCacheEntry(key, value);
    }

    @Override
    public InternalCacheEntry create(CacheEntry cacheEntry) {
        return this.create(cacheEntry.getKey(), cacheEntry.getValue(), cacheEntry.getVersion(), cacheEntry.getLifespan(), cacheEntry.getMaxIdle());
    }

    @Override
    public InternalCacheEntry create(Object key, Object value, InternalCacheEntry cacheEntry) {
        return this.create(key, value, cacheEntry.getVersion(), cacheEntry.getCreated(), cacheEntry.getLifespan(), cacheEntry.getLastUsed(), cacheEntry.getMaxIdle());
    }

    @Override
    public InternalCacheEntry create(Object key, Object value, EntryVersion ignored, long created, long lifespan, long lastUsed, long maxIdle) {
        if (lifespan < 0L && maxIdle < 0L) {
            return new ImmortalCacheEntry(key, value);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MortalCacheEntry(key, value, lifespan, created);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new TransientCacheEntry(key, value, maxIdle, lastUsed);
        }
        return new TransientMortalCacheEntry(key, value, maxIdle, lifespan, lastUsed, created);
    }

    @Override
    public InternalCacheValue createValue(CacheEntry cacheEntry) {
        long lifespan = cacheEntry.getLifespan();
        long maxIdle = cacheEntry.getMaxIdle();
        if (lifespan < 0L && maxIdle < 0L) {
            return new ImmortalCacheValue(cacheEntry.getValue());
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MortalCacheValue(cacheEntry.getValue(), -1L, lifespan);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new TransientCacheValue(cacheEntry.getValue(), maxIdle, -1L);
        }
        return new TransientMortalCacheValue(cacheEntry.getValue(), -1L, lifespan, maxIdle, -1L);
    }

    @Override
    public InternalCacheEntry create(Object key, Object value, EntryVersion ignored, long lifespan, long maxIdle) {
        if (lifespan < 0L && maxIdle < 0L) {
            return new ImmortalCacheEntry(key, value);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MortalCacheEntry(key, value, lifespan);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new TransientCacheEntry(key, value, maxIdle);
        }
        return new TransientMortalCacheEntry(key, value, maxIdle, lifespan);
    }

    @Override
    public InternalCacheEntry update(InternalCacheEntry ice, long lifespan, long maxIdle) {
        if (ice instanceof ImmortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return ice;
                }
                return new TransientCacheEntry(ice.getKey(), ice.getValue(), maxIdle);
            }
            if (maxIdle < 0L) {
                return new MortalCacheEntry(ice.getKey(), ice.getValue(), lifespan);
            }
            long ctm = System.currentTimeMillis();
            return new TransientMortalCacheEntry(ice.getKey(), ice.getValue(), maxIdle, lifespan, ctm, ctm);
        }
        if (ice instanceof MortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new ImmortalCacheEntry(ice.getKey(), ice.getValue());
                }
                return new TransientCacheEntry(ice.getKey(), ice.getValue(), maxIdle);
            }
            if (maxIdle < 0L) {
                ice.setLifespan(lifespan);
                return ice;
            }
            long ctm = System.currentTimeMillis();
            return new TransientMortalCacheEntry(ice.getKey(), ice.getValue(), maxIdle, lifespan, ctm, ctm);
        }
        if (ice instanceof TransientCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new ImmortalCacheEntry(ice.getKey(), ice.getValue());
                }
                ice.setMaxIdle(maxIdle);
                return ice;
            }
            if (maxIdle < 0L) {
                return new MortalCacheEntry(ice.getKey(), ice.getValue(), lifespan);
            }
            long ctm = System.currentTimeMillis();
            return new TransientMortalCacheEntry(ice.getKey(), ice.getValue(), maxIdle, lifespan, ctm, ctm);
        }
        if (ice instanceof TransientMortalCacheEntry) {
            if (lifespan < 0L) {
                if (maxIdle < 0L) {
                    return new ImmortalCacheEntry(ice.getKey(), ice.getValue());
                }
                return new TransientCacheEntry(ice.getKey(), ice.getValue(), maxIdle);
            }
            if (maxIdle < 0L) {
                return new MortalCacheEntry(ice.getKey(), ice.getValue(), lifespan);
            }
            ice.setLifespan(lifespan);
            ice.setMaxIdle(maxIdle);
            return ice;
        }
        return ice;
    }
}

