/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.util.concurrent.locks.containers.AbstractPerEntryLockContainer;

public class ReentrantPerEntryLockContainer
extends AbstractPerEntryLockContainer<ReentrantLock> {
    public ReentrantPerEntryLockContainer(int concurrencyLevel) {
        super(concurrencyLevel);
    }

    @Override
    protected ReentrantLock newLock() {
        return new ReentrantLock();
    }

    @Override
    public boolean ownsLock(Object key, Object ignored) {
        ReentrantLock l = this.getLockFromMap(key);
        return l != null && l.isHeldByCurrentThread();
    }

    @Override
    public boolean isLocked(Object key) {
        ReentrantLock l = this.getLockFromMap(key);
        return l != null && l.isLocked();
    }

    private ReentrantLock getLockFromMap(Object key) {
        return (ReentrantLock)this.locks.get(key);
    }

    @Override
    protected void unlock(ReentrantLock l, Object unused) {
        l.unlock();
    }

    @Override
    protected boolean tryLock(ReentrantLock lock, long timeout, TimeUnit unit, Object unused) throws InterruptedException {
        return lock.tryLock(timeout, unit);
    }
}

