/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.MaxKey;
import org.infinispan.schematic.document.MinKey;
import org.infinispan.schematic.document.ThreadSafe;
import org.infinispan.schematic.internal.document.BasicArray;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.schematic.internal.document.DefaultDocumentValueFactory;
import org.infinispan.schematic.internal.document.DocumentValueFactory;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.schematic.internal.io.BsonDataInput;

@ThreadSafe
public class BsonReader {
    protected static final DocumentValueFactory VALUE_FACTORY = new DefaultDocumentValueFactory();

    public Document read(InputStream stream) throws IOException {
        DocumentValueFactory valueFactory = VALUE_FACTORY;
        Reader reader = new Reader(new BsonDataInput(new DataInputStream(stream)), valueFactory);
        reader.startDocument();
        return reader.endDocument();
    }

    public Document read(DataInput input) throws IOException {
        DocumentValueFactory valueFactory = VALUE_FACTORY;
        Reader reader = new Reader(new BsonDataInput(input), valueFactory);
        reader.startDocument();
        return reader.endDocument();
    }

    protected static class Reader {
        private final BsonDataInput data;
        private MutableDocument object;
        private DocumentValueFactory values;

        protected Reader(BsonDataInput data, DocumentValueFactory valueFactory) {
            this.data = data;
            this.values = valueFactory;
        }

        protected void startDocument() throws IOException {
            this.object = this.readDocument(false);
        }

        protected MutableDocument readDocument(boolean array) throws IOException {
            byte type;
            MutableDocument doc;
            int length = this.data.readInt();
            int startingIndex = this.data.getTotalBytesRead();
            int endingIndex = startingIndex + length;
            MutableDocument mutableDocument = doc = array ? new BasicArray() : new BasicDocument();
            while (this.data.getTotalBytesRead() < endingIndex && (type = this.data.readByte()) != 0) {
                this.readElement(type, doc);
            }
            return doc;
        }

        protected void readElement(byte type, MutableDocument bson) throws IOException {
            String name = this.readCString();
            Object value = null;
            switch (type) {
                case 4: {
                    value = this.readDocument(true);
                    break;
                }
                case 5: {
                    int length = this.data.readInt();
                    byte subtype = this.data.readByte();
                    if (subtype == 3) {
                        long mostSig = this.data.readLong();
                        long leastSig = this.data.readLong();
                        value = new UUID(mostSig, leastSig);
                        break;
                    }
                    byte[] bytes = new byte[length];
                    this.data.readFully(bytes);
                    value = this.values.createBinary(subtype, bytes);
                    break;
                }
                case 8: {
                    value = this.values.createBoolean(this.data.readBoolean());
                    break;
                }
                case 9: {
                    value = this.values.createDate(this.data.readLong());
                    break;
                }
                case 12: {
                    break;
                }
                case 3: {
                    value = this.readDocument(false);
                    break;
                }
                case 1: {
                    value = this.values.createDouble(this.data.readDouble());
                    break;
                }
                case 16: {
                    value = this.values.createInt(this.data.readInt());
                    break;
                }
                case 18: {
                    value = this.values.createLong(this.data.readLong());
                    break;
                }
                case 13: {
                    value = this.values.createCode(this.readString());
                    break;
                }
                case 15: {
                    this.data.readInt();
                    String code = this.readString();
                    MutableDocument scope = this.readDocument(false);
                    value = this.values.createCode(code, scope);
                    break;
                }
                case 127: {
                    value = MaxKey.getInstance();
                    break;
                }
                case -1: {
                    value = MinKey.getInstance();
                    break;
                }
                case 10: {
                    value = this.values.createNull();
                    break;
                }
                case 7: {
                    byte[] objectIdBytes = new byte[12];
                    this.data.readFully(objectIdBytes);
                    value = this.values.createObjectId(objectIdBytes);
                    break;
                }
                case 11: {
                    value = this.values.createRegex(this.readCString(), this.readCString());
                    break;
                }
                case 2: {
                    value = this.readString();
                    break;
                }
                case 14: {
                    value = this.readString();
                    break;
                }
                case 17: {
                    int inc = this.data.readInt();
                    int time = this.data.readInt();
                    value = this.values.createTimestamp(time, inc);
                    break;
                }
            }
            bson.put(name, value);
        }

        protected String readCString() throws IOException {
            return this.data.readUTF(-1);
        }

        protected String readString() throws IOException {
            int length = this.data.readInt();
            String result = this.values.createString(this.data.readUTF(length - 1));
            this.data.readByte();
            return result;
        }

        protected Document endDocument() {
            return this.object;
        }
    }
}

