/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.write.EvictCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;

@MBean(objectName="Passivation", description="Component that handles passivating entries to a CacheStore on eviction.")
public class PassivationInterceptor
extends JmxStatsCommandInterceptor {
    PassivationManager passivator;
    DataContainer dataContainer;
    private static final Log log = LogFactory.getLog(PassivationInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void setDependencies(PassivationManager passivator, DataContainer dataContainer) {
        this.passivator = passivator;
        this.dataContainer = dataContainer;
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        Object key = command.getKey();
        this.passivator.passivate(this.dataContainer.get(key));
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component")
    @Operation(displayName="Reset statistics")
    public void resetStatistics() {
        this.passivator.resetPassivationCount();
    }

    @ManagedAttribute(description="Number of passivation events")
    @Metric(displayName="Number of cache passivations", measurementType=MeasurementType.TRENDSUP)
    public String getPassivations() {
        if (!this.getStatisticsEnabled()) {
            return "N/A";
        }
        return String.valueOf(this.passivator.getPassivationCount());
    }
}

