/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.delta.AddValueIfAbsentOperation;
import org.infinispan.schematic.internal.delta.AddValueOperation;
import org.infinispan.schematic.internal.delta.ClearOperation;
import org.infinispan.schematic.internal.delta.DocumentObserver;
import org.infinispan.schematic.internal.delta.RemoveAllValuesOperation;
import org.infinispan.schematic.internal.delta.RemoveAtIndexOperation;
import org.infinispan.schematic.internal.delta.RemoveValueOperation;
import org.infinispan.schematic.internal.delta.RetainAllValuesOperation;
import org.infinispan.schematic.internal.delta.SetValueOperation;
import org.infinispan.schematic.internal.document.ArrayEditor;
import org.infinispan.schematic.internal.document.DocumentValueFactory;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.schematic.internal.document.ObservableDocumentEditor;

public class ObservableArrayEditor
extends ArrayEditor {
    private static final long serialVersionUID = 1L;
    private final Path path;
    private final DocumentObserver observer;

    public ObservableArrayEditor(MutableArray array, Path path, DocumentObserver observer, DocumentValueFactory factory) {
        super(array, factory);
        this.path = path;
        this.observer = observer;
    }

    protected Collection<? extends Object> unwrapValues(Collection<?> c) {
        if (c == null || c.isEmpty()) {
            return c;
        }
        if (c instanceof Set) {
            HashSet<Object> replaced = null;
            Set result = (Set)c;
            Iterator<?> iterator = c.iterator();
            while (iterator.hasNext()) {
                Object unwrapped;
                Object orig = iterator.next();
                if (orig == (unwrapped = ObservableArrayEditor.unwrap(orig))) continue;
                iterator.remove();
                if (replaced == null) {
                    replaced = new HashSet<Object>();
                }
                replaced.add(unwrapped);
            }
            if (replaced != null) {
                result.addAll(replaced);
            }
            return result;
        }
        if (c instanceof List) {
            List result = (List)c;
            ListIterator<Object> iter = result.listIterator();
            while (iter.hasNext()) {
                Object unwrapped;
                Object e = iter.next();
                if (e == (unwrapped = ObservableArrayEditor.unwrap(e))) continue;
                iter.set(unwrapped);
            }
            return result;
        }
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object e : result) {
            Object unwrapped = ObservableArrayEditor.unwrap(e);
            result.add(unwrapped);
        }
        return result;
    }

    @Override
    protected boolean doAddAll(Collection<? extends Object> c) {
        return this.doAddAll(this.size(), c);
    }

    @Override
    protected boolean doAddAll(int index, Collection<? extends Object> c) {
        if (super.doAddAll(index, c = this.unwrapValues(c))) {
            for (Object object : c) {
                Object object2 = ObservableArrayEditor.unwrap(object);
                this.observer.addOperation(new AddValueOperation(this.path, object2));
            }
            return true;
        }
        return false;
    }

    @Override
    protected void doAddValue(int index, Object value) {
        value = ObservableArrayEditor.unwrap(value);
        super.doAddValue(index, value);
        this.observer.addOperation(new AddValueOperation(this.path, value, index));
    }

    @Override
    protected int doAddValue(Object value) {
        value = ObservableArrayEditor.unwrap(value);
        int index = super.doAddValue(value);
        this.observer.addOperation(new AddValueOperation(this.path, value));
        return index;
    }

    @Override
    protected boolean doAddValueIfAbsent(Object value) {
        if (super.doAddValueIfAbsent(value = ObservableArrayEditor.unwrap(value))) {
            this.observer.addOperation(new AddValueIfAbsentOperation(this.path, value));
            return true;
        }
        return false;
    }

    @Override
    protected void doClear() {
        super.doClear();
        this.observer.addOperation(new ClearOperation(this.path));
    }

    @Override
    protected List<Array.Entry> doRemoveAll(Collection<?> c) {
        c = this.unwrapValues(c);
        List<Array.Entry> removed = super.doRemoveAll(c);
        this.observer.addOperation(new RemoveAllValuesOperation(this.path, c));
        return removed;
    }

    @Override
    protected Object doRemoveValue(int index) {
        Object removed = super.doRemoveValue(index);
        if (removed != null) {
            this.observer.addOperation(new RemoveAtIndexOperation(this.path, index));
        }
        return removed;
    }

    @Override
    protected boolean doRemoveValue(Object value) {
        if (super.doRemoveValue(value = ObservableArrayEditor.unwrap(value))) {
            this.observer.addOperation(new RemoveValueOperation(this.path, value));
        }
        return false;
    }

    @Override
    protected List<Array.Entry> doRetainAll(Collection<?> c) {
        c = this.unwrapValues(c);
        List<Array.Entry> removed = super.doRetainAll(c);
        this.observer.addOperation(new RetainAllValuesOperation(this.path, c));
        return removed;
    }

    @Override
    protected Object doSetValue(int index, Object value) {
        value = ObservableArrayEditor.unwrap(value);
        Object oldValue = super.doSetValue(index, value);
        this.observer.addOperation(new SetValueOperation(this.path, value, index));
        return oldValue;
    }

    @Override
    protected EditableDocument createEditableDocument(MutableDocument document, int index, DocumentValueFactory factory) {
        return new ObservableDocumentEditor(document, this.path.with(Integer.toString(index)), this.observer, factory);
    }

    @Override
    protected EditableArray createEditableArray(MutableArray array, int index, DocumentValueFactory factory) {
        return new ObservableArrayEditor(array, this.path.with(Integer.toString(index)), this.observer, factory);
    }

    @Override
    protected EditableArray createEditableSublist(MutableArray array, DocumentValueFactory factory) {
        return new ObservableArrayEditor(array, this.path, this.observer, factory);
    }
}

