/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.internal.SchematicDelta;
import org.infinispan.schematic.internal.SchematicEntryLiteral;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.Operation;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@SerializeWith(value=Externalizer.class)
public class SchematicEntryWholeDelta
implements SchematicDelta {
    private static final Log LOG = LogFactory.getLog(SchematicEntryWholeDelta.class);
    private static final boolean TRACE = LOG.isTraceEnabled();
    private final Document document;

    protected SchematicEntryWholeDelta(Document document) {
        this.document = document;
    }

    public DeltaAware merge(DeltaAware d) {
        SchematicEntryLiteral other = null;
        try {
            if (d != null && d instanceof SchematicEntryLiteral) {
                other = (SchematicEntryLiteral)d;
                other.setDocument(this.document);
                LOG.trace((Object)("Merging whole doc delta into existing literal, resulting in " + other));
            } else {
                other = new SchematicEntryLiteral((MutableDocument)this.document);
                LOG.trace((Object)("Merging whole doc delta into new " + other));
            }
        }
        catch (RuntimeException e) {
            LOG.debug((Object)("Exception while merging delta " + this + " onto " + d), (Throwable)e);
            throw e;
        }
        finally {
            if (other != null) {
                other.commit();
            }
        }
        return other;
    }

    @Override
    public boolean isRecordingOperations() {
        return false;
    }

    @Override
    public void addOperation(Operation o) {
    }

    public String toString() {
        return "SchematicEntryWholeDelta" + this.document;
    }

    public int hashCode() {
        return this.document.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SchematicEntryWholeDelta) {
            SchematicEntryWholeDelta other = (SchematicEntryWholeDelta)obj;
            return this.document.equals(other.document);
        }
        return false;
    }

    public static class Externalizer
    extends SchematicExternalizer<SchematicEntryWholeDelta> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, SchematicEntryWholeDelta delta) throws IOException {
            if (TRACE) {
                LOG.tracef("Serializing delta as document %s", (Object)delta.document);
            }
            output.writeObject(delta.document);
        }

        public SchematicEntryWholeDelta readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Document document = (Document)input.readObject();
            SchematicEntryWholeDelta delta = new SchematicEntryWholeDelta(document);
            if (TRACE) {
                LOG.tracef("Deserialized delta as document %s", (Object)delta.document);
            }
            return delta;
        }

        @Override
        public Integer getId() {
            return 1625;
        }

        @Override
        public Set<Class<? extends SchematicEntryWholeDelta>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{SchematicEntryWholeDelta.class});
        }
    }
}

