/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.DefaultRetransmitter;
import org.jgroups.stack.Interval;
import org.jgroups.stack.Retransmitter;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.TimeScheduler;

public class AckSenderWindow
implements Retransmitter.RetransmitCommand {
    private RetransmitCommand retransmit_command = null;
    private final ConcurrentNavigableMap<Long, Message> msgs = new ConcurrentSkipListMap<Long, Message>();
    private Interval interval = new StaticInterval(400, 800, 1200, 1600);
    private final DefaultRetransmitter retransmitter;
    private long lowest = 1L;
    private long highest = 0L;

    public AckSenderWindow(RetransmitCommand com) {
        this.retransmit_command = com;
        this.retransmitter = new DefaultRetransmitter(null, this, null);
        this.retransmitter.setRetransmitTimeouts(this.interval);
    }

    public AckSenderWindow(RetransmitCommand com, Interval interval, TimeScheduler sched) {
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter = new DefaultRetransmitter(null, this, sched);
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public AckSenderWindow(RetransmitCommand com, Interval interval, TimeScheduler sched, Address sender) {
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter = new DefaultRetransmitter(sender, this, sched);
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public AckSenderWindow() {
        this.retransmitter = null;
    }

    public synchronized long getLowest() {
        return this.lowest;
    }

    public long getHighest() {
        return this.highest;
    }

    public void reset() {
        this.msgs.clear();
        if (this.retransmitter != null) {
            this.retransmitter.reset();
        }
        this.lowest = 1L;
    }

    public Message get(long seqno) {
        return (Message)this.msgs.get(seqno);
    }

    public void add(long seqno, Message msg) {
        this.msgs.putIfAbsent(seqno, msg);
        if (this.retransmitter != null) {
            this.retransmitter.add(seqno, seqno);
        }
        this.highest = Math.max(this.highest, seqno);
    }

    public void addToMessages(long seqno, Message msg) {
        this.msgs.putIfAbsent(seqno, msg);
        this.highest = Math.max(this.highest, seqno);
    }

    public void addToRetransmitter(long seqno) {
        if (this.retransmitter != null) {
            this.retransmitter.add(seqno, seqno);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(long seqno) {
        AckSenderWindow ackSenderWindow = this;
        synchronized (ackSenderWindow) {
            if (seqno < this.lowest) {
                return;
            }
            this.lowest = Math.max(this.lowest, seqno + 1L);
        }
        this.removeRange(seqno);
    }

    public synchronized Message getLowestMessage() {
        return (Message)this.msgs.get(this.lowest);
    }

    public int size() {
        return this.msgs.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int num_msgs = this.msgs.size();
        sb.append(num_msgs).append(" msgs");
        if (this.retransmitter != null) {
            sb.append(" (").append(this.retransmitter.size()).append(" to retransmit)");
        }
        if (!this.msgs.isEmpty()) {
            sb.append(": ").append(this.msgs.firstKey()).append(" - ").append(this.msgs.lastKey());
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs");
        if (this.retransmitter != null) {
            sb.append(" (").append(this.retransmitter.size()).append(" to retransmit)");
        }
        sb.append(":\n");
        sb.append(this.msgs.keySet());
        return sb.toString();
    }

    @Override
    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        if (this.retransmit_command != null) {
            for (long i = first_seqno; i <= last_seqno; ++i) {
                Message msg = (Message)this.msgs.get(i);
                if (msg == null) continue;
                this.retransmit_command.retransmit(i, msg);
            }
        }
    }

    private void removeRange(long to) {
        this.msgs.headMap((Object)to, true).clear();
        if (this.retransmitter != null) {
            this.retransmitter.remove(to, true);
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, Message var3);
    }
}

