/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.distribution.topologyaware.TopologyLevel;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;

public class TopologyInfo {
    private final Map<String, Site> allSites = new HashMap<String, Site>();
    private List<Rack> allRacks = new ArrayList<Rack>();
    private List<Machine> allMachines = new ArrayList<Machine>();
    int allNodesCount;

    public TopologyInfo(Collection<Address> members) {
        for (Address node : members) {
            this.addTopology(node);
        }
    }

    private void addTopology(Address node) {
        Machine machine;
        Rack rack;
        TopologyAwareAddress taNode = (TopologyAwareAddress)node;
        String siteId = taNode.getSiteId();
        String rackId = taNode.getRackId();
        String machineId = taNode.getMachineId();
        Site site = this.allSites.get(siteId);
        if (site == null) {
            site = new Site(siteId);
            this.allSites.put(siteId, site);
        }
        if ((rack = site.racks.get(rackId)) == null) {
            rack = new Rack(siteId, rackId);
            site.racks.put(rackId, rack);
            this.allRacks.add(rack);
        }
        if ((machine = rack.machines.get(machineId)) == null) {
            machine = new Machine(siteId, rackId, machineId);
            rack.machines.put(machineId, machine);
            this.allMachines.add(machine);
        }
        machine.nodes.add(node);
        rack.nodes.add(node);
        site.nodes.add(node);
        ++this.allNodesCount;
    }

    public Collection<Address> getSiteNodes(String site) {
        return this.allSites.get((Object)site).nodes;
    }

    public Collection<Address> getRackNodes(String site, String rack) {
        return this.allSites.get((Object)site).racks.get((Object)rack).nodes;
    }

    public Collection<Address> getMachineNodes(String site, String rack, String machine) {
        return this.allSites.get((Object)site).racks.get((Object)rack).machines.get((Object)machine).nodes;
    }

    public Set<String> getAllSites() {
        return this.allSites.keySet();
    }

    public Set<String> getSiteRacks(String site) {
        return this.allSites.get((Object)site).racks.keySet();
    }

    public Set<String> getRackMachines(String site, String rack) {
        return this.allSites.get((Object)site).racks.get((Object)rack).machines.keySet();
    }

    public int getAllSitesCount() {
        return this.allSites.size();
    }

    public int getAllRacksCount() {
        return this.allRacks.size();
    }

    public int getAllMachinesCount() {
        return this.allMachines.size();
    }

    public int getAllNodesCount() {
        return this.allNodesCount;
    }

    public int getDistinctLocationsCount(TopologyLevel level, int numOwners) {
        switch (level) {
            case NODE: {
                return Math.min(numOwners, this.getAllNodesCount());
            }
            case MACHINE: {
                return Math.min(numOwners, this.getAllMachinesCount());
            }
            case RACK: {
                return Math.min(numOwners, this.getAllRacksCount());
            }
            case SITE: {
                return Math.min(numOwners, this.getAllSitesCount());
            }
        }
        throw new IllegalArgumentException("Unexpected topology level: " + (Object)((Object)level));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TopologyInfo{\n");
        for (Map.Entry<String, Site> site : this.allSites.entrySet()) {
            String siteId = site.getKey();
            sb.append(String.format("%s: {", siteId));
            for (Map.Entry<String, Rack> rack : site.getValue().racks.entrySet()) {
                String rackId = rack.getKey();
                sb.append(String.format("%s: {", rackId));
                for (Map.Entry<String, Machine> machine : rack.getValue().machines.entrySet()) {
                    String machineId = machine.getKey();
                    sb.append(String.format("%s: {", machineId));
                    for (Address node : machine.getValue().nodes) {
                        sb.append(node);
                        sb.append(", ");
                    }
                    sb.setLength(sb.length() - 2);
                    sb.append("}, ");
                }
                sb.setLength(sb.length() - 3);
                sb.append("}, ");
            }
            sb.setLength(sb.length() - 3);
            sb.append("}, ");
        }
        sb.setLength(sb.length() - 3);
        sb.append('}');
        return sb.toString();
    }

    public double computeMaxSegmentsForNode(int numSegments, double numCopies, int nodesCount) {
        if ((double)nodesCount < numCopies) {
            return numSegments;
        }
        return numCopies * (double)numSegments / (double)nodesCount;
    }

    public double computeMaxSegmentsForMachine(int numSegments, double numCopies, Collection<Machine> machines, Machine machine) {
        double copiesPerMachine = numCopies / (double)machines.size();
        if ((double)machine.nodes.size() <= copiesPerMachine) {
            copiesPerMachine = 1.0;
        } else {
            int fullMachines = 0;
            for (Machine m : machines) {
                if (!((double)m.nodes.size() <= copiesPerMachine)) continue;
                ++fullMachines;
            }
            copiesPerMachine = (numCopies - (double)fullMachines) / (double)(machines.size() - fullMachines);
        }
        return this.computeMaxSegmentsForNode(numSegments, copiesPerMachine, machine.nodes.size());
    }

    public double computeMaxSegmentsForRack(int numSegments, double numCopies, Collection<Rack> racks, Rack rack, Machine machine) {
        double copiesPerRack = numCopies / (double)racks.size();
        if ((double)rack.machines.size() <= copiesPerRack) {
            copiesPerRack = 1.0;
        } else {
            int fullRacks = 0;
            for (Rack m : racks) {
                if (!((double)m.machines.size() <= copiesPerRack)) continue;
                ++fullRacks;
            }
            copiesPerRack = (numCopies - (double)fullRacks) / (double)(racks.size() - fullRacks);
        }
        if (copiesPerRack <= 1.0) {
            return this.computeMaxSegmentsForNode(numSegments, copiesPerRack, rack.nodes.size());
        }
        return this.computeMaxSegmentsForMachine(numSegments, copiesPerRack, rack.machines.values(), machine);
    }

    public double computeMaxSegmentsForSite(int numSegments, double numCopies, Collection<Site> sites, Site site, Rack rack, Machine machine) {
        double copiesPerSite = numCopies / (double)sites.size();
        if ((double)site.racks.size() <= copiesPerSite) {
            copiesPerSite = 1.0;
        } else {
            int fullSites = 0;
            for (Site s : sites) {
                if (!((double)s.racks.size() <= copiesPerSite)) continue;
                ++fullSites;
            }
            copiesPerSite = (numCopies - (double)fullSites) / (double)(sites.size() - fullSites);
        }
        if (copiesPerSite <= 1.0) {
            return this.computeMaxSegmentsForNode(numSegments, copiesPerSite, site.nodes.size());
        }
        return this.computeMaxSegmentsForRack(numSegments, copiesPerSite, site.racks.values(), rack, machine);
    }

    public int computeMaxSegments(int numSegments, int numOwners, Address node) {
        TopologyAwareAddress taa = (TopologyAwareAddress)node;
        String siteId = taa.getSiteId();
        String rackId = taa.getRackId();
        String machineId = taa.getMachineId();
        Site site = this.allSites.get(siteId);
        Rack rack = site.racks.get(rackId);
        Machine machine = rack.machines.get(machineId);
        double maxSegments = numOwners == 1 ? this.computeMaxSegmentsForNode(numSegments, numOwners, this.allNodesCount) : (this.getAllNodesCount() <= numOwners ? (double)numSegments : (this.getAllMachinesCount() <= numOwners ? this.computeMaxSegmentsForMachine(numSegments, numOwners, this.allMachines, machine) : (this.getAllRacksCount() <= numOwners ? this.computeMaxSegmentsForRack(numSegments, numOwners, this.allRacks, rack, machine) : this.computeMaxSegmentsForSite(numSegments, numOwners, this.allSites.values(), site, rack, machine))));
        return (int)Math.ceil(maxSegments);
    }

    private static class Machine {
        String site;
        String rack;
        String machine;
        List<Address> nodes = new ArrayList<Address>();

        private Machine(String site, String rack, String machine) {
            this.site = site;
            this.rack = rack;
            this.machine = machine;
        }
    }

    private static class Rack {
        String site;
        String rack;
        Map<String, Machine> machines = new HashMap<String, Machine>();
        List<Address> nodes = new ArrayList<Address>();

        private Rack(String site, String rack) {
            this.site = site;
            this.rack = rack;
        }
    }

    private static class Site {
        String site;
        Map<String, Rack> racks = new HashMap<String, Rack>();
        List<Address> nodes = new ArrayList<Address>();

        private Site(String site) {
            this.site = site;
        }
    }
}

