/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.impl.AbstractInvocationContext;
import org.infinispan.util.InfinispanCollections;

public class NonTxInvocationContext
extends AbstractInvocationContext {
    private static final int INITIAL_CAPACITY = 4;
    protected final Map<Object, CacheEntry> lookedUpEntries;
    protected Set<Object> lockedKeys;

    public NonTxInvocationContext(int numEntries, boolean local) {
        this.lookedUpEntries = new HashMap<Object, CacheEntry>(numEntries);
        this.setOriginLocal(local);
    }

    public NonTxInvocationContext() {
        this.lookedUpEntries = new HashMap<Object, CacheEntry>(4);
    }

    @Override
    public CacheEntry lookupEntry(Object k) {
        return this.lookedUpEntries.get(k);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        this.lookedUpEntries.remove(key);
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> newLookedUpEntries) {
        this.lookedUpEntries.putAll(newLookedUpEntries);
    }

    @Override
    public void clearLookedUpEntries() {
        this.lookedUpEntries.clear();
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries == null ? InfinispanCollections.emptyMap() : this.lookedUpEntries;
    }

    @Override
    public boolean isOriginLocal() {
        return this.isContextFlagSet(AbstractInvocationContext.ContextFlag.ORIGIN_LOCAL);
    }

    public void setOriginLocal(boolean originLocal) {
        this.setContextFlag(AbstractInvocationContext.ContextFlag.ORIGIN_LOCAL, originLocal);
    }

    @Override
    public boolean isInTxScope() {
        return false;
    }

    @Override
    public Object getLockOwner() {
        return Thread.currentThread();
    }

    @Override
    public NonTxInvocationContext clone() {
        NonTxInvocationContext dolly = (NonTxInvocationContext)super.clone();
        dolly.lookedUpEntries.putAll(this.lookedUpEntries);
        return dolly;
    }

    @Override
    public void addLockedKey(Object key) {
        if (this.lockedKeys == null) {
            this.lockedKeys = new HashSet<Object>(4);
        }
        this.lockedKeys.add(key);
    }

    @Override
    public Set<Object> getLockedKeys() {
        return this.lockedKeys == null ? InfinispanCollections.emptySet() : this.lockedKeys;
    }

    @Override
    public void clearLockedKeys() {
        this.lockedKeys = null;
    }
}

