/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.schematic.DocumentLibrary;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.internal.document.Paths;
import org.infinispan.schematic.internal.schema.SchemaDocument;
import org.infinispan.schematic.internal.schema.SchemaDocumentCache;
import org.infinispan.schematic.internal.schema.ValidationResult;

public class DocumentValidationMapper
implements Mapper<String, SchematicEntry, String, SchemaLibrary.Results> {
    private static final long serialVersionUID = 1L;
    private final SchemaDocumentCache schemaLibrary;
    private final String defaultSchemaUri;

    public DocumentValidationMapper(DocumentLibrary schemaLibrary, String defaultSchemaUri) {
        this.schemaLibrary = new SchemaDocumentCache(schemaLibrary, null);
        this.defaultSchemaUri = defaultSchemaUri;
    }

    public void map(String key, SchematicEntry value, Collector<String, SchemaLibrary.Results> collector) {
        SchemaLibrary.Results results = this.validate(key, value);
        if (results != null && results.hasProblems()) {
            collector.emit((Object)key, (Object)results);
        }
    }

    public SchemaLibrary.Results validate(String key, SchematicEntry value) {
        Document doc = value.getContentAsDocument();
        if (doc == null) {
            return null;
        }
        Document metadata = value.getMetadata();
        if (metadata == null) {
            return null;
        }
        String schemaUri = metadata.getString("$schema", this.defaultSchemaUri);
        if (schemaUri == null) {
            return null;
        }
        ValidationResult problems = new ValidationResult();
        SchemaDocument schemaDoc = this.schemaLibrary.get(schemaUri, problems);
        if (schemaDoc != null) {
            schemaDoc.getValidator().validate(null, null, doc, Paths.rootPath(), problems, this.schemaLibrary);
        }
        return problems;
    }
}

